/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import micdoodle8.mods.galacticraft.api.tile.IColorable;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockTransmitter;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.items.ItemBlockDesc;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenPipe;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockOxygenPipe
extends BlockTransmitter
implements ITileEntityProvider,
ItemBlockDesc.IBlockShiftDesc {
    private IIcon[] pipeIcons = new IIcon[16];

    public BlockOxygenPipe(String assetName) {
        super(Material.field_151592_s);
        this.func_149711_c(0.3f);
        this.func_149672_a(Block.field_149778_k);
        this.func_149658_d(GalacticraftCore.TEXTURE_PREFIX + assetName);
        this.func_149663_c(assetName);
    }

    public void func_149749_a(World par1World, int par2, int par3, int par4, Block par5, int par6) {
        TileEntityOxygenPipe tile = (TileEntityOxygenPipe)par1World.func_147438_o(par2, par3, par4);
        if (tile != null && tile.getColor() != 15) {
            float f = 0.7f;
            double d0 = (double)(par1World.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            double d1 = (double)(par1World.field_73012_v.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
            double d2 = (double)(par1World.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            EntityItem entityitem = new EntityItem(par1World, (double)par2 + d0, (double)par3 + d1, (double)par4 + d2, new ItemStack(Items.field_151100_aR, 1, (int)tile.getColor()));
            entityitem.field_145804_b = 10;
            par1World.func_72838_d((Entity)entityitem);
        }
        super.func_149749_a(par1World, par2, par3, par4, par5, par6);
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z, block);
        world.func_147479_m(x, y, z);
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess par1IBlockAccess, int x, int y, int z, int par5) {
        BlockVec3 thisVec = new BlockVec3(x, y, z).modifyPositionFromSide(ForgeDirection.getOrientation((int)par5));
        Block blockAt = thisVec.getBlock(par1IBlockAccess);
        TileEntityOxygenPipe tileEntity = (TileEntityOxygenPipe)par1IBlockAccess.func_147438_o(x, y, z);
        if (blockAt == GCBlocks.oxygenPipe && ((TileEntityOxygenPipe)thisVec.getTileEntity(par1IBlockAccess)).getColor() == tileEntity.getColor()) {
            return this.pipeIcons[15];
        }
        return this.pipeIcons[tileEntity.getColor()];
    }

    public boolean func_149727_a(World par1World, int x, int y, int z, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        ItemStack stack;
        TileEntityOxygenPipe tileEntity = (TileEntityOxygenPipe)par1World.func_147438_o(x, y, z);
        if (!par1World.field_72995_K && (stack = par5EntityPlayer.field_71071_by.func_70448_g()) != null && stack.func_77973_b() instanceof ItemDye) {
            int dyeColor = par5EntityPlayer.field_71071_by.func_70448_g().func_77952_i();
            byte colorBefore = tileEntity.getColor();
            tileEntity.setColor((byte)dyeColor);
            if (colorBefore != (byte)dyeColor && !par5EntityPlayer.field_71075_bZ.field_75098_d && --par5EntityPlayer.field_71071_by.func_70448_g().field_77994_a == 0) {
                par5EntityPlayer.field_71071_by.field_70462_a[par5EntityPlayer.field_71071_by.field_70461_c] = null;
            }
            if (colorBefore != (byte)dyeColor && colorBefore != 15) {
                float f = 0.7f;
                double d0 = (double)(par1World.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
                double d1 = (double)(par1World.field_73012_v.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
                double d2 = (double)(par1World.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
                EntityItem entityitem = new EntityItem(par1World, (double)x + d0, (double)y + d1, (double)z + d2, new ItemStack(Items.field_151100_aR, 1, (int)colorBefore));
                entityitem.field_145804_b = 10;
                par1World.func_72838_d((Entity)entityitem);
            }
            BlockVec3 tileVec = new BlockVec3(tileEntity);
            for (ForgeDirection dir : ForgeDirection.values()) {
                TileEntity tileAt = tileVec.getTileEntityOnSide(tileEntity.func_145831_w(), dir);
                if (!(tileAt instanceof IColorable)) continue;
                ((IColorable)tileAt).onAdjacentColorChanged(dir);
            }
            return true;
        }
        return false;
    }

    public int func_149645_b() {
        return GalacticraftCore.proxy.getBlockRender((Block)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.pipeIcons = new IIcon[16];
        for (int count = 0; count < ItemDye.field_150923_a.length; ++count) {
            this.pipeIcons[count] = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "pipe_oxygen_" + ItemDye.field_150923_a[count]);
        }
        this.field_149761_L = this.pipeIcons[15];
    }

    public boolean func_149646_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return true;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityOxygenPipe();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int i, int j, int k) {
        return this.func_149668_a(world, i, j, k);
    }

    @Override
    public NetworkType getNetworkType() {
        return NetworkType.OXYGEN;
    }

    @Override
    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate(this.func_149739_a() + ".description");
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }
}

