/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.item;

import binnie.Binnie;
import binnie.core.genetics.BreedingSystem;
import binnie.core.genetics.Gene;
import binnie.core.util.I18N;
import binnie.genetics.Genetics;
import binnie.genetics.api.IGene;
import binnie.genetics.api.IItemSerum;
import binnie.genetics.genetics.GeneItem;
import binnie.genetics.item.ItemGene;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.ISpeciesRoot;
import java.util.List;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemSerum
extends ItemGene
implements IItemSerum {
    public ItemSerum() {
        super("serum");
        this.func_77656_e(16);
    }

    public static ItemStack create(IGene gene) {
        ItemStack item = new ItemStack(Genetics.itemSerum);
        item.func_77964_b(item.func_77958_k());
        GeneItem seq = new GeneItem(gene);
        seq.writeToItem(item);
        return item;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        super.func_77624_a(stack, player, tooltip, advanced);
    }

    @Override
    public int getCharges(ItemStack stack) {
        return stack.func_77973_b().func_77612_l() - stack.func_77960_j();
    }

    @Override
    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (ISpeciesRoot root : AlleleManager.alleleRegistry.getSpeciesRoot().values()) {
            Map<IChromosomeType, List<IAllele>> chromosomeMap = Binnie.Genetics.getChromosomeMap(root);
            for (Map.Entry<IChromosomeType, List<IAllele>> entry : chromosomeMap.entrySet()) {
                IChromosomeType chromosome = entry.getKey();
                for (IAllele allele : entry.getValue()) {
                    Gene gene = Gene.create(allele, chromosome, root);
                    if (gene == null) continue;
                    GeneItem geneItem = new GeneItem(gene);
                    ItemStack stack = new ItemStack((Item)this);
                    geneItem.writeToItem(stack);
                    list.add(stack);
                }
            }
        }
    }

    @Override
    public IGene[] getGenes(ItemStack stack) {
        return new IGene[]{this.getGeneItem(stack).getGene()};
    }

    @Override
    public ISpeciesRoot getSpeciesRoot(ItemStack stack) {
        return this.getGeneItem(stack).getSpeciesRoot();
    }

    @Override
    public IGene getGene(ItemStack stack, int chromosome) {
        return this.getGeneItem(stack).getGene();
    }

    @Override
    public GeneItem getGeneItem(ItemStack stack) {
        return new GeneItem(stack);
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        GeneItem gene = this.getGeneItem(stack);
        BreedingSystem breedingSystem = Binnie.Genetics.getSystem(gene.getSpeciesRoot());
        if (breedingSystem != null) {
            return I18N.localise("genetics.item.serum.name", breedingSystem.getDescriptor());
        }
        return I18N.localise("genetics.item.serumEmpty.name");
    }

    @Override
    public ItemStack addGene(ItemStack stack, IGene gene) {
        GeneItem geneItem = this.getGeneItem(stack);
        geneItem.addGene(gene);
        geneItem.writeToItem(stack);
        return stack;
    }
}

