/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.worldgen;

import binnie.Binnie;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.apiculture.IHiveDrop;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IIndividual;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class HiveDrop
implements IHiveDrop {
    private final IAllele[] template;
    private final ArrayList<ItemStack> additional = new ArrayList();
    private final int chance;

    public HiveDrop(IAlleleBeeSpecies species, int chance) {
        this(Binnie.Genetics.getBeeRoot().getTemplate(species.getUID()), new ItemStack[0], chance);
    }

    public HiveDrop(IAllele[] template, ItemStack[] bonus, int chance) {
        if (template == null) {
            template = Binnie.Genetics.getBeeRoot().getDefaultTemplate();
        }
        this.template = template;
        this.chance = chance;
        Collections.addAll(this.additional, bonus);
    }

    public ItemStack getPrincess(World world, int x, int y, int z, int fortune) {
        IBeeRoot beeRoot = Binnie.Genetics.getBeeRoot();
        return beeRoot.getMemberStack((IIndividual)beeRoot.getBee(world, beeRoot.templateAsGenome(this.template)), EnumBeeType.PRINCESS.ordinal());
    }

    public ArrayList<ItemStack> getDrones(World world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        IBeeRoot beeRoot = Binnie.Genetics.getBeeRoot();
        ret.add(beeRoot.getMemberStack((IIndividual)beeRoot.templateAsIndividual(this.template), EnumBeeType.DRONE.ordinal()));
        return ret;
    }

    public ArrayList<ItemStack> getAdditional(World world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (ItemStack stack : this.additional) {
            ret.add(stack.func_77946_l());
        }
        return ret;
    }

    public int getChance(World world, int x, int y, int z) {
        return this.chance;
    }
}

