/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.inventory;

import binnie.core.machines.inventory.BaseSlot;
import binnie.core.util.I18N;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;

public class TankSlot
extends BaseSlot<FluidStack> {
    public static final String NAME_JUICE = "Juice Tank";
    public static final String NAME_WATER = "Water Tank";
    public static final String NAME_CUPBOARD = "Cupboard Slot";
    private final FluidTank tank;

    public TankSlot(int index, String name, int capacity) {
        super(index, name);
        this.tank = new FluidTank(capacity);
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        FluidStack liquid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbttagcompound);
        this.setContent(liquid);
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        FluidStack content = this.getContent();
        if (content != null) {
            content.writeToNBT(nbttagcompound);
        }
    }

    @Override
    public FluidStack getContent() {
        return this.tank.getFluid();
    }

    @Override
    public void setContent(FluidStack itemStack) {
        this.tank.setFluid(itemStack);
    }

    public IFluidTank getTank() {
        return this.tank;
    }

    @Override
    public String getName() {
        return I18N.localise("binniecore.gui.slot." + this.unlocName);
    }
}

