/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.minecraft.control;

import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.minecraft.InventoryType;
import binnie.core.craftgui.minecraft.control.ControlSlot;
import binnie.core.network.packet.MessageCraftGUI;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagList;

public class ControlPlayerInventory
extends Control {
    private final List<ControlSlot> slots = new ArrayList<ControlSlot>();

    public ControlPlayerInventory(IWidget parent, boolean wide) {
        super(parent, (int)(parent.getSize().x() / 2.0f) - (wide ? 110 : 81), (int)parent.getSize().y() - (wide ? 54 : 76) - 12, wide ? 220.0f : 162.0f, wide ? 54.0f : 76.0f);
        int i1;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                ControlSlot slot = new ControlSlot(this, (wide ? 58 : 0) + column * 18, row * 18);
                this.slots.add(slot);
            }
        }
        if (wide) {
            for (i1 = 0; i1 < 9; ++i1) {
                ControlSlot slot2 = new ControlSlot(this, i1 % 3 * 18, i1 / 3 * 18);
                this.slots.add(slot2);
            }
        } else {
            for (i1 = 0; i1 < 9; ++i1) {
                ControlSlot slot2 = new ControlSlot(this, i1 * 18, 58.0f);
                this.slots.add(slot2);
            }
        }
    }

    public ControlPlayerInventory(IWidget parent) {
        this(parent, false);
    }

    public ControlPlayerInventory(IWidget parent, int x, int y) {
        super(parent, x, y, 54.0f, 220.0f);
        for (int row = 0; row < 6; ++row) {
            for (int column = 0; column < 6; ++column) {
                ControlSlot slot = new ControlSlot(this, column * 18, row * 18);
                this.slots.add(slot);
            }
        }
    }

    public ControlPlayerInventory create(NBTTagList actions) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                ControlSlot slot = this.slots.get(column + row * 9);
                slot.assign(actions, InventoryType.Player, 9 + column + row * 9);
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            ControlSlot slot2 = this.slots.get(27 + i1);
            slot2.assign(actions, InventoryType.Player, i1);
        }
        return this;
    }

    public ControlPlayerInventory createAndRegister() {
        NBTTagList actions = new NBTTagList();
        this.create(actions);
        MessageCraftGUI.sendToServer(actions);
        return this;
    }
}

