/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer;

import net.malisis.core.renderer.Parameter;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class RenderParameters
implements ITransformable.Color,
ITransformable.Alpha,
ITransformable.Brightness {
    protected Parameter[] listParams;
    public Parameter<Boolean> renderAllFaces = new Parameter<Boolean>(false);
    public Parameter<Boolean> useBlockBounds = new Parameter<Boolean>(true);
    public Parameter<AxisAlignedBB> renderBounds = new Parameter<Object>(null);
    public Parameter<Boolean> vertexPositionRelativeToRenderBounds = new Parameter<Boolean>(true);
    public Parameter<Boolean> useCustomTexture = new Parameter<Boolean>(false);
    public Parameter<Boolean> applyTexture = new Parameter<Boolean>(true);
    public Parameter<IIcon> icon = new Parameter<Object>(null);
    public Parameter<Boolean> useWorldSensitiveIcon = new Parameter<Boolean>(true);
    public Parameter<Boolean> useTexture = new Parameter<Boolean>(true);
    public Parameter<Boolean> interpolateUV = new Parameter<Boolean>(true);
    public Parameter<Boolean> calculateAOColor = new Parameter<Boolean>(true);
    public Parameter<Boolean> calculateBrightness = new Parameter<Boolean>(true);
    public Parameter<Boolean> usePerVertexColor = new Parameter<Boolean>(false);
    public Parameter<Boolean> usePerVertexAlpha = new Parameter<Boolean>(false);
    public Parameter<Boolean> usePerVertexBrightness = new Parameter<Boolean>(false);
    public Parameter<Boolean> useEnvironmentBrightness = new Parameter<Boolean>(true);
    public Parameter<Boolean> useNormals = new Parameter<Boolean>(false);
    public Parameter<Integer> colorMultiplier = new Parameter<Object>(null);
    public Parameter<Float> colorFactor = new Parameter<Float>(Float.valueOf(1.0f));
    public Parameter<Integer> brightness = new Parameter<Integer>(0xF00000);
    public Parameter<Integer> alpha = new Parameter<Integer>(255);
    public Parameter<ForgeDirection> direction = new Parameter<Object>(null);
    public Parameter<ForgeDirection> textureSide = new Parameter<Object>(null);
    public Parameter<int[][][]> aoMatrix = new Parameter<Object>(null);
    public Parameter<Boolean> flipU = new Parameter<Boolean>(false);
    public Parameter<Boolean> flipV = new Parameter<Boolean>(false);

    public RenderParameters() {
        this.listParams = new Parameter[]{this.renderAllFaces, this.useBlockBounds, this.renderBounds, this.vertexPositionRelativeToRenderBounds, this.useCustomTexture, this.applyTexture, this.icon, this.useWorldSensitiveIcon, this.useTexture, this.interpolateUV, this.calculateAOColor, this.calculateBrightness, this.usePerVertexColor, this.usePerVertexAlpha, this.usePerVertexBrightness, this.useEnvironmentBrightness, this.useNormals, this.colorMultiplier, this.colorFactor, this.brightness, this.alpha, this.direction, this.textureSide, this.aoMatrix, this.flipU, this.flipV};
    }

    public RenderParameters(RenderParameters params) {
        this();
        this.merge(params);
    }

    private Parameter<?> getParameter(int index) {
        if (index < 0 || index >= this.listParams.length) {
            return null;
        }
        return this.listParams[index];
    }

    public void init() {
        this.renderAllFaces.set(true);
        this.calculateAOColor.set(false);
        this.useBlockBounds.set(false);
        this.useEnvironmentBrightness.set(false);
        this.calculateBrightness.set(false);
        this.interpolateUV.set(false);
    }

    public void reset() {
        for (Parameter param : this.listParams) {
            param.reset();
        }
    }

    public void merge(RenderParameters params) {
        if (params == null) {
            return;
        }
        for (int i = 0; i < this.listParams.length; ++i) {
            this.listParams[i].merge(params.listParams[i]);
        }
    }

    @Override
    public void setAlpha(int alpha) {
        this.alpha.set(alpha);
    }

    @Override
    public void setColor(int color) {
        this.colorMultiplier.set(color);
    }

    @Override
    public void setBrightness(int brightness) {
        this.brightness.set(brightness);
    }
}

