/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.ItemPanels;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.Widget;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerInputHandler;
import codechicken.nei.recipe.StackInfo;
import java.awt.Point;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class ItemZoom
extends Widget
implements IContainerInputHandler {
    public static final int MIN_ZOOM = 0;
    public static final int MAX_ZOOM = 1000;
    private static final int MIN_SCALE = 2;
    private static final int SLOT_SIZE = 16;
    private Boolean previousKeyboardRepeatEnabled = null;
    private ItemStack stack = null;
    private String displayName = "";
    private int availableAreaWidth = 0;
    private float xPosition = 0.0f;
    private float yPosition = 0.0f;
    private float scale = 1.0f;

    public ItemZoom() {
        GuiContainerManager.addInputHandler(this);
    }

    @Override
    public void draw(int mx, int my) {
        if (this.stack != null && this.availableAreaWidth >= 32 && (NEIClientConfig.getBooleanSetting("inventory.itemzoom.enabled") || NEIClientConfig.isKeyHashDown("gui.itemzoom_hold")) && GuiContainerManager.shouldShowTooltip(NEIClientUtils.getGuiContainer())) {
            String keyName;
            float inverseScaleFactor = 1.0f / this.scale;
            float screenScale = this.getScreenScale();
            float size = 16.0f * this.scale;
            int shiftText = 10;
            GL11.glPushMatrix();
            GL11.glScaled((double)screenScale, (double)screenScale, (double)1.0);
            GL11.glScaled((double)this.scale, (double)this.scale, (double)2.0);
            GL11.glTranslated((double)(this.xPosition * inverseScaleFactor), (double)(this.yPosition * inverseScaleFactor), (double)0.0);
            GuiContainerManager.drawItem(0, 0, this.stack, false, "");
            GL11.glPopMatrix();
            GL11.glPushAttrib((int)24640);
            GuiContainerManager.enable2DRender();
            if (NEIClientConfig.getBooleanSetting("inventory.itemzoom.showName")) {
                String dispalyName = NEIClientUtils.cropText(GuiDraw.fontRenderer, this.displayName, this.availableAreaWidth);
                GuiDraw.drawStringC((String)dispalyName, (int)((int)((this.xPosition + size / 2.0f) * screenScale)), (int)((int)((this.yPosition + size) * screenScale) + shiftText), (int)NEIClientConfig.getSetting("inventory.itemzoom.nameColor").getHexValue());
                shiftText += GuiDraw.fontRenderer.field_78288_b;
            }
            if (NEIClientConfig.getBooleanSetting("inventory.itemzoom.enabled") && NEIClientConfig.getBooleanSetting("inventory.itemzoom.helpText") && (keyName = NEIClientConfig.getKeyName("gui.itemzoom_toggle")) != null) {
                String helpText = NEIClientUtils.translate("itemzoom.toggle", keyName);
                List lines = GuiDraw.fontRenderer.func_78271_c(helpText, this.availableAreaWidth);
                for (String line : lines) {
                    GuiDraw.drawStringC((String)line, (int)((int)((this.xPosition + size / 2.0f) * screenScale)), (int)((int)((this.yPosition + size) * screenScale) + 10 + shiftText), (int)0x66555555);
                    shiftText += GuiDraw.fontRenderer.field_78288_b;
                }
            }
            GL11.glPopAttrib();
        }
    }

    public void resize(GuiContainer gui) {
        ItemStack stack = this.getStackMouseOver(gui);
        if (stack != null && (!NEIClientConfig.getBooleanSetting("inventory.itemzoom.onlySolid") || Block.func_149634_a((Item)stack.func_77973_b()).func_149688_o().func_76220_a())) {
            float screenScale = 1.0f / this.getScreenScale();
            float availableAreaWidth = (float)((gui.field_146294_l - gui.field_146999_f) / 2) * screenScale;
            float availableAreaHeight = (float)gui.field_146295_m * screenScale;
            Point mouse = GuiDraw.getMousePosition();
            this.scale = Math.round((float)this.getZoomAmount(gui) * this.getPointSize(gui) / 16.0f);
            this.yPosition = (availableAreaHeight - this.scale * 16.0f) / 2.0f;
            this.xPosition = (availableAreaWidth - this.scale * 16.0f) / 2.0f;
            this.availableAreaWidth = (int)(availableAreaWidth / screenScale);
            if (availableAreaWidth / screenScale >= (float)mouse.x) {
                this.xPosition += (float)gui.field_146294_l * screenScale - availableAreaWidth;
            }
            try {
                this.displayName = stack.func_82833_r();
            }
            catch (Throwable ignored) {
                this.displayName = "Unnamed";
            }
            this.stack = StackInfo.loadFromNBT(StackInfo.itemStackToNBT(stack), 0L);
        } else {
            this.stack = null;
            this.displayName = "";
        }
    }

    private float getPointSize(GuiContainer gui) {
        float screenScale = 1.0f / this.getScreenScale();
        float availableAreaWidth = (float)(gui.field_146294_l - (gui.field_146999_f + gui.field_146294_l) / 2) * screenScale;
        return availableAreaWidth / 1000.0f;
    }

    private float getScreenScale() {
        return (float)Minecraft.func_71410_x().field_71462_r.field_146294_l * 1.0f / (float)Minecraft.func_71410_x().field_71443_c;
    }

    private int getZoomAmount(GuiContainer gui) {
        return Math.max(Math.round(32.0f / this.getPointSize(gui)), NEIClientConfig.getIntSetting("inventory.itemzoom.zoom"));
    }

    private void increaseZoom(GuiContainer gui) {
        float pointSize = this.getPointSize(gui);
        float scale = Math.round((float)this.getZoomAmount(gui) * pointSize / 16.0f);
        NEIClientConfig.setIntSetting("inventory.itemzoom.zoom", Math.min(1000, Math.round((scale + 1.0f) / (pointSize / 16.0f))));
    }

    private void decreaseZoom(GuiContainer gui) {
        float pointSize = this.getPointSize(gui);
        float scale = Math.round((float)this.getZoomAmount(gui) * pointSize / 16.0f);
        NEIClientConfig.setIntSetting("inventory.itemzoom.zoom", Math.max(0, Math.round(Math.max(2.0f, scale - 1.0f) / (pointSize / 16.0f))));
    }

    private ItemStack getStackMouseOver(GuiContainer gui) {
        if (NEIClientConfig.getBooleanSetting("inventory.itemzoom.neiOnly")) {
            Point mouse = GuiDraw.getMousePosition();
            ItemStack stack = ItemPanels.itemPanel.getStackMouseOver(mouse.x, mouse.y);
            if (stack == null) {
                stack = ItemPanels.bookmarkPanel.getStackMouseOver(mouse.x, mouse.y);
            }
            if (stack == null) {
                stack = ItemPanels.itemPanel.historyPanel.getStackMouseOver(mouse.x, mouse.y);
            }
            return stack;
        }
        return GuiContainerManager.getStackMouseOver(gui);
    }

    @Override
    public boolean keyTyped(GuiContainer gui, char keyChar, int keyCode) {
        return false;
    }

    @Override
    public boolean mouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
        return false;
    }

    @Override
    public void onKeyTyped(GuiContainer gui, char keyChar, int keyID) {
    }

    @Override
    public boolean lastKeyTyped(GuiContainer gui, char keyChar, int keyID) {
        if (NEIClientConfig.isKeyHashDown("gui.itemzoom_toggle")) {
            NEIClientConfig.getSetting("inventory.itemzoom.enabled").setBooleanValue(!NEIClientConfig.getBooleanSetting("inventory.itemzoom.enabled"));
            return true;
        }
        if (this.stack != null && NEIClientConfig.isKeyHashDown("gui.itemzoom_hold")) {
            return true;
        }
        if (this.stack != null && NEIClientConfig.isKeyHashDown("gui.itemzoom_zoom_in")) {
            this.increaseZoom(gui);
            this.previousKeyboardRepeatEnabled = Keyboard.areRepeatEventsEnabled();
            Keyboard.enableRepeatEvents((boolean)true);
            return true;
        }
        if (this.stack != null && NEIClientConfig.isKeyHashDown("gui.itemzoom_zoom_out")) {
            this.decreaseZoom(gui);
            this.previousKeyboardRepeatEnabled = Keyboard.areRepeatEventsEnabled();
            Keyboard.enableRepeatEvents((boolean)true);
            return true;
        }
        if (this.previousKeyboardRepeatEnabled != null) {
            Keyboard.enableRepeatEvents((boolean)this.previousKeyboardRepeatEnabled);
            this.previousKeyboardRepeatEnabled = null;
        }
        return false;
    }

    @Override
    public void onMouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
    }

    @Override
    public void onMouseUp(GuiContainer gui, int mousex, int mousey, int button) {
    }

    @Override
    public boolean mouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
        return false;
    }

    @Override
    public void onMouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
    }

    @Override
    public void onMouseDragged(GuiContainer gui, int mousex, int mousey, int button, long heldTime) {
    }
}

