/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.handler.Recipes;

import gregtech.api.enums.GTValues;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTRecipeConstants;
import gregtech.api.util.GTUtility;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class DecayableRecipe {
    public static final ArrayList<DecayableRecipe> mRecipes = new ArrayList();
    public final int mTime;
    public final ItemStack mInput;
    public final ItemStack mOutput;

    public DecayableRecipe(int time, ItemStack input, ItemStack output, GTRecipeConstants.DecayType decayType) {
        this.mTime = time;
        this.mInput = input;
        this.mOutput = output;
        mRecipes.add(this);
        GTValues.RA.stdBuilder().itemInputs(input).itemOutputs(output).eut(1).duration(1).metadata(GTRecipeConstants.HALF_LIFE, (double)time / 40.0).metadata(GTRecipeConstants.DECAY_TYPE, decayType).addTo(RecipeMaps.isotopeDecay);
    }

    public boolean equals(Object o) {
        if (o instanceof DecayableRecipe) {
            DecayableRecipe i = (DecayableRecipe)o;
            return i.mTime == this.mTime && GTUtility.areStacksEqual(this.mInput, i.mInput) && GTUtility.areStacksEqual(this.mOutput, i.mOutput);
        }
        return false;
    }

    public boolean isValid() {
        return this.mTime > 0 && this.mInput != null && this.mOutput != null;
    }
}

