/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi.drone;

import appeng.api.util.DimensionalCoord;
import appeng.client.render.BlockPosHighlighter;
import com.google.common.collect.HashMultimap;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizon.structurelib.util.Vec3Impl;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.forge.ItemStackHandler;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.math.MainAxisAlignment;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Interactable;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.DynamicPositionedRow;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.Row;
import com.gtnewhorizons.modularui.common.widget.Scrollable;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.TextFieldWidget;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.objects.XSTR;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.shutdown.ShutDownReason;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gregtech.common.gui.modularui.widget.ShutDownReasonSyncer;
import gregtech.common.items.ItemTierDrone;
import gregtech.common.tileentities.machines.multi.drone.DroneConnection;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class MTEDroneCentre
extends MTEExtendedPowerMultiBlockBase<MTEDroneCentre>
implements ISurvivalConstructable {
    private static final IIconContainer ACTIVE = new Textures.BlockIcons.CustomIcon("iconsets/DRONE_CENTRE_ACTIVE");
    private static final IIconContainer FACE = new Textures.BlockIcons.CustomIcon("iconsets/DRONE_CENTRE_FACE");
    private static final IIconContainer INACTIVE = new Textures.BlockIcons.CustomIcon("iconsets/DRONE_CENTRE_INACTIVE");
    public static final int CASING_INDEX = GTUtility.getCasingTextureIndex(GregTechAPI.sBlockCasings4, 2);
    private final int MACHINE_LIST_WINDOW_ID = 10;
    private final int CUSTOM_NAME_WINDOW_ID = 11;
    private static final int CASINGS_MIN = 85;
    private int mCasingAmount = 0;
    private Vec3Impl centreCoord;
    private int droneLevel = 0;
    private int buttonID;
    private String searchFilter = "";
    private boolean useRender = true;
    private boolean showLocalizedName = false;
    private String sort = "distance";
    private List<DroneConnection> connectionList = new ArrayList<DroneConnection>();
    public HashMap<String, String> tempNameList = new HashMap();
    private static final HashMultimap<Integer, MTEDroneCentre> droneMap = HashMultimap.create();
    private static final IStructureDefinition<MTEDroneCentre> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"     ", "     ", "     ", "     ", "CCCCC", "CCCCC", "CCCCC", "CCCCC", "CCCCC"}, {"CC~CC", "C   C", "C   C", "C   C", "CAAAC", "CCCCC", "CAAAC", "C   C", "CCCCC"}, {"CCCCC", "CBBBC", "CBDBC", "CBBBC", "CCCCC", "CCCCC", "CCCCC", "CCCCC", "CCCCC"}, {"C   C", "     ", "     ", "     ", "     ", "     ", "     ", "     ", "C   C"}})).addElement('C', GTStructureUtility.buildHatchAdder(MTEDroneCentre.class).atLeast(HatchElement.InputBus).casingIndex(CASING_INDEX).dot(1).buildAndChain(StructureUtility.onElementPass(MTEDroneCentre::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)2)))).addElement('A', GTStructureUtility.chainAllGlasses()).addElement('B', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings1, (int)11)).addElement('D', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)0)).build();

    public MTEDroneCentre(String name) {
        super(name);
    }

    public MTEDroneCentre(int ID, String Name2, String NameRegional) {
        super(ID, Name2, NameRegional);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEDroneCentre(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            if (this.getBaseMetaTileEntity().isActive()) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(CASING_INDEX), TextureFactory.builder().addIcon(ACTIVE).extFacing().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(CASING_INDEX), TextureFactory.builder().addIcon(INACTIVE).extFacing().build()};
        }
        if (side == aFacing.getOpposite()) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(CASING_INDEX), TextureFactory.builder().addIcon(FACE).extFacing().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(CASING_INDEX)};
    }

    @Override
    public IStructureDefinition<MTEDroneCentre> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean supportsPowerPanel() {
        return false;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Drone Centre").addInfo(EnumChatFormatting.AQUA + "Drone #10032, cleared for takeoff!").addInfo("Monitors multiblock machines in range").addInfo("Replace maintenance hatch on other multi with drone downlink module").addInfo("Provides maintenance, power control, monitoring, and more").addInfo("Range is determined by drone tier: T1-128, T2-512, T3-4096").addInfo("Place drones in input bus; only one needed to operate").addInfo("Automatically upgrade based on the drone level in the input bus").addInfo("There is a chance per second that the drone will crash").addInfo("Chance is determined by drone tier: T1-1/28800, T2-1/172800, T3-0").addInfo("If machine is too far, remote control would not available").beginStructureBlock(5, 4, 9, false).addController("Front center").addCasingInfoRange("Stable Titanium Machine Casing", 85, 91, false).addCasingInfoExactly("Heat Proof Machine Casing", 8, false).addCasingInfoExactly("Robust Tungstensteel Machine Casing", 1, false).addCasingInfoExactly("Any tiered glass", 6, false).addInputBus("Any Titanium Casing", 1).addStructureInfo("No maintenance hatch needed").toolTipFinisher(GTValues.AuthorSilverMoon);
        return tt;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece("main", stackSize, hintsOnly, 2, 1, 0);
    }

    public int survivalConstruct(ItemStack stack, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece("main", stack, 2, 1, 0, elementBudget, env, false, true);
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> (d.flag & (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag)) == 0 && r.isNotRotated() && !f.isVerticallyFliped();
    }

    private void onCasingAdded() {
        ++this.mCasingAmount;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasingAmount = 0;
        return this.checkPiece("main", 2, 1, 0) && this.mCasingAmount >= 85;
    }

    @Override
    public final void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        super.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ, aTool);
        this.useRender = !this.useRender;
        aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("GT5U.machines.dronecentre." + (this.useRender ? "enableRender" : "disableRender"), new Object[0]));
        if (this.useRender) {
            this.createRenderBlock();
        } else {
            this.destroyRenderBlock();
        }
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return true;
    }

    @Override
    public void stopMachine(@NotNull ShutDownReason reason) {
        this.destroyRenderBlock();
        super.stopMachine(reason);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && aTick % 20L == 0L) {
            int n;
            switch (this.droneLevel) {
                case 1: {
                    n = this.getBaseMetaTileEntity().getRandomNumber(28800);
                    break;
                }
                case 2: {
                    n = this.getBaseMetaTileEntity().getRandomNumber(172800);
                    break;
                }
                default: {
                    n = 1;
                }
            }
            if (n == 0) {
                this.droneLevel = 0;
                this.startRecipeProcessing();
                if (!this.tryConsumeDrone()) {
                    this.stopMachine(ShutDownReasonRegistry.outOfStuff("Any Drone", 1));
                }
                this.endRecipeProcessing();
            }
        }
        if (this.mMaxProgresstime > 0 && this.mMaxProgresstime - this.mProgresstime == 1) {
            this.destroyRenderBlock();
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.droneLevel = aNBT.func_74762_e("drone");
        this.useRender = aNBT.func_74767_n("useRender");
        this.sort = aNBT.func_74779_i("sort");
        NBTTagCompound nameList = aNBT.func_74775_l("conList");
        for (String s : nameList.func_150296_c()) {
            this.tempNameList.put(s, nameList.func_74779_i(s));
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("drone", this.droneLevel);
        aNBT.func_74757_a("useRender", this.useRender);
        aNBT.func_74778_a("sort", this.sort);
        NBTTagCompound conList = new NBTTagCompound();
        for (DroneConnection con : this.connectionList) {
            if (con.customName.equals(con.machine.getLocalName())) continue;
            conList.func_74778_a(con.machineCoord.toString(), con.customName);
        }
        for (String pos : this.tempNameList.keySet()) {
            conList.func_74778_a(pos, this.tempNameList.get(pos));
        }
        aNBT.func_74782_a("conList", (NBTBase)conList);
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
        tag.func_74768_a("connectionCount", this.connectionList.size());
        if (this.droneLevel != 0) {
            tag.func_74768_a("droneLevel", this.droneLevel);
        }
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound tag = accessor.getNBTData();
        currenttip.add(EnumChatFormatting.AQUA + StatCollector.func_74837_a((String)"GT5U.waila.drone_downlink.droneLevel", (Object[])new Object[]{tag.func_74762_e("droneLevel")}));
        currenttip.add(StatCollector.func_74837_a((String)"GT5U.waila.drone_downlink.connectionCount", (Object[])new Object[]{tag.func_74762_e("connectionCount")}));
        super.getWailaBody(itemStack, currenttip, accessor, config);
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        if (this.droneLevel == 0 && !this.tryConsumeDrone()) {
            return SimpleCheckRecipeResult.ofFailure("drone_noDrone");
        }
        if (this.droneLevel == 1 || this.droneLevel == 2) {
            this.tryUpdateDrone();
        }
        this.mMaxProgresstime = 200 * this.droneLevel;
        this.createRenderBlock();
        return SimpleCheckRecipeResult.ofSuccess("drone_operating");
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        if (aBaseMetaTileEntity.isServerSide()) {
            if (droneMap.containsValue((Object)this)) {
                return;
            }
            this.centreCoord = new Vec3Impl(this.getBaseMetaTileEntity().getXCoord(), (int)this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord());
            droneMap.put((Object)this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g, (Object)this);
        }
    }

    @Override
    public void onBlockDestroyed() {
        this.destroyRenderBlock();
        this.connectionList.clear();
        if (this.droneLevel != 0) {
            this.spawnDroneItem();
        }
        super.onBlockDestroyed();
    }

    private void spawnDroneItem() {
        Item item;
        switch (this.droneLevel) {
            case 1: {
                item = ItemList.TierdDrone0.getItem();
                break;
            }
            case 2: {
                item = ItemList.TierdDrone1.getItem();
                break;
            }
            case 3: {
                item = ItemList.TierdDrone2.getItem();
                break;
            }
            default: {
                item = null;
            }
        }
        ItemStack insideDrone = new ItemStack(item, 1);
        EntityItem tItemEntity = new EntityItem(this.getBaseMetaTileEntity().getWorld(), (double)((float)this.getBaseMetaTileEntity().getXCoord() + XSTR.XSTR_INSTANCE.nextFloat() * 0.8f + 0.1f), (double)((float)this.getBaseMetaTileEntity().getYCoord() + XSTR.XSTR_INSTANCE.nextFloat() * 0.8f + 0.1f), (double)((float)this.getBaseMetaTileEntity().getZCoord() + XSTR.XSTR_INSTANCE.nextFloat() * 0.8f + 0.1f), insideDrone);
        tItemEntity.field_70159_w = XSTR.XSTR_INSTANCE.nextGaussian() * 0.05;
        tItemEntity.field_70181_x = XSTR.XSTR_INSTANCE.nextGaussian() * 0.25;
        tItemEntity.field_70179_y = XSTR.XSTR_INSTANCE.nextGaussian() * 0.05;
        this.getBaseMetaTileEntity().getWorld().func_72838_d((Entity)tItemEntity);
    }

    @Override
    public void onRemoval() {
        droneMap.remove((Object)this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g, (Object)this);
    }

    @Override
    public void onUnload() {
        droneMap.remove((Object)this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g, (Object)this);
    }

    public List<DroneConnection> getConnectionList() {
        return this.connectionList;
    }

    public int getRange() {
        int n;
        switch (this.droneLevel) {
            case 1: {
                n = 128;
                break;
            }
            case 2: {
                n = 512;
                break;
            }
            case 3: {
                n = 4096;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    public Vec3Impl getCoords() {
        return this.centreCoord;
    }

    private boolean tryConsumeDrone() {
        ArrayList<ItemStack> inputs = this.getStoredInputs();
        if (inputs.isEmpty()) {
            return false;
        }
        for (ItemStack item : inputs) {
            Item item2;
            if (item == null || !((item2 = item.func_77973_b()) instanceof ItemTierDrone)) continue;
            ItemTierDrone drone = (ItemTierDrone)item2;
            this.droneLevel = drone.getLevel();
            --item.field_77994_a;
            this.updateSlots();
            return true;
        }
        return false;
    }

    private void tryUpdateDrone() {
        ArrayList<ItemStack> inputs = this.getStoredInputs();
        if (inputs.isEmpty()) {
            return;
        }
        for (ItemStack item : inputs) {
            ItemTierDrone drone;
            Item item2;
            if (item == null || !((item2 = item.func_77973_b()) instanceof ItemTierDrone) || (drone = (ItemTierDrone)item2).getLevel() <= this.droneLevel) continue;
            this.droneLevel = drone.getLevel();
            --item.field_77994_a;
            this.updateSlots();
            return;
        }
    }

    private void createRenderBlock() {
        if (!this.useRender) {
            return;
        }
        int x = this.getBaseMetaTileEntity().getXCoord() + 2 * this.getExtendedFacing().getRelativeBackInWorld().offsetX;
        int y = this.getBaseMetaTileEntity().getYCoord() + 2 * this.getExtendedFacing().getRelativeBackInWorld().offsetY;
        int z = this.getBaseMetaTileEntity().getZCoord() + 2 * this.getExtendedFacing().getRelativeBackInWorld().offsetZ;
        World world = this.getBaseMetaTileEntity().getWorld();
        if (world.func_147437_c(x, y, z)) {
            world.func_147449_b(x, y, z, GregTechAPI.sDroneRender);
        }
    }

    private void destroyRenderBlock() {
        int x = this.getBaseMetaTileEntity().getXCoord() + 2 * this.getExtendedFacing().getRelativeBackInWorld().offsetX;
        int y = this.getBaseMetaTileEntity().getYCoord() + 2 * this.getExtendedFacing().getRelativeBackInWorld().offsetY;
        int z = this.getBaseMetaTileEntity().getZCoord() + 2 * this.getExtendedFacing().getRelativeBackInWorld().offsetZ;
        World world = this.getBaseMetaTileEntity().getWorld();
        if (world.func_147439_a(x, y, z).equals(GregTechAPI.sDroneRender)) {
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
        }
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        buildContext.addSyncedWindow(10, this::createMachineListWindow);
        buildContext.addSyncedWindow(11, this::createCustomNameWindow);
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                widget.getContext().openSyncedWindow(10);
            }
        }).setSize(16, 16).setBackground(() -> {
            ArrayList<UITexture> UI = new ArrayList<UITexture>();
            UI.add(GTUITextures.BUTTON_STANDARD);
            UI.add(GTUITextures.OVERLAY_BUTTON_WHITELIST);
            return UI.toArray(new IDrawable[0]);
        }).addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.drone_open_list")).setPos(94, 91).setEnabled(var -> this.getBaseMetaTileEntity().isActive()))).widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                if (!this.getBaseMetaTileEntity().isActive()) {
                    widget.getContext().getPlayer().func_146105_b((IChatComponent)new ChatComponentTranslation("GT5U.machines.dronecentre.shutdown", new Object[0]));
                    return;
                }
                for (DroneConnection mte : this.connectionList) {
                    mte.machine.getBaseMetaTileEntity().enableWorking();
                }
                widget.getContext().getPlayer().func_146105_b((IChatComponent)new ChatComponentTranslation("GT5U.machines.dronecentre.turnon", new Object[0]));
                widget.getContext().getPlayer().func_71053_j();
            }
        }).setSize(16, 16).setBackground(() -> {
            ArrayList<UITexture> UI = new ArrayList<UITexture>();
            UI.add(GTUITextures.BUTTON_STANDARD);
            UI.add(GTUITextures.OVERLAY_BUTTON_POWER_SWITCH_ON);
            return UI.toArray(new IDrawable[0]);
        }).addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.drone_poweron_all")).setPos(146, 91).setEnabled(var -> this.getBaseMetaTileEntity().isActive()))).widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!widget.isClient()) {
                if (!this.getBaseMetaTileEntity().isActive()) {
                    widget.getContext().getPlayer().func_146105_b((IChatComponent)new ChatComponentTranslation("GT5U.machines.dronecentre.shutdown", new Object[0]));
                    return;
                }
                for (DroneConnection mte : this.connectionList) {
                    mte.machine.getBaseMetaTileEntity().disableWorking();
                }
                widget.getContext().getPlayer().func_146105_b((IChatComponent)new ChatComponentTranslation("GT5U.machines.dronecentre.turnoff", new Object[0]));
                widget.getContext().getPlayer().func_71053_j();
            }
        }).setSize(16, 16).setBackground(() -> {
            ArrayList<UITexture> UI = new ArrayList<UITexture>();
            UI.add(GTUITextures.BUTTON_STANDARD);
            UI.add(GTUITextures.OVERLAY_BUTTON_POWER_SWITCH_OFF);
            return UI.toArray(new IDrawable[0]);
        }).addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.drone_poweroff_all")).setPos(120, 91).setEnabled(var -> this.getBaseMetaTileEntity().isActive()))).widget((Widget)new FakeSyncWidget.ListSyncer(() -> this.connectionList, var1 -> {
            this.connectionList.clear();
            this.connectionList.addAll((Collection<DroneConnection>)var1);
        }, (buffer, j) -> {
            try {
                buffer.func_150786_a(j.transConnectionToNBT());
            }
            catch (IOException e) {
                GTLog.err.println(e.getCause());
            }
        }, buffer -> {
            try {
                return new DroneConnection(buffer.func_150793_b());
            }
            catch (IOException e) {
                GTLog.err.println(e.getCause());
                return null;
            }
        }));
    }

    protected ModularWindow createMachineListWindow(EntityPlayer player) {
        int heightCoff = this.getBaseMetaTileEntity().isServerSide() ? 0 : Minecraft.func_71410_x().field_71462_r.field_146295_m - 40;
        ModularWindow.Builder builder = ModularWindow.builder((int)260, (int)heightCoff);
        builder.setBackground(new IDrawable[]{GTUITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        builder.setGuiTint(this.getGUIColorization());
        builder.widget(ButtonWidget.closeWindowButton((boolean)true).setPos(245, 3));
        builder.widget(new TextWidget(EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"GT5U.gui.text.drone_title")).setScale(2.0f).setTextAlignment(Alignment.Center).setPos(0, 10).setSize(260, 8));
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new TextFieldWidget(){

            public void onRemoveFocus() {
                super.onRemoveFocus();
                this.syncToServer(2, buffer -> {});
            }

            public void readOnServer(int id, PacketBuffer buf) {
                switch (id) {
                    case 1: {
                        super.readOnServer(id, buf);
                        break;
                    }
                    case 2: {
                        this.getContext().closeWindow(10);
                        this.getContext().openSyncedWindow(10);
                    }
                }
            }
        }.setGetter(() -> this.searchFilter).setSetter(var -> {
            this.searchFilter = var;
        }).setTextAlignment(Alignment.CenterLeft).setTextColor(Color.WHITE.dark(1)).setFocusOnGuiOpen(false).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD_LIGHT_GRAY.withOffset(-1.0f, -1.0f, 2.0f, 2.0f)}).addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.text.drone_search")).setPos(50, 30).setSize(200, 16))).widget(new ButtonWidget(){

            public Interactable.ClickResult onClick(int buttonId, boolean doubleClick) {
                Interactable.ClickResult result = super.onClick(buttonId, doubleClick);
                this.syncToServer(2, buffer -> {});
                return result;
            }

            public void readOnServer(int id, PacketBuffer buf) {
                switch (id) {
                    case 1: {
                        super.readOnServer(id, buf);
                        break;
                    }
                    case 2: {
                        this.getContext().closeWindow(10);
                        this.getContext().openSyncedWindow(10);
                    }
                }
            }
        }.setOnClick((clickData, widget) -> {
            switch (this.sort) {
                case "name": {
                    this.sort = "distance";
                    break;
                }
                case "distance": {
                    this.sort = "error";
                    break;
                }
                case "error": {
                    this.sort = "name";
                }
            }
        }).addTooltip(StatCollector.func_74838_a((String)("GT5U.gui.button.drone_" + this.sort))).setBackground(() -> new IDrawable[]{GTUITextures.BUTTON_STANDARD, GTUITextures.OVERLAY_BUTTON_SORTING_MODE}).setPos(10, 30).setSize(16, 16))).widget((Widget)new FakeSyncWidget.StringSyncer(() -> this.sort, var1 -> {
            this.sort = var1;
        }))).widget(new ButtonWidget(){

            public Interactable.ClickResult onClick(int buttonId, boolean doubleClick) {
                Interactable.ClickResult result = super.onClick(buttonId, doubleClick);
                this.syncToServer(2, buffer -> {});
                return result;
            }

            public void readOnServer(int id, PacketBuffer buf) {
                switch (id) {
                    case 1: {
                        super.readOnServer(id, buf);
                        break;
                    }
                    case 2: {
                        this.getContext().closeWindow(10);
                        this.getContext().openSyncedWindow(10);
                    }
                }
            }
        }.setOnClick((clickData, widget) -> {
            this.showLocalizedName = !this.showLocalizedName;
        }).addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.drone_showLocalName")).setBackground(() -> new IDrawable[]{this.showLocalizedName ? GTUITextures.BUTTON_STANDARD_PRESSED : GTUITextures.BUTTON_STANDARD, GTUITextures.OVERLAY_BUTTON_CYCLIC}).setPos(30, 30).setSize(16, 16));
        switch (this.sort) {
            case "name": {
                this.connectionList = this.connectionList.stream().sorted((o1, o2) -> Collator.getInstance(Locale.UK).compare(o1.getCustomName(false), o2.getCustomName(false))).collect(Collectors.toList());
                break;
            }
            case "distance": {
                this.connectionList = this.connectionList.stream().sorted(Comparator.comparing(DroneConnection::getDistanceSquared)).collect(Collectors.toList());
                break;
            }
            case "error": {
                this.connectionList = this.connectionList.stream().sorted(Comparator.comparing(DroneConnection::isMachineShutdown).reversed().thenComparing(DroneConnection::getDistanceSquared)).collect(Collectors.toList());
            }
        }
        Scrollable MachineContainer = new Scrollable().setVerticalScroll();
        int posY = 0;
        for (int i = 0; i < this.connectionList.size(); ++i) {
            DroneConnection connection = this.connectionList.get(i);
            if (!connection.customName.toLowerCase().contains(this.searchFilter.toLowerCase())) continue;
            ItemStackHandler drawitem = new ItemStackHandler(1);
            drawitem.setStackInSlot(0, connection.machineItem);
            DynamicPositionedRow row = new DynamicPositionedRow().setSynced(false);
            MTEMultiBlockBase coreMachine = connection.machine;
            int finalI = i;
            ((Row)row.widget(SlotWidget.phantom((IItemHandlerModifiable)drawitem, (int)0).disableInteraction().setPos(0, 0))).widget(new ButtonWidget().setOnClick((clickData, widget) -> {
                this.buttonID = finalI;
                if (!widget.isClient()) {
                    widget.getContext().openSyncedWindow(11);
                }
            }).addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.drone_setname")).setBackground(() -> new IDrawable[]{GTUITextures.BUTTON_STANDARD, GTUITextures.OVERLAY_BUTTON_PRINT}).setSize(16, 16));
            ((Row)row.widget(new ButtonWidget().setOnClick((clickData, widget) -> Optional.ofNullable(coreMachine).ifPresent(machine -> {
                if (!this.getBaseMetaTileEntity().isActive()) {
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation("GT5U.machines.dronecentre.shutdown", new Object[0]));
                    return;
                }
                if (machine.isAllowedToWork()) {
                    machine.disableWorking();
                } else {
                    machine.enableWorking();
                }
            })).setPlayClickSoundResource(() -> Optional.ofNullable(coreMachine).filter(MTEMultiBlockBase::isAllowedToWork).map(var -> SoundResource.GUI_BUTTON_UP.resourceLocation).orElse(SoundResource.GUI_BUTTON_DOWN.resourceLocation)).setBackground(() -> Optional.ofNullable(coreMachine).map(machine -> {
                IDrawable[] iDrawableArray;
                if (machine.isAllowedToWork()) {
                    IDrawable[] iDrawableArray2 = new IDrawable[2];
                    iDrawableArray2[0] = GTUITextures.BUTTON_STANDARD_PRESSED;
                    iDrawableArray = iDrawableArray2;
                    iDrawableArray2[1] = GTUITextures.OVERLAY_BUTTON_POWER_SWITCH_ON;
                } else {
                    IDrawable[] iDrawableArray3 = new IDrawable[2];
                    iDrawableArray3[0] = GTUITextures.BUTTON_STANDARD;
                    iDrawableArray = iDrawableArray3;
                    iDrawableArray3[1] = GTUITextures.OVERLAY_BUTTON_POWER_SWITCH_OFF;
                }
                return iDrawableArray;
            }).orElse(new IDrawable[]{GTUITextures.OVERLAY_BUTTON_CROSS})).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(() -> Optional.ofNullable(coreMachine).map(MTEMultiBlockBase::isAllowedToWork).orElse(false), var -> Optional.ofNullable(coreMachine).ifPresent(machine -> {
                if (var.booleanValue()) {
                    machine.enableWorking();
                } else {
                    machine.disableWorking();
                }
            })), (IWidgetBuilder)builder).addTooltip(coreMachine != null ? StatCollector.func_74838_a((String)"GT5U.gui.button.power_switch") : StatCollector.func_74838_a((String)"GT5U.gui.button.drone_outofrange")).setSize(16, 16))).widget(new ButtonWidget().setOnClick((clickData, widget) -> {
                if (widget.isClient()) {
                    this.highlightMachine(player, connection.machineCoord);
                    player.func_71053_j();
                }
            }).addTooltip(StatCollector.func_74838_a((String)"GT5U.gui.button.drone_highlight")).setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD, GTUITextures.OVERLAY_BUTTON_INVERT_REDSTONE}).setSize(16, 16));
            row.widget(new DrawableWidget().dynamicTooltip(() -> Collections.singletonList(Optional.ofNullable(coreMachine).map(machine -> machine.getBaseMetaTileEntity().getLastShutDownReason().getDisplayString()).orElse(""))).setBackground(new IDrawable[]{GTUITextures.PICTURE_STALLED_ELECTRICITY}).setSize(16, 16).setEnabled(var -> coreMachine != null && coreMachine.shouldDisplayShutDownReason() && !coreMachine.getBaseMetaTileEntity().isActive() && GTUtility.isStringValid(coreMachine.getBaseMetaTileEntity().getLastShutDownReason().getDisplayString()) && coreMachine.getBaseMetaTileEntity().wasShutdown()).attachSyncer((FakeSyncWidget)new ShutDownReasonSyncer(() -> Optional.ofNullable(coreMachine).map(var -> coreMachine.getBaseMetaTileEntity().getLastShutDownReason()).orElse(ShutDownReasonRegistry.NONE), reason -> Optional.ofNullable(coreMachine).ifPresent(machine -> coreMachine.getBaseMetaTileEntity().setShutDownReason((ShutDownReason)reason))), (IWidgetBuilder)builder).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BooleanSyncer(() -> Optional.ofNullable(coreMachine).map(var -> coreMachine.getBaseMetaTileEntity().wasShutdown()).orElse(false), wasShutDown -> Optional.ofNullable(coreMachine).ifPresent(machine -> coreMachine.getBaseMetaTileEntity().setShutdownStatus((boolean)wasShutDown))), (IWidgetBuilder)builder));
            row.widget(new TextWidget(this.connectionList.get(i).getCustomName(this.showLocalizedName)).setTextAlignment(Alignment.CenterLeft).setPos(0, 4));
            MachineContainer.widget(row.setAlignment(MainAxisAlignment.SPACE_BETWEEN).setSpace(4).setPos(0, posY));
            posY += 20;
        }
        return ((ModularWindow.Builder)builder.widget(MachineContainer.setPos(10, 50).setSize(240, heightCoff - 60))).setDraggable(false).build();
    }

    protected ModularWindow createCustomNameWindow(EntityPlayer player) {
        ModularWindow.Builder builder = ModularWindow.builder((int)150, (int)40);
        builder.setBackground(new IDrawable[]{GTUITextures.BACKGROUND_SINGLEBLOCK_DEFAULT});
        builder.setGuiTint(this.getGUIColorization());
        return ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(ButtonWidget.closeWindowButton((boolean)true).setPos(135, 3))).widget(new TextWidget(StatCollector.func_74838_a((String)"GT5U.gui.text.drone_custom_name")).setTextAlignment(Alignment.Center).setPos(0, 5).setSize(150, 8))).widget(new TextFieldWidget(){

            public void onDestroy() {
                if (this.isClient()) {
                    return;
                }
                this.getContext().closeWindow(10);
                this.getContext().openSyncedWindow(10);
            }
        }.setGetter(() -> this.connectionList.get(this.buttonID).getCustomName(false)).setSetter(var -> this.connectionList.get(this.buttonID).setCustomName((String)var)).setTextAlignment(Alignment.CenterLeft).setTextColor(Color.WHITE.dark(1)).setFocusOnGuiOpen(true).setBackground(new IDrawable[]{GTUITextures.BACKGROUND_TEXT_FIELD_LIGHT_GRAY.withOffset(-1.0f, -1.0f, 2.0f, 2.0f)}).setPos(10, 16).setSize(130, 16))).build();
    }

    private void highlightMachine(EntityPlayer player, ChunkCoordinates machineCoord) {
        DimensionalCoord blockPos = new DimensionalCoord(machineCoord.field_71574_a, machineCoord.field_71572_b, machineCoord.field_71573_c, player.field_71093_bK);
        BlockPosHighlighter.highlightBlocks((EntityPlayer)player, Collections.singletonList(blockPos), null, null);
    }

    public static HashMultimap<Integer, MTEDroneCentre> getCentreMap() {
        return droneMap;
    }

    @Override
    public boolean getDefaultHasMaintenanceChecks() {
        return false;
    }
}

