/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.boilers;

import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widgets.slot.FluidSlot;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.common.widget.FluidSlotWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GTMod;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Materials;
import gregtech.api.enums.ParticleFX;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.SteamVariant;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.modularui2.GTGuiTheme;
import gregtech.api.modularui2.GTGuiThemes;
import gregtech.api.objects.XSTR;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import gregtech.api.util.WorldSpawnedEventBuilder;
import gregtech.common.tileentities.boilers.MTEBoiler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class MTEBoilerLava
extends MTEBoiler {
    public static final int COOLDOWN_INTERVAL = 20;
    public static final int ENERGY_PER_LAVA = 1;
    public static final int CONSUMPTION_PER_HEATUP = 3;
    public static final int PRODUCTION_PER_SECOND = 600;
    private final FluidTank lavaTank = new LavaTank(null, this.getCapacity());
    private int mCooledLava = 0;

    public MTEBoilerLava(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, new String[]{"A Boiler running off Lava", "Produces 600L of Steam per second", "Causes " + GTMod.proxy.mPollutionHighPressureLavaBoilerPerSecond + " Pollution per second", "Consumes 3.0L of Lava every 20 ticks when fully heat up"}, new ITexture[0]);
    }

    public MTEBoilerLava(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        ForgeDirection rearDirection = facingDirection.getOpposite();
        ITexture[] tmp = (sideDirection.flag & (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag)) == 0 ? (sideDirection == facingDirection ? (active ? this.mTextures[4][colorIndex + 1] : this.mTextures[3][colorIndex + 1]) : (sideDirection == rearDirection ? this.mTextures[5][colorIndex + 1] : this.mTextures[2][colorIndex + 1])) : this.mTextures[sideDirection.ordinal()][colorIndex + 1];
        if (sideDirection != facingDirection && tmp.length == 2) {
            return new ITexture[]{tmp[0]};
        }
        return tmp;
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[6][17][];
        for (int color = -1; color < 16; color = (int)((byte)(color + 1))) {
            int i = color + 1;
            short[] colorModulation = Dyes.getModulation(color);
            rTextures[0][i] = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_STEELBRICKS_BOTTOM, colorModulation)};
            rTextures[1][i] = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_STEELBRICKS_TOP, colorModulation), TextureFactory.of(Textures.BlockIcons.OVERLAY_DRAIN), TextureFactory.of(Textures.BlockIcons.FLUID_IN_SIGN)};
            rTextures[2][i] = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_STEELBRICKS_SIDE, colorModulation), TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT), TextureFactory.of(Textures.BlockIcons.FLUID_IN_SIGN)};
            rTextures[3][i] = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_STEELBRICKS_SIDE, colorModulation), TextureFactory.of(Textures.BlockIcons.BOILER_LAVA_FRONT, colorModulation), TextureFactory.of(Textures.BlockIcons.BOILER_LAVA_FRONT_GLOW)};
            rTextures[4][i] = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_STEELBRICKS_SIDE, colorModulation), TextureFactory.of(Textures.BlockIcons.BOILER_LAVA_FRONT_ACTIVE), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.BOILER_LAVA_FRONT_ACTIVE_GLOW).glow().build()};
            rTextures[5][i] = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_STEELBRICKS_SIDE, colorModulation), TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT), TextureFactory.of(Textures.BlockIcons.FLUID_OUT_SIGN)};
        }
        return rTextures;
    }

    @Override
    public int maxProgresstime() {
        return 1000;
    }

    @Override
    public int getCapacity() {
        return 32000;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEBoilerLava(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    protected int getPollution() {
        return GTMod.proxy.mPollutionHighPressureLavaBoilerPerSecond;
    }

    @Override
    protected int getProductionPerSecond() {
        return 600;
    }

    @Override
    protected int getMaxTemperature() {
        return 1000;
    }

    @Override
    protected int getEnergyConsumption() {
        this.mCooledLava += 3;
        return 3;
    }

    @Override
    protected int getCooldownInterval() {
        return 20;
    }

    public static ItemStack fillIFluidTankFromItemStack(IFluidTank destinationIFluidTank, ItemStack SourceItemStack) {
        if (destinationIFluidTank == null || SourceItemStack == null) {
            return null;
        }
        FluidStack containedFluidStack = GTUtility.getFluidForFilledItem(SourceItemStack, true);
        if (containedFluidStack == null || containedFluidStack.amount == 0) {
            return null;
        }
        int fillableAmount = destinationIFluidTank.fill(containedFluidStack, false);
        if (fillableAmount <= 0) {
            return null;
        }
        Item containerItem = SourceItemStack.func_77973_b();
        if (containerItem instanceof IFluidContainerItem) {
            IFluidContainerItem equippedIFluidContainerItem = (IFluidContainerItem)containerItem;
            destinationIFluidTank.fill(equippedIFluidContainerItem.drain(SourceItemStack, fillableAmount, true), true);
            return null;
        }
        ItemStack emptyContainerItemStack = GTUtility.getContainerForFilledItem(SourceItemStack, false);
        destinationIFluidTank.fill(containedFluidStack, true);
        return emptyContainerItemStack;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        MTEBoilerLava tank;
        if (aBaseMetaTileEntity.isClientSide() || aPlayer == null) {
            return true;
        }
        ItemStack equippedItemStack = aPlayer.func_71045_bC();
        FluidStack equippedContainerFluidStack = GTUtility.getFluidForFilledItem(equippedItemStack, true);
        if (GTModHandler.isWater(equippedContainerFluidStack)) {
            tank = this;
        } else if (GTModHandler.isLava(equippedContainerFluidStack)) {
            tank = this.lavaTank;
        } else {
            this.openGui(aPlayer);
            return true;
        }
        ItemStack returnedItemStack = MTEBoilerLava.fillIFluidTankFromItemStack(tank, equippedItemStack);
        if (returnedItemStack != null && !aPlayer.field_71075_bZ.field_75098_d) {
            if (equippedItemStack.field_77994_a > 1) {
                if (!aPlayer.field_71071_by.func_70441_a(returnedItemStack)) {
                    aBaseMetaTileEntity.getWorld().func_72838_d((Entity)new EntityItem(aBaseMetaTileEntity.getWorld(), (double)aBaseMetaTileEntity.getXCoord() + 0.5, (double)aBaseMetaTileEntity.getYCoord() + 1.5, (double)aBaseMetaTileEntity.getZCoord() + 0.5, returnedItemStack));
                } else if (aPlayer instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)aPlayer).func_71120_a(aPlayer.field_71069_bz);
                }
                aPlayer.field_71071_by.func_70298_a(aPlayer.field_71071_by.field_70461_c, 1);
            } else {
                aPlayer.field_71071_by.func_70299_a(aPlayer.field_71071_by.field_70461_c, returnedItemStack);
            }
        }
        return true;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        if (this.lavaTank.getFluid() != null) {
            aNBT.func_74782_a("mLava", (NBTBase)this.lavaTank.getFluid().writeToNBT(new NBTTagCompound()));
        }
        aNBT.func_74768_a("mCooledLava", this.mCooledLava);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.lavaTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT.func_74775_l("mLava")));
        this.mCooledLava = aNBT.func_74762_e("mCooledLava");
    }

    @Override
    protected void pushSteamToInventories(IGregTechTileEntity aBaseMetaTileEntity) {
        if (this.mSteam == null || this.mSteam.amount == 0) {
            return;
        }
        this.pushSteamToSide(aBaseMetaTileEntity, aBaseMetaTileEntity.getFrontFacing().getOpposite());
    }

    protected void drainLava(IGregTechTileEntity aBaseMetaTileEntity) {
        IFluidHandler upTank = aBaseMetaTileEntity.getITankContainerAtSide(ForgeDirection.UP);
        if (upTank == null) {
            return;
        }
        int toDrain = Math.min(this.lavaTank.getCapacity() - (this.lavaTank.getFluid() != null ? this.lavaTank.getFluid().amount : 0), 1000);
        FluidStack drainableLavaStack = upTank.drain(ForgeDirection.DOWN, Materials.Lava.getFluid(toDrain), false);
        if (!GTModHandler.isLava(drainableLavaStack) || drainableLavaStack.amount <= 0) {
            return;
        }
        this.lavaTank.fill(upTank.drain(ForgeDirection.DOWN, drainableLavaStack, true), true);
    }

    private boolean lavaToObsidian() {
        if (this.mCooledLava >= 1000) {
            if (this.getBaseMetaTileEntity().addStackToSlot(3, new ItemStack(Blocks.field_150343_Z, 1))) {
                this.mCooledLava -= 1000;
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRandomDisplayTick(IGregTechTileEntity aBaseMetaTileEntity) {
        if (aBaseMetaTileEntity.isActive()) {
            ForgeDirection frontFacing = aBaseMetaTileEntity.getFrontFacing();
            if ((frontFacing.flag & (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag)) == 0 && !aBaseMetaTileEntity.hasCoverAtSide(frontFacing) && !aBaseMetaTileEntity.getOpacityAtSide(frontFacing)) {
                double z;
                double x;
                double oX = (double)aBaseMetaTileEntity.getOffsetX(frontFacing, 1) + 0.5;
                double oY = aBaseMetaTileEntity.getOffsetY(frontFacing, 1);
                double oZ = (double)aBaseMetaTileEntity.getOffsetZ(frontFacing, 1) + 0.5;
                double offset = -0.48;
                double horizontal = (double)XSTR.XSTR_INSTANCE.nextFloat() * 10.0 / 16.0 - 0.3125;
                double y = oY + (double)XSTR.XSTR_INSTANCE.nextFloat() * 6.0 / 16.0;
                switch (frontFacing) {
                    case WEST: {
                        x = oX - -0.48;
                        z = oZ + horizontal;
                        break;
                    }
                    case EAST: {
                        x = oX + -0.48;
                        z = oZ + horizontal;
                        break;
                    }
                    case NORTH: {
                        x = oX + horizontal;
                        z = oZ - -0.48;
                        break;
                    }
                    default: {
                        x = oX + horizontal;
                        z = oZ + -0.48;
                    }
                }
                WorldSpawnedEventBuilder.ParticleEventBuilder particleEventBuilder = new WorldSpawnedEventBuilder.ParticleEventBuilder().setMotion(0.0, 0.0, 0.0).setPosition(x, y, z).setWorld(this.getBaseMetaTileEntity().getWorld());
                ((WorldSpawnedEventBuilder.ParticleEventBuilder)particleEventBuilder.setIdentifier((Enum)ParticleFX.SMOKE)).run();
                ((WorldSpawnedEventBuilder.ParticleEventBuilder)particleEventBuilder.setIdentifier((Enum)ParticleFX.FLAME)).run();
            }
        }
    }

    @Override
    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return GTModHandler.isWater(aFluid) || GTModHandler.isLava(aFluid);
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (!aBaseMetaTileEntity.isServerSide()) {
            return;
        }
        FluidStack containedFluidStack = GTUtility.getFluidForFilledItem(this.mInventory[this.getInputSlot()], true);
        if (GTModHandler.isWater(containedFluidStack)) {
            super.onPreTick(aBaseMetaTileEntity, aTick);
        }
        if (GTModHandler.isLava(containedFluidStack) && this.lavaTank.fill(containedFluidStack, false) == containedFluidStack.amount && aBaseMetaTileEntity.addStackToSlot(this.getOutputSlot(), GTUtility.getContainerForFilledItem(this.mInventory[this.getInputSlot()], true), 1)) {
            this.lavaTank.fill(containedFluidStack, true);
            aBaseMetaTileEntity.func_70298_a(this.getInputSlot(), 1);
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aTick % 20L == 0L) {
            this.drainLava(aBaseMetaTileEntity);
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    protected boolean isAutomatable() {
        return true;
    }

    @Override
    public void doSound(byte aIndex, double aX, double aY, double aZ) {
        if (aIndex != 1) {
            return;
        }
        ForgeDirection rearDirection = this.getBaseMetaTileEntity().getFrontFacing().getOpposite();
        GTUtility.doSoundAtClient(SoundResource.RANDOM_FIZZ, 2, 1.0f, aX + 0.5 * (double)rearDirection.offsetX, aY, aZ + 0.5 * (double)rearDirection.offsetZ);
        ((WorldSpawnedEventBuilder.ParticleEventBuilder)new WorldSpawnedEventBuilder.ParticleEventBuilder().setIdentifier((Enum)ParticleFX.CLOUD)).setWorld(this.getBaseMetaTileEntity().getWorld()).setMotion((double)rearDirection.offsetX / 20.0, 0.0, (double)rearDirection.offsetZ / 20.0).times(8, x -> x.setPosition(aX + (double)rearDirection.offsetX / 2.0, aY, aZ + (double)rearDirection.offsetZ / 2.0).run());
    }

    @Override
    protected void updateFuel(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (!this.lavaToObsidian()) {
            return;
        }
        if (this.lavaTank.getFluid() == null || this.lavaTank.getFluid().amount <= 0) {
            return;
        }
        int amountToDrain = Math.min(this.lavaTank.getFluid().amount, 1000);
        FluidStack drainedLava = this.lavaTank.drain(amountToDrain, false);
        if (drainedLava == null || drainedLava.amount == 0) {
            return;
        }
        this.lavaTank.drain(amountToDrain, true);
        this.mProcessingEnergy += drainedLava.amount * 1;
    }

    @Override
    public SteamVariant getSteamVariant() {
        return SteamVariant.STEEL;
    }

    @Override
    public int fill(FluidStack aFluid, boolean doFill) {
        if (GTModHandler.isWater(aFluid)) {
            return super.fill(aFluid, doFill);
        }
        if (GTModHandler.isLava(aFluid)) {
            return this.lavaTank.fill(aFluid, doFill);
        }
        return 0;
    }

    @Override
    public FluidTankInfo[] getTankInfo(ForgeDirection side) {
        return new FluidTankInfo[]{super.getTankInfo(side)[0], new FluidTankInfo(this.lavaTank.getFluid(), this.lavaTank.getCapacity()), new FluidTankInfo(this.getDrainableStack(), this.getSteamCapacity())};
    }

    @Override
    protected GTGuiTheme getGuiTheme() {
        return GTGuiThemes.STEEL;
    }

    @Override
    protected Widget<?> createFuelSlot() {
        return new FluidSlot().syncHandler((IFluidTank)this.lavaTank).widgetTheme("overlayFluidSlotIn");
    }

    @Override
    protected Widget<?> createAshSlot() {
        return super.createAshSlot().widgetTheme("overlayItemSlotBlock");
    }

    @Override
    protected IDrawable[] getAshSlotBackground() {
        return new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_BLOCK_STEAM.get(this.getSteamVariant())};
    }

    @Override
    protected com.gtnewhorizons.modularui.api.widget.Widget createFuelSlotMui1() {
        return new FluidSlotWidget((IFluidTank)this.lavaTank).setBackground(new IDrawable[]{this.getGUITextureSet().getFluidSlot(), this.getOverlaySlotIn()}).setPos(115, 61);
    }

    static class LavaTank
    extends FluidTank {
        public LavaTank(FluidStack stack, int capacity) {
            super(stack, capacity);
        }

        public int fill(FluidStack resource, boolean doFill) {
            return GTModHandler.isLava(resource) ? super.fill(resource, doFill) : 0;
        }
    }
}

