/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pollution;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GTMod;
import gregtech.common.pollution.EntityFXPollution;
import gregtech.common.pollution.GTClientPollutionMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.potion.Potion;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class PollutionRenderer {
    private static final boolean DEBUG = false;
    private static final int PARTICLES_MAX_NUM = 100;
    private static final int PARTICLES_POLLUTION_START = 400000;
    private static final int PARTICLES_POLLUTION_END = 3500000;
    private static final int END_MAX_DISTANCE = 191;
    private static final int FOG_START_AT_POLLUTION = 400000;
    private static final int FOG_MAX_AT_POLLUTION = 7000000;
    private static final double FOG_START_EXP_RATIO = 0.02;
    private static final float[] FOG_COLOR = new float[]{0.3f, 0.25f, 0.1f};
    private static final short[] GRASS_COLOR = new short[]{230, 180, 40};
    private static final short[] LEAVES_COLOR = new short[]{160, 80, 15};
    private static final short[] LIQUID_COLOR = new short[]{160, 200, 10};
    private static final short[] FOLIAGE_COLOR = new short[]{160, 80, 15};
    private final GTClientPollutionMap pollutionMap = new GTClientPollutionMap();
    private int playerPollution = 0;
    private double fogIntensityLastTick = 0.0;
    private double lastUpdate = 0.0;

    public void processPacket(ChunkCoordIntPair chunk, int pollution) {
        this.pollutionMap.addChunkPollution(chunk.field_77276_a, chunk.field_77275_b, pollution);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.world.field_72995_K) {
            this.pollutionMap.needsRebuild();
        }
    }

    private static int color(int color, int pollution, int low, float high, short[] colors) {
        if (pollution < low) {
            return color;
        }
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        float p = (float)(pollution - low) / high;
        if (p > 1.0f) {
            p = 1.0f;
        }
        float pi = 1.0f - p;
        r = (int)((float)r * pi + p * (float)colors[0]) & 0xFF;
        g = (int)((float)g * pi + p * (float)colors[1]) & 0xFF;
        b = (int)((float)b * pi + p * (float)colors[2]) & 0xFF;
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public int colorGrass(int oColor, int x, int z) {
        return PollutionRenderer.color(oColor, this.pollutionMap.getPollution(x, z) / 1000, 350, 600.0f, GRASS_COLOR);
    }

    public int colorLeaves(int oColor, int x, int z) {
        return PollutionRenderer.color(oColor, this.pollutionMap.getPollution(x, z) / 1000, 300, 500.0f, LEAVES_COLOR);
    }

    public int colorLiquid(int oColor, int x, int z) {
        return PollutionRenderer.color(oColor, this.pollutionMap.getPollution(x, z) / 1000, 300, 500.0f, LIQUID_COLOR);
    }

    public int colorFoliage(int oColor, int x, int z) {
        return PollutionRenderer.color(oColor, this.pollutionMap.getPollution(x, z) / 1000, 300, 500.0f, FOLIAGE_COLOR);
    }

    public int getKnownPollution(int x, int z) {
        return this.pollutionMap.getPollution(x, z);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void manipulateColor(EntityViewRenderEvent.FogColors event) {
        if (Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d) {
            return;
        }
        if (event.block.func_149688_o() == Material.field_151586_h || event.block.func_149688_o() == Material.field_151587_i) {
            return;
        }
        float x = this.fogIntensityLastTick > 1.0 ? 1.0f : (float)this.fogIntensityLastTick;
        float xi = 1.0f - x;
        event.red = xi * event.red + x * FOG_COLOR[0];
        event.green = xi * event.green + x * FOG_COLOR[1];
        event.blue = xi * event.blue + x * FOG_COLOR[2];
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void renderGTPollutionFog(EntityViewRenderEvent.RenderFogEvent event) {
        if (!GTMod.proxy.mRenderPollutionFog) {
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d || this.fogIntensityLastTick < 0.02) {
            return;
        }
        if (event.fogMode == 0) {
            double v = 1.0 - this.fogIntensityLastTick / 0.02;
            GL11.glFogi((int)2917, (int)9729);
            GL11.glFogf((int)2915, (float)((float)(128.25 * v + 20.0)));
            GL11.glFogf((int)2916, (float)((float)(191.0 * (0.75 + v * 0.25))));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void renderGTPollutionFog(EntityViewRenderEvent.FogDensity event) {
        if (!GTMod.proxy.mRenderPollutionFog) {
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d) {
            return;
        }
        if (event.entity.func_70644_a(Potion.field_76440_q) || this.fogIntensityLastTick < 0.02 || event.block.func_149688_o() == Material.field_151586_h || event.block.func_149688_o() == Material.field_151587_i) {
            return;
        }
        GL11.glFogi((int)2917, (int)2049);
        event.density = (float)Math.pow(this.fogIntensityLastTick - 0.02, 0.75) / 5.0f + 0.01f;
        event.setCanceled(true);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null) {
            return;
        }
        EntityClientPlayerMP player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            if ((double)event.renderTickTime < this.lastUpdate) {
                this.lastUpdate -= 1.0;
            }
            float step = (float)(((double)event.renderTickTime - this.lastUpdate) / 50.0);
            this.lastUpdate = event.renderTickTime;
            float fogIntensity = (float)(this.playerPollution - 400000) / 7000000.0f;
            if (fogIntensity > 1.0f) {
                fogIntensity = 1.0f;
            } else if (fogIntensity < 0.0f) {
                fogIntensity = 0.0f;
            }
            double e = (double)fogIntensity - this.fogIntensityLastTick;
            if (e != 0.0) {
                if (e > 0.2) {
                    e = 0.2;
                } else if (e < -0.5) {
                    e = -0.5;
                }
                this.fogIntensityLastTick = e > 0.001 || e < -0.001 ? (this.fogIntensityLastTick += (double)step * e) : (double)fogIntensity;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (!GTMod.proxy.mRenderDirtParticles) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null) {
            return;
        }
        EntityClientPlayerMP player = mc.field_71439_g;
        if (player == null || player.field_71075_bZ.field_75098_d) {
            return;
        }
        World w = player.field_70170_p;
        this.playerPollution = this.pollutionMap.getPollution(player.field_70142_S, player.field_70136_U);
        float intensity = ((float)this.playerPollution - 400000.0f) / 3500000.0f;
        if (intensity < 0.0f) {
            return;
        }
        intensity = intensity > 1.0f ? 1.0f : (intensity *= intensity);
        int x = MathHelper.func_76128_c((double)player.field_70165_t);
        int y = MathHelper.func_76128_c((double)player.field_70163_u);
        int z = MathHelper.func_76128_c((double)player.field_70161_v);
        int numParticles = Math.round(intensity * 100.0f);
        for (int l = 0; l < numParticles; ++l) {
            int k1;
            int j1;
            int i1 = x + w.field_73012_v.nextInt(16) - w.field_73012_v.nextInt(16);
            Block block = w.func_147439_a(i1, j1 = y + w.field_73012_v.nextInt(16) - w.field_73012_v.nextInt(16), k1 = z + w.field_73012_v.nextInt(16) - w.field_73012_v.nextInt(16));
            if (block.func_149688_o() != Material.field_151579_a) continue;
            EntityFXPollution fx = new EntityFXPollution(w, (float)i1 + w.field_73012_v.nextFloat(), (float)j1 + w.field_73012_v.nextFloat(), (float)k1 + w.field_73012_v.nextFloat());
            mc.field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    private void drawPollution(String text, int off) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        Minecraft.func_71410_x().field_71466_p.func_78261_a(text, 0, off, -1);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }
}

