/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util.extensions;

import gregtech.api.enums.GTValues;
import gregtech.api.util.GTUtility;
import java.util.Arrays;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ArrayExt {
    public static int[] of(int ... objects) {
        return objects;
    }

    public static float[] of(float ... objects) {
        return objects;
    }

    public static double[] of(double ... objects) {
        return objects;
    }

    public static char[] of(char ... objects) {
        return objects;
    }

    public static byte[] of(byte ... objects) {
        return objects;
    }

    public static long[] of(long ... objects) {
        return objects;
    }

    @SafeVarargs
    public static <T> T[] of(T ... objects) {
        return objects;
    }

    public static <T> boolean isArrayEmpty(T[] a) {
        return a != null && a.length == 0;
    }

    public static FluidStack[] copyFluidsIfNonEmpty(FluidStack ... aStacks) {
        if (aStacks == null) {
            return null;
        }
        if (aStacks.length == 0) {
            return aStacks;
        }
        FluidStack[] rStacks = new FluidStack[aStacks.length];
        for (int i = 0; i < aStacks.length; ++i) {
            if (aStacks[i] == null) continue;
            rStacks[i] = aStacks[i].copy();
        }
        return rStacks;
    }

    public static ItemStack[] copyItemsIfNonEmpty(ItemStack ... aStacks) {
        if (aStacks == null) {
            return null;
        }
        if (aStacks.length == 0) {
            return aStacks;
        }
        ItemStack[] rStacks = new ItemStack[aStacks.length];
        for (int i = 0; i < aStacks.length; ++i) {
            rStacks[i] = GTUtility.copy(aStacks[i]);
        }
        return rStacks;
    }

    public static <T> T[] withoutNulls(T[] array, IntFunction<T[]> arrayFactory) {
        int count = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            ++count;
        }
        T[] newArr = arrayFactory.apply(count);
        if (count == 0) {
            return newArr;
        }
        int j = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            newArr[j] = array[i];
            ++j;
        }
        return newArr;
    }

    @Nonnull
    public static FluidStack[] removeNullFluids(@Nonnull FluidStack[] fluids) {
        if (fluids.length == 0) {
            return GTValues.emptyFluidStackArray;
        }
        int count = 0;
        for (FluidStack f : fluids) {
            if (f == null) continue;
            ++count;
        }
        if (count == 0) {
            return GTValues.emptyFluidStackArray;
        }
        FluidStack[] a = new FluidStack[count];
        int i = 0;
        for (FluidStack f : fluids) {
            if (f == null) continue;
            a[i] = f;
            ++i;
        }
        return a;
    }

    public static <T> T[] withoutTrailingNulls(T[] array, IntFunction<T[]> arrayFactory) {
        int firstNull = -1;
        int i = array.length - 1;
        while (i >= 0 && array[i] == null) {
            firstNull = i--;
        }
        if (firstNull == -1) {
            T[] newArray = arrayFactory.apply(array.length);
            System.arraycopy(array, 0, newArray, 0, array.length);
            return newArray;
        }
        if (firstNull == 0) {
            return arrayFactory.apply(0);
        }
        T[] newArray = arrayFactory.apply(firstNull);
        System.arraycopy(array, 0, newArray, 0, firstNull);
        return newArray;
    }

    @Nonnull
    public static ItemStack[] removeTrailingNulls(@Nonnull ItemStack[] array) {
        if (array.length == 0) {
            return GTValues.emptyItemStackArray;
        }
        int nullIndex = -1;
        int i = array.length - 1;
        while (i >= 0 && array[i] == null) {
            nullIndex = i--;
        }
        if (nullIndex == -1) {
            ItemStack[] a = new ItemStack[array.length];
            System.arraycopy(array, 0, a, 0, array.length);
            return a;
        }
        if (nullIndex == 0) {
            return GTValues.emptyItemStackArray;
        }
        ItemStack[] a = new ItemStack[nullIndex];
        System.arraycopy(array, 0, a, 0, nullIndex);
        return a;
    }

    @Nonnull
    public static FluidStack[] removeTrailingNulls(@Nonnull FluidStack[] array) {
        if (array.length == 0) {
            return GTValues.emptyFluidStackArray;
        }
        int nullIndex = -1;
        int i = array.length - 1;
        while (i >= 0 && array[i] == null) {
            nullIndex = i--;
        }
        if (nullIndex == -1) {
            FluidStack[] a = new FluidStack[array.length];
            System.arraycopy(array, 0, a, 0, array.length);
            return a;
        }
        if (nullIndex == 0) {
            return GTValues.emptyFluidStackArray;
        }
        FluidStack[] a = new FluidStack[nullIndex];
        System.arraycopy(array, 0, a, 0, nullIndex);
        return a;
    }

    @Nullable
    public static int[] fixChancesArray(@Nullable int[] chances, int expectedLen) {
        if (chances == null) {
            return null;
        }
        boolean valid = false;
        int len = expectedLen == -1 ? chances.length : Math.min(chances.length, expectedLen);
        for (int i = 0; i < len; ++i) {
            int chance = chances[i];
            if (chance <= 0 || chance >= 10000) continue;
            valid = true;
            break;
        }
        if (!valid) {
            return null;
        }
        boolean needCopy = expectedLen != -1 && expectedLen != chances.length;
        int[] array = needCopy ? Arrays.copyOf(chances, expectedLen) : chances;
        int len2 = array.length;
        for (int i = 0; i < len2; ++i) {
            int chance = array[i];
            if (chance > 0 && chance <= 10000) continue;
            array[i] = 10000;
        }
        return array;
    }
}

