/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class NBTPersist {
    public static JsonElement toJsonObject(NBTBase nbt) {
        if (nbt == null) {
            return null;
        }
        if (nbt instanceof NBTTagCompound) {
            NBTTagCompound compound = (NBTTagCompound)nbt;
            Map tagMap = compound.field_74784_a;
            JsonObject root = new JsonObject();
            for (Map.Entry nbtEntry : tagMap.entrySet()) {
                root.add((String)nbtEntry.getKey(), NBTPersist.toJsonObject((NBTBase)nbtEntry.getValue()));
            }
            return root;
        }
        if (nbt instanceof NBTTagByte) {
            return new JsonPrimitive((Number)((NBTTagByte)nbt).func_150290_f());
        }
        if (nbt instanceof NBTTagShort) {
            return new JsonPrimitive((Number)((NBTTagShort)nbt).func_150289_e());
        }
        if (nbt instanceof NBTTagInt) {
            return new JsonPrimitive((Number)((NBTTagInt)nbt).func_150287_d());
        }
        if (nbt instanceof NBTTagLong) {
            return new JsonPrimitive((Number)((NBTTagLong)nbt).func_150291_c());
        }
        if (nbt instanceof NBTTagFloat) {
            return new JsonPrimitive((Number)Float.valueOf(((NBTTagFloat)nbt).func_150288_h()));
        }
        if (nbt instanceof NBTTagDouble) {
            return new JsonPrimitive((Number)((NBTTagDouble)nbt).func_150286_g());
        }
        if (nbt instanceof NBTBase.NBTPrimitive) {
            return new JsonPrimitive((Number)((NBTBase.NBTPrimitive)nbt).func_150286_g());
        }
        if (nbt instanceof NBTTagString) {
            return new JsonPrimitive(((NBTTagString)nbt).func_150285_a_());
        }
        if (nbt instanceof NBTTagList) {
            NBTTagList list = (NBTTagList)nbt;
            JsonArray arr = new JsonArray();
            list.field_74747_a.forEach(c -> arr.add(NBTPersist.toJsonObject((NBTBase)c)));
            return arr;
        }
        if (nbt instanceof NBTTagIntArray) {
            NBTTagIntArray list = (NBTTagIntArray)nbt;
            JsonArray arr = new JsonArray();
            for (int i : list.func_150302_c()) {
                arr.add((JsonElement)new JsonPrimitive((Number)i));
            }
            return arr;
        }
        if (nbt instanceof NBTTagByteArray) {
            NBTTagByteArray list = (NBTTagByteArray)nbt;
            JsonArray arr = new JsonArray();
            for (byte i : list.func_150292_c()) {
                arr.add((JsonElement)new JsonPrimitive((Number)i));
            }
            return arr;
        }
        throw new IllegalArgumentException("Unsupported NBT Tag: " + NBTBase.field_82578_b[nbt.func_74732_a()] + " - " + nbt);
    }

    public static NBTBase toNbt(JsonElement jsonElement) {
        if (jsonElement == null || jsonElement == JsonNull.INSTANCE) {
            return null;
        }
        if (jsonElement instanceof JsonPrimitive) {
            JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonElement;
            if (jsonPrimitive.isNumber()) {
                float fval;
                if (jsonPrimitive.getAsBigDecimal().remainder(BigDecimal.ONE).equals(BigDecimal.ZERO)) {
                    long lval = jsonPrimitive.getAsLong();
                    if (lval >= -128L && lval <= 127L) {
                        return new NBTTagByte((byte)lval);
                    }
                    if (lval >= -32768L && lval <= 32767L) {
                        return new NBTTagShort((short)lval);
                    }
                    if (lval >= Integer.MIN_VALUE && lval <= Integer.MAX_VALUE) {
                        return new NBTTagInt((int)lval);
                    }
                    return new NBTTagLong(lval);
                }
                double dval = jsonPrimitive.getAsDouble();
                if (Math.abs(dval - (double)(fval = (float)dval)) < 1.0E-4) {
                    return new NBTTagFloat(fval);
                }
                return new NBTTagDouble(dval);
            }
            return new NBTTagString(jsonPrimitive.getAsString());
        }
        if (jsonElement instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)jsonElement;
            ArrayList<NBTBase> nbtList = new ArrayList<NBTBase>();
            byte type = -1;
            for (JsonElement element : jsonArray) {
                NBTBase tag;
                if (element == null || element == JsonNull.INSTANCE || (tag = NBTPersist.toNbt(element)) == null) continue;
                if (type == -1) {
                    type = tag.func_74732_a();
                }
                if (type != tag.func_74732_a()) {
                    throw new IllegalArgumentException("NBT lists cannot contain tags of varying types");
                }
                nbtList.add(tag);
            }
            if (type == 3) {
                return new NBTTagIntArray(nbtList.stream().mapToInt(i -> ((NBTTagInt)i).func_150287_d()).toArray());
            }
            if (type == 1) {
                byte[] abyte = new byte[nbtList.size()];
                for (int i2 = 0; i2 < nbtList.size(); ++i2) {
                    abyte[i2] = ((NBTTagByte)nbtList.get(i2)).func_150290_f();
                }
                return new NBTTagByteArray(abyte);
            }
            NBTTagList nbtTagList = new NBTTagList();
            nbtList.forEach(arg_0 -> ((NBTTagList)nbtTagList).func_74742_a(arg_0));
            return nbtTagList;
        }
        if (jsonElement instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonElement;
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            for (Map.Entry jsonEntry : jsonObject.entrySet()) {
                if (jsonEntry.getValue() == JsonNull.INSTANCE) continue;
                nbtTagCompound.func_74782_a((String)jsonEntry.getKey(), NBTPersist.toNbt((JsonElement)jsonEntry.getValue()));
            }
            return nbtTagCompound;
        }
        throw new IllegalArgumentException("Unhandled element " + jsonElement);
    }

    public static JsonElement toJsonObjectExact(NBTBase nbt) {
        if (nbt == null) {
            return null;
        }
        if (nbt instanceof NBTTagCompound) {
            NBTTagCompound compound = (NBTTagCompound)nbt;
            Map tagMap = compound.field_74784_a;
            JsonObject root = new JsonObject();
            for (Map.Entry nbtEntry : tagMap.entrySet()) {
                root.add((String)nbtEntry.getKey(), NBTPersist.toJsonObjectExact((NBTBase)nbtEntry.getValue()));
            }
            return root;
        }
        if (nbt instanceof NBTTagByte) {
            NBTTagByte b = (NBTTagByte)nbt;
            return new JsonPrimitive("b" + b.func_150290_f());
        }
        if (nbt instanceof NBTTagShort) {
            NBTTagShort half = (NBTTagShort)nbt;
            return new JsonPrimitive("h" + half.func_150289_e());
        }
        if (nbt instanceof NBTTagInt) {
            NBTTagInt i = (NBTTagInt)nbt;
            return new JsonPrimitive("i" + Integer.toUnsignedString(i.func_150287_d(), 16));
        }
        if (nbt instanceof NBTTagLong) {
            NBTTagLong l = (NBTTagLong)nbt;
            return new JsonPrimitive("l" + Long.toUnsignedString(l.func_150291_c(), 16));
        }
        if (nbt instanceof NBTTagFloat) {
            NBTTagFloat f = (NBTTagFloat)nbt;
            return new JsonPrimitive("f" + Long.toUnsignedString(Float.floatToIntBits(f.func_150288_h()), 16));
        }
        if (nbt instanceof NBTTagDouble) {
            NBTTagDouble d = (NBTTagDouble)nbt;
            return new JsonPrimitive("d" + Long.toUnsignedString(Double.doubleToLongBits(d.func_150286_g()), 16));
        }
        if (nbt instanceof NBTBase.NBTPrimitive) {
            NBTBase.NBTPrimitive other = (NBTBase.NBTPrimitive)nbt;
            return new JsonPrimitive("d" + Long.toUnsignedString(Double.doubleToLongBits(other.func_150286_g()), 16));
        }
        if (nbt instanceof NBTTagString) {
            NBTTagString s = (NBTTagString)nbt;
            return new JsonPrimitive("s" + s.func_150285_a_());
        }
        if (nbt instanceof NBTTagList) {
            NBTTagList l = (NBTTagList)nbt;
            JsonArray arr = new JsonArray();
            l.field_74747_a.forEach(c -> arr.add(NBTPersist.toJsonObjectExact((NBTBase)c)));
            return arr;
        }
        if (nbt instanceof NBTTagIntArray) {
            NBTTagIntArray a = (NBTTagIntArray)nbt;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            for (int i : a.func_150302_c()) {
                try {
                    dos.writeInt(i);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return new JsonPrimitive("1" + Base64.getEncoder().encodeToString(baos.toByteArray()));
        }
        if (nbt instanceof NBTTagByteArray) {
            NBTTagByteArray a = (NBTTagByteArray)nbt;
            return new JsonPrimitive("2" + Base64.getEncoder().encodeToString(a.func_150292_c()));
        }
        throw new IllegalArgumentException("Unsupported NBT Tag: " + NBTBase.field_82578_b[nbt.func_74732_a()] + " - " + nbt);
    }

    public static NBTBase toNbtExact(JsonElement jsonElement) throws JsonParseException {
        if (jsonElement == null) {
            return null;
        }
        if (jsonElement instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)jsonElement;
            if (!primitive.isString()) {
                throw new JsonParseException("expected json primitive to be string: '" + primitive + "'");
            }
            String data = primitive.getAsString();
            if (data.length() < 2) {
                throw new JsonParseException("illegal json primitive string: '" + data + "'");
            }
            char prefix = data.charAt(0);
            data = data.substring(1);
            try {
                switch (prefix) {
                    case 'b': {
                        return new NBTTagByte(Byte.parseByte(data));
                    }
                    case 'h': {
                        return new NBTTagShort(Short.parseShort(data));
                    }
                    case 'i': {
                        return new NBTTagInt(Integer.parseUnsignedInt(data, 16));
                    }
                    case 'l': {
                        return new NBTTagLong(Long.parseUnsignedLong(data, 16));
                    }
                    case 'f': {
                        return new NBTTagFloat(Float.intBitsToFloat((int)Long.parseUnsignedLong(data, 16)));
                    }
                    case 'd': {
                        return new NBTTagDouble(Double.longBitsToDouble(Long.parseUnsignedLong(data, 16)));
                    }
                    case 's': {
                        return new NBTTagString(data);
                    }
                    case '1': {
                        ByteArrayInputStream bais = new ByteArrayInputStream(Base64.getDecoder().decode(data));
                        DataInputStream dis = new DataInputStream(bais);
                        int count = bais.available() / 4;
                        int[] array = new int[count];
                        for (int i = 0; i < count; ++i) {
                            try {
                                array[i] = dis.readInt();
                                continue;
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        return new NBTTagIntArray(array);
                    }
                    case '2': {
                        return new NBTTagByteArray(Base64.getDecoder().decode(data));
                    }
                }
            }
            catch (NumberFormatException e) {
                throw new JsonParseException("illegal number: " + primitive, (Throwable)e);
            }
        } else {
            if (jsonElement instanceof JsonArray) {
                JsonArray array = (JsonArray)jsonElement;
                NBTTagList list = new NBTTagList();
                for (JsonElement e : array) {
                    list.func_74742_a(NBTPersist.toNbtExact(e));
                }
                return list;
            }
            if (jsonElement instanceof JsonObject) {
                JsonObject obj = (JsonObject)jsonElement;
                NBTTagCompound tag = new NBTTagCompound();
                for (Map.Entry jsonEntry : obj.entrySet()) {
                    tag.func_74782_a((String)jsonEntry.getKey(), NBTPersist.toNbtExact((JsonElement)jsonEntry.getValue()));
                }
                return tag;
            }
        }
        throw new IllegalArgumentException("Unhandled element " + jsonElement);
    }

    public static class ExactNBTTypeAdapter
    implements JsonSerializer<NBTBase>,
    JsonDeserializer<NBTBase> {
        public NBTBase deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return NBTPersist.toNbtExact(json);
        }

        public JsonElement serialize(NBTBase src, Type typeOfSrc, JsonSerializationContext context) {
            return NBTPersist.toJsonObjectExact(src);
        }
    }
}

