/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.enums.GTValues;
import gregtech.api.util.GTUtility;
import gregtech.mixin.interfaces.accessors.WeightedRandomFishableAccessor;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import java.util.ArrayList;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomFishable;
import net.minecraftforge.common.FishingHooks;

public class FishPondRecipes {
    public static void generateFishPondRecipes() {
        try {
            ArrayList fishList = (ArrayList)GTUtility.getField(FishingHooks.class, "fish").get(null);
            ArrayList junkList = (ArrayList)GTUtility.getField(FishingHooks.class, "junk").get(null);
            ArrayList treasureList = (ArrayList)GTUtility.getField(FishingHooks.class, "treasure").get(null);
            FishPondRecipes.generateRecipes(14, fishList, 0.85);
            FishPondRecipes.generateRecipes(15, junkList, 1.35);
            FishPondRecipes.generateRecipes(16, treasureList, 20.0);
        }
        catch (Exception e) {
            Logger.INFO("Error reading the vanilla fishing loot table.");
            e.printStackTrace();
        }
    }

    private static void generateRecipes(int circuitType, ArrayList<WeightedRandomFishable> lootTable, double chanceMultiplier) {
        int[] chances = new int[lootTable.size()];
        ItemStack[] outputs = new ItemStack[lootTable.size()];
        for (int i = 0; i < lootTable.size(); ++i) {
            ItemFishFood.FishType fishtype;
            WeightedRandomFishable fishable = lootTable.get(i);
            chances[i] = (int)((double)(fishable.field_76292_a * 100) * chanceMultiplier);
            ItemStack output = ((WeightedRandomFishableAccessor)fishable).gt5u$getLoot();
            if (output.func_77973_b() instanceof ItemFishFood && (fishtype = ItemFishFood.FishType.func_150978_a((ItemStack)output)) == ItemFishFood.FishType.PUFFERFISH) {
                chances[i] = chances[i] * 3;
            }
            outputs[i] = output;
        }
        GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(circuitType)).itemOutputs(outputs, chances).duration(200).eut(16).ignoreCollision().addTo(GTPPRecipeMaps.fishPondRecipes);
    }
}

