/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.mothership;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.helper.PlayerID;
import de.katzenpapst.amunra.mothership.Mothership;
import de.katzenpapst.amunra.network.packet.PacketSimpleAR;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.common.DimensionManager;

public class MothershipWorldData
extends WorldSavedData {
    public static final String saveDataID = "ARMothershipData";
    private final Map<CelestialBody, Float> orbitDistances = new HashMap<CelestialBody, Float>();
    private int highestId = 0;
    private int numTicksWithoutSave = 0;
    protected final HashMap<Integer, Mothership> mothershipIdList = new HashMap();
    protected final Map<Integer, Mothership> mothershipsByDimension = new HashMap<Integer, Mothership>();

    public MothershipWorldData(String id) {
        super(id);
    }

    public HashMap<Integer, Mothership> getMotherships() {
        return (HashMap)this.mothershipIdList.clone();
    }

    protected void updateAllOrbits() {
        Map<CelestialBody, Integer> bodies = this.getBodiesWithShips();
        for (CelestialBody b : bodies.keySet()) {
            this.updateOrbitsFor(b);
        }
    }

    protected void updateOrbitsFor(CelestialBody parent) {
        if (parent == null) {
            return;
        }
        List<Mothership> list = this.getMothershipsForParent(parent);
        int numShips = list.size();
        float twoPi = (float)Math.PI * 2;
        float angle = (float)Math.PI * 2 / (float)numShips;
        Random rand = new Random(parent.getName().hashCode());
        float phaseOffset = rand.nextFloat() * ((float)Math.PI * 2);
        float orbitDistance = this.getMothershipOrbitDistanceFor(parent);
        for (Mothership ms : list) {
            if (phaseOffset > (float)Math.PI * 2) {
                phaseOffset -= (float)Math.PI * 2;
            }
            ms.setPhaseShift(phaseOffset);
            ms.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(orbitDistance, orbitDistance));
            phaseOffset += angle;
        }
        this.func_76185_a();
    }

    public float getMothershipOrbitDistanceFor(CelestialBody parent) {
        if (this.orbitDistances.get(parent) != null) {
            return this.orbitDistances.get(parent).floatValue();
        }
        float orbitSize = -1.0f;
        if (parent instanceof Planet) {
            for (Moon moon : GalaxyRegistry.getRegisteredMoons().values()) {
                if (moon.getParentPlanet() != parent || orbitSize != -1.0f && !(orbitSize > moon.getRelativeDistanceFromCenter().unScaledDistance)) continue;
                orbitSize = moon.getRelativeDistanceFromCenter().unScaledDistance;
            }
            for (Satellite satellite : GalaxyRegistry.getRegisteredSatellites().values()) {
                if (satellite.getParentPlanet() != parent || orbitSize != -1.0f && !(orbitSize > satellite.getRelativeDistanceFromCenter().unScaledDistance)) continue;
                orbitSize = satellite.getRelativeDistanceFromCenter().unScaledDistance;
            }
            orbitSize = orbitSize == -1.0f ? 10.0f : (orbitSize -= 1.0f);
        } else {
            orbitSize = 5.0f;
        }
        this.orbitDistances.put(parent, Float.valueOf(orbitSize));
        return orbitSize;
    }

    public Mothership registerNewMothership(EntityPlayer player, CelestialBody currentParent) {
        int newId;
        if (this.mothershipIdList.get(newId = ++this.highestId) != null) {
            throw new RuntimeException("Somehow highestID is already used");
        }
        int newDimensionID = DimensionManager.getNextFreeDimId();
        DimensionManager.registerDimension((int)newDimensionID, (int)AmunRa.config.mothershipProviderID);
        Mothership ship = new Mothership(newId, new PlayerID(player));
        ship.setParent(currentParent);
        ship.setDimensionInfo(newDimensionID);
        this.mothershipIdList.put(newId, ship);
        this.mothershipsByDimension.put(newDimensionID, ship);
        this.updateOrbitsFor(currentParent);
        this.func_76185_a();
        NBTTagCompound data = new NBTTagCompound();
        ship.writeToNBT(data);
        AmunRa.packetPipeline.sendToAll(new PacketSimpleAR(PacketSimpleAR.EnumSimplePacket.C_NEW_MOTHERSHIP_CREATED, data));
        return ship;
    }

    @SideOnly(value=Side.CLIENT)
    public Mothership addMothership(Mothership ship) {
        if (MinecraftServer.func_71276_C() != null && !MinecraftServer.func_71276_C().func_71262_S()) {
            this.updateOrbitsFor(ship.getParent());
            return this.getByMothershipId(ship.getID());
        }
        if (ship.getID() > this.highestId) {
            this.highestId = ship.getID();
        }
        if (this.mothershipIdList.get(ship.getID()) != null) {
            throw new RuntimeException("Mothership " + ship.getID() + " is already registered, this shouldn't happen...");
        }
        this.maybeRegisterDimension(ship.getDimensionID());
        this.mothershipIdList.put(ship.getID(), ship);
        this.mothershipsByDimension.put(ship.getDimensionID(), ship);
        this.updateOrbitsFor(ship.getParent());
        return ship;
    }

    public int getNumMothershipsForParent(CelestialBody parent) {
        if (parent == null) {
            return 0;
        }
        return (int)this.mothershipIdList.values().stream().map(Mothership::getParent).filter(arg_0 -> ((CelestialBody)parent).equals(arg_0)).count();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasMothershipsInOrbit(CelestialBody parent) {
        if (parent == null) return false;
        if (!this.mothershipIdList.values().stream().map(Mothership::getParent).anyMatch(arg_0 -> ((CelestialBody)parent).equals(arg_0))) return false;
        return true;
    }

    public List<Mothership> getMothershipsForParent(CelestialBody parent) {
        if (parent == null) {
            return new ArrayList<Mothership>(0);
        }
        return this.mothershipIdList.values().stream().filter(ship -> parent.equals((Object)ship.getParent())).collect(Collectors.toList());
    }

    public int getNumMothershipsForPlayer(PlayerID player) {
        return (int)this.mothershipIdList.values().stream().filter(ship -> ship.isPlayerOwner(player)).count();
    }

    public int getNumMothershipsForPlayer(EntityPlayer player) {
        return this.getNumMothershipsForPlayer(new PlayerID(player));
    }

    public Map<CelestialBody, Integer> getBodiesWithShips() {
        HashMap<CelestialBody, Integer> result = new HashMap<CelestialBody, Integer>();
        for (Mothership curM : this.mothershipIdList.values()) {
            CelestialBody parent = curM.getParent();
            if (parent == null) continue;
            if (result.containsKey(parent)) {
                result.put(parent, (Integer)result.get(parent) + 1);
                continue;
            }
            result.put(parent, 1);
        }
        return result;
    }

    public Mothership getByDimensionId(int dimId) {
        return this.mothershipsByDimension.get(dimId);
    }

    public Mothership getByMothershipId(int id) {
        return this.mothershipIdList.get(id);
    }

    public Mothership getByName(String name) {
        return this.mothershipIdList.values().stream().filter(ship -> ship.getName().equals(name)).findFirst().orElse(null);
    }

    public void func_76184_a(NBTTagCompound p_76184_1_) {
        NBTTagList tagList = p_76184_1_.func_150295_c("MothershipList", 10);
        this.mothershipIdList.clear();
        this.mothershipsByDimension.clear();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound nbt2 = tagList.func_150305_b(i);
            Mothership m = Mothership.createFromNBT(nbt2);
            if (this.highestId < m.getID()) {
                this.highestId = m.getID();
            }
            if (DimensionManager.isDimensionRegistered((int)m.getDimensionID())) {
                if (DimensionManager.getProviderType((int)m.getDimensionID()) != AmunRa.config.mothershipProviderID) {
                    throw new RuntimeException("Dimension " + m.getDimensionID() + " should be registered for an AmunRa Mothership, registered for " + DimensionManager.getProviderType((int)m.getDimensionID()) + " instead");
                }
            } else {
                DimensionManager.registerDimension((int)m.getDimensionID(), (int)AmunRa.config.mothershipProviderID);
            }
            this.mothershipIdList.put(m.getID(), m);
            this.mothershipsByDimension.put(m.getDimensionID(), m);
        }
        this.updateAllOrbits();
    }

    protected void maybeRegisterDimension(int dimId) {
        if (!DimensionManager.isDimensionRegistered((int)dimId)) {
            DimensionManager.registerDimension((int)dimId, (int)AmunRa.config.mothershipProviderID);
        } else {
            int type = DimensionManager.getProviderType((int)dimId);
            if (type != AmunRa.config.mothershipProviderID) {
                throw new RuntimeException("Dimension " + dimId + " could not be registered for mothership because it's already taken");
            }
        }
    }

    public void func_76187_b(NBTTagCompound p_76187_1_) {
        NBTTagList tagList = new NBTTagList();
        for (Mothership m : this.mothershipIdList.values()) {
            NBTTagCompound nbt2 = new NBTTagCompound();
            m.writeToNBT(nbt2);
            tagList.func_74742_a((NBTBase)nbt2);
        }
        p_76187_1_.func_74782_a("MothershipList", (NBTBase)tagList);
    }

    public void tickAllMotherships() {
        boolean hasChanged = false;
        for (Mothership m : this.mothershipIdList.values()) {
            if (!m.isInTransit()) continue;
            ++this.numTicksWithoutSave;
            hasChanged = true;
            if (m.modRemainingTravelTime(-1) > 0L) continue;
            m.getWorldProviderServer().endTransit();
            AmunRa.packetPipeline.sendToAll(new PacketSimpleAR(PacketSimpleAR.EnumSimplePacket.C_MOTHERSHIP_TRANSIT_ENDED, m.getID()));
        }
        if ((hasChanged || !hasChanged && this.numTicksWithoutSave > 0) && this.numTicksWithoutSave >= 1200) {
            this.numTicksWithoutSave = 0;
            this.func_76185_a();
        }
    }

    public void tickAllMothershipsClient() {
        for (Mothership m : this.mothershipIdList.values()) {
            if (!m.isInTransit() || m.getRemainingTravelTime() <= 0L) continue;
            m.modRemainingTravelTime(-1);
        }
    }

    public void unregisterAllMotherships() {
        for (Integer dimID : this.mothershipsByDimension.keySet()) {
            DimensionManager.unregisterDimension((int)dimID);
        }
        this.mothershipIdList.clear();
        this.mothershipsByDimension.clear();
    }
}

