/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.optimization;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import makamys.coretweaks.CoreTweaks;
import makamys.coretweaks.util.DefaultLibraries;
import net.minecraft.client.resources.DefaultResourcePack;
import net.minecraft.launchwrapper.Launch;

public class PrefixedClasspathResourceAccelerator {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("coretweaks.debugPrefixedClasspathResourceAccelerator", "false"));
    private boolean skipLibraries = true;
    private List<Index> classSources;
    private Map<String, List<Index>> directoryOwners = new HashMap<String, List<Index>>();

    private void init() {
        long t0 = System.nanoTime();
        this.classSources = new ArrayList<Index>();
        for (URL url : Launch.classLoader.getSources().stream().distinct().collect(Collectors.toList())) {
            if (this.skipLibraries && DefaultLibraries.isDefaultLibrary(url)) continue;
            try {
                this.classSources.add(Index.fromURL(url));
            }
            catch (Exception e) {
                CoreTweaks.LOGGER.warn("Failed to index file " + url, (Throwable)e);
            }
        }
        long t1 = System.nanoTime();
        CoreTweaks.LOGGER.debug("Indexed classpath resources in " + (double)(t1 - t0) / 1.0E9 + "s");
    }

    private List<Index> findDirectoryOwners(String path) {
        List<Index> cached = this.directoryOwners.get(path);
        if (cached != null) {
            return cached;
        }
        ArrayList<Index> owners = new ArrayList<Index>();
        if (!path.contains("/")) {
            for (Index source : this.classSources) {
                if (!source.hasDirectory(path)) continue;
                owners.add(source);
            }
        } else {
            String parentPath = path.substring(0, path.lastIndexOf(47));
            List<Index> parentOwners = this.findDirectoryOwners(parentPath);
            for (Index s : parentOwners) {
                if (!s.hasDirectory(path)) continue;
                owners.add(s);
            }
        }
        this.directoryOwners.put(path, owners);
        return owners;
    }

    private InputStream findResourceAsStream(String path) {
        if (this.classSources == null) {
            this.init();
        }
        String parentPath = path.substring(0, path.lastIndexOf(47));
        List<Index> directoryOwners = this.findDirectoryOwners(parentPath);
        for (Index source : directoryOwners) {
            InputStream is = source.openStream(path);
            if (is == null) continue;
            return is;
        }
        return null;
    }

    public InputStream getResourceAsStream(String path) {
        InputStream vanillaResult = null;
        if (DEBUG) {
            vanillaResult = DefaultResourcePack.class.getResourceAsStream(path);
        }
        InputStream result = null;
        try {
            result = this.findResourceAsStream(path.substring(1));
        }
        catch (Exception e) {
            CoreTweaks.LOGGER.error("DefaultResourcePack accelerator failed to find resource " + path);
            e.printStackTrace();
        }
        if (DEBUG && vanillaResult == null != (result == null)) {
            CoreTweaks.LOGGER.error("Mismatch detected in DefaultResourcePack optimization! (path=" + path + ", vanillaResult=" + vanillaResult + ", result=" + result + ") Please report the issue and disable the option (`fast_default_resource_pack`) for now.");
        }
        return result;
    }

    public static interface Index {
        public boolean hasDirectory(String var1);

        public InputStream openStream(String var1) throws IOException;

        public static Index fromURL(URL url) {
            if (url.getProtocol().equals("file")) {
                if (url.getPath().endsWith(".jar")) {
                    return new JarIndex(url);
                }
                return new DirectoryIndex(url);
            }
            throw new IllegalArgumentException("Unknown protocol: " + url.getProtocol());
        }
    }

    public static class DirectoryIndex
    implements Index {
        Map<String, Boolean> directoryExists = new HashMap<String, Boolean>();
        URL url;
        File file;

        public DirectoryIndex(URL url) {
            this.url = url;
            this.file = Paths.get(url.toURI()).toFile();
        }

        @Override
        public boolean hasDirectory(String directory) {
            return this.directoryExists(directory);
        }

        private boolean directoryExists(String directory) {
            String parent;
            Boolean cached = this.directoryExists.get(directory);
            if (cached != null) {
                return cached;
            }
            boolean exists = false;
            boolean isTopLevel = !directory.contains("/");
            String string = parent = isTopLevel ? null : directory.substring(0, directory.lastIndexOf(47));
            if (isTopLevel || this.directoryExists(parent)) {
                exists = new File(this.file, directory).exists();
            }
            this.directoryExists.put(directory, exists);
            return exists;
        }

        @Override
        public InputStream openStream(String path) throws IOException {
            try {
                return new URL(this.url.toString() + path).openStream();
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public static class JarIndex
    implements Index {
        Set<String> directories = new HashSet<String>();
        URL url;

        public JarIndex(URL url) {
            this.url = url;
            File f = Paths.get(url.toURI()).toFile();
            try (ZipFile zf = new ZipFile(f);){
                Enumeration<? extends ZipEntry> entries = zf.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry ze = entries.nextElement();
                    String dirName = null;
                    if (ze.isDirectory()) {
                        String name = ze.getName();
                        dirName = name = name.substring(0, name.length() - 1);
                    } else {
                        String s = ze.getName();
                        if (s.contains("/")) {
                            dirName = s.substring(0, s.lastIndexOf("/"));
                        }
                    }
                    if (dirName == null) continue;
                    while (this.directories.add(dirName) && dirName.contains("/")) {
                        dirName = dirName.substring(0, dirName.lastIndexOf("/"));
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }

        @Override
        public boolean hasDirectory(String directory) {
            return this.directories.contains(directory);
        }

        @Override
        public InputStream openStream(String path) throws IOException {
            try {
                return new URL("jar:" + this.url.toString() + "!/" + path).openStream();
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

