/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.world.nether.dimension;

import com.google.common.collect.Lists;
import ganymedes01.etfuturum.world.nether.dimension.BiomeCacheBlockNether;
import ganymedes01.etfuturum.world.nether.dimension.NetherWorldChunkManager;
import java.util.Iterator;
import java.util.List;
import net.minecraft.util.LongHashMap;
import net.minecraft.world.biome.BiomeGenBase;

public class BiomeCacheNether {
    private final NetherWorldChunkManager chunkManager;
    private long lastCleanupTime = 0L;
    private final LongHashMap cacheMap = new LongHashMap();
    private final List<BiomeCacheBlockNether> cache = Lists.newArrayList();

    public BiomeCacheNether(NetherWorldChunkManager par1WorldChunkManager) {
        this.chunkManager = par1WorldChunkManager;
    }

    public BiomeCacheBlockNether getBiomeCacheBlock(int par1, int par2) {
        long var3 = (long)(par1 >>= 4) & 0xFFFFFFFFL | ((long)(par2 >>= 4) & 0xFFFFFFFFL) << 32;
        BiomeCacheBlockNether var5 = (BiomeCacheBlockNether)this.cacheMap.func_76164_a(var3);
        if (var5 == null) {
            var5 = new BiomeCacheBlockNether(this, par1, par2);
            this.cacheMap.func_76163_a(var3, (Object)var5);
            this.cache.add(var5);
        }
        var5.lastAccessTime = System.currentTimeMillis();
        return var5;
    }

    public BiomeGenBase getBiomeGenAt(int par1, int par2) {
        return this.getBiomeCacheBlock(par1, par2).getBiomeGenAt(par1, par2);
    }

    public void cleanupCache() {
        long var1 = System.currentTimeMillis();
        long var3 = var1 - this.lastCleanupTime;
        if (var3 > 7500L || var3 < 0L) {
            this.lastCleanupTime = var1;
            Iterator<BiomeCacheBlockNether> iterator = this.cache.iterator();
            while (iterator.hasNext()) {
                BiomeCacheBlockNether block = iterator.next();
                long var7 = var1 - block.lastAccessTime;
                if (var7 <= 30000L && var7 >= 0L) continue;
                iterator.remove();
                long var9 = (long)block.xPosition & 0xFFFFFFFFL | ((long)block.zPosition & 0xFFFFFFFFL) << 32;
                this.cacheMap.func_76159_d(var9);
            }
        }
    }

    public BiomeGenBase[] getCachedBiomes(int par1, int par2) {
        return this.getBiomeCacheBlock((int)par1, (int)par2).biomes;
    }

    static NetherWorldChunkManager getChunkManager(BiomeCacheNether par0BiomeCache) {
        return par0BiomeCache.chunkManager;
    }
}

