/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.spectator;

import com.google.common.collect.Sets;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import ganymedes01.etfuturum.compat.ExternalContent;
import ganymedes01.etfuturum.configuration.configs.ConfigMixins;
import ganymedes01.etfuturum.core.utils.helpers.SafeEnumHelperClient;
import ganymedes01.etfuturum.entities.EntityNewBoatWithChest;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInvBasic;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;

public class SpectatorMode {
    public static final SpectatorMode INSTANCE = new SpectatorMode();
    public static final IEntitySelector EXCEPT_SPECTATING;
    public static final Set<Block> SPECTATOR_INTERACT_BLACKLIST;
    protected static final Map<EntityPlayer, Entity> SPECTATING_ENTITIES;
    public static WorldSettings.GameType SPECTATOR_GAMETYPE;
    private final Map<EntityPlayer, Boolean> prevIsSpecClient = new WeakHashMap<EntityPlayer, Boolean>();
    private final Map<EntityPlayer, Boolean> prevIsSpecServer = new WeakHashMap<EntityPlayer, Boolean>();

    protected SpectatorMode() {
    }

    public static void init() {
        if (ConfigMixins.enableSpectatorMode) {
            SPECTATOR_GAMETYPE = SafeEnumHelperClient.addGameType("spectator", 3, "Spectator");
        }
        SPECTATOR_INTERACT_BLACKLIST.add(ExternalContent.Blocks.GREGTECH_MACHINE.get());
        SPECTATOR_INTERACT_BLACKLIST.add(ExternalContent.Blocks.TCON_SEARED_BLOCK.get());
        SPECTATOR_INTERACT_BLACKLIST.add(ExternalContent.Blocks.TCON_SMELTERY.get());
        SPECTATOR_INTERACT_BLACKLIST.add(ExternalContent.Blocks.THAUMCRAFT_TABLE.get());
    }

    public static boolean isSpectator(EntityPlayer player) {
        if (player == null || player instanceof FakePlayer || player.field_70170_p == null) {
            return false;
        }
        if (player.field_70170_p.field_72995_K) {
            if (player == FMLClientHandler.instance().getClient().field_71439_g && FMLClientHandler.instance().getClient().field_71442_b != null) {
                return FMLClientHandler.instance().getClient().field_71442_b.field_78779_k == SPECTATOR_GAMETYPE;
            }
            return false;
        }
        return player instanceof EntityPlayerMP && ((EntityPlayerMP)player).field_71134_c.func_73081_b() == SPECTATOR_GAMETYPE;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onInteract(PlayerInteractEvent event) {
        if (SpectatorMode.isSpectator(event.entityPlayer)) {
            if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
                event.setCanceled(true);
            } else {
                if (!event.world.func_72899_e(event.x, event.y, event.z)) {
                    event.setCanceled(true);
                    return;
                }
                TileEntity te = event.world.func_147438_o(event.x, event.y, event.z);
                if (!SpectatorMode.canSpectatorSelect(te) || SPECTATOR_INTERACT_BLACKLIST.contains(event.world.func_147439_a(event.x, event.y, event.z))) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onInteract(BlockEvent.PlaceEvent event) {
        if (SpectatorMode.isSpectator(event.player)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onItemPickup(EntityItemPickupEvent event) {
        if (SpectatorMode.isSpectator(event.entityPlayer)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onInteract(AttackEntityEvent event) {
        if (SpectatorMode.isSpectator(event.entityPlayer)) {
            if (!SPECTATING_ENTITIES.containsKey(event.entityPlayer)) {
                SPECTATING_ENTITIES.put(event.entityPlayer, event.target);
                if (event.entityPlayer.field_70170_p.field_72995_K && event.entityPlayer instanceof EntityClientPlayerMP) {
                    Minecraft.func_71410_x().field_71456_v.func_110326_a(I18n.func_135052_a((String)"mount.onboard", (Object[])new Object[]{GameSettings.func_74298_c((int)Minecraft.func_71410_x().field_71474_y.field_74311_E.func_151463_i())}), false);
                }
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onInteract(EntityInteractEvent event) {
        if (SpectatorMode.isSpectator(event.entityPlayer)) {
            if (!event.entityPlayer.field_70170_p.field_72995_K && !(event.target instanceof EntityPlayer) && (event.target instanceof IInvBasic || event.target instanceof IInventory)) {
                this.openInv(event.entityPlayer, event.target);
            }
            event.setCanceled(true);
        }
    }

    private void openInv(EntityPlayer player, Entity target) {
        boolean prevSneaking = player.func_70093_af();
        if (target instanceof EntityNewBoatWithChest) {
            player.func_70095_a(true);
        } else if (target instanceof EntityHorse) {
            if (((EntityHorse)target).func_110228_bR() && ((EntityHorse)target).func_110248_bS()) {
                player.func_70095_a(true);
            } else {
                return;
            }
        }
        target.func_130002_c(player);
        player.func_70095_a(prevSneaking);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Map<EntityPlayer, Boolean> prevIsSpec = event.side == Side.SERVER ? this.prevIsSpecServer : this.prevIsSpecClient;
            boolean isSpec = SpectatorMode.isSpectator(event.player);
            if (isSpec) {
                event.player.field_70145_X = true;
                event.player.field_70122_E = false;
                event.player.func_82142_c(true);
                if (event.player.field_70154_o != null) {
                    event.player.func_110145_l(event.player.field_70154_o);
                    event.player.field_70154_o = null;
                }
            } else if (prevIsSpec.getOrDefault(event.player, false).booleanValue()) {
                event.player.field_70145_X = false;
                event.player.func_82142_c(false);
                SPECTATING_ENTITIES.remove(event.player);
            }
            prevIsSpec.put(event.player, isSpec);
            Entity entityToSpectate = SPECTATING_ENTITIES.get(event.player);
            if (entityToSpectate != null) {
                EntityPlayer spectatingPlayer;
                if (entityToSpectate instanceof EntityPlayer && SpectatorMode.isSpectator(spectatingPlayer = (EntityPlayer)entityToSpectate) || entityToSpectate.field_70128_L || event.player.func_70093_af()) {
                    SPECTATING_ENTITIES.remove(event.player);
                    return;
                }
                this.followEntity(event.player, entityToSpectate);
            }
        }
    }

    protected void followEntity(EntityPlayer player, Entity entity) {
        float yaw;
        float pitch;
        if (entity instanceof EntityLiving) {
            pitch = ((EntityLiving)entity).field_70726_aT;
            yaw = ((EntityLiving)entity).field_70759_as;
        } else {
            pitch = entity.field_70125_A;
            yaw = entity.field_70177_z;
        }
        player.func_70012_b(entity.field_70165_t, entity.field_70163_u - (double)player.field_70129_M + (double)entity.func_70047_e(), entity.field_70161_v, yaw, pitch);
        player.field_70159_w = entity.field_70159_w;
        player.field_70181_x = entity.field_70181_x;
        player.field_70179_y = entity.field_70179_y;
        if (player.func_70051_ag()) {
            player.func_70031_b(false);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void breakSpeed(PlayerEvent.BreakSpeed event) {
        if (SpectatorMode.isSpectator(event.entityPlayer)) {
            EntityClientPlayerMP player;
            if (event.entityPlayer.field_70170_p.field_72995_K && event.entityPlayer == (player = FMLClientHandler.instance().getClient().field_71439_g) && FMLClientHandler.instance().getClient().field_71442_b != null) {
                FMLClientHandler.instance().getClient().field_71442_b.field_78780_h = -5.0f;
                FMLClientHandler.instance().getClient().field_71442_b.field_78778_j = false;
            }
            event.newSpeed = 0.0f;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void itemToss(ItemTossEvent event) {
        if (SpectatorMode.isSpectator(event.player)) {
            event.setCanceled(true);
            ItemStack item = event.entityItem.func_92059_d();
            event.player.field_71071_by.func_70441_a(item);
        }
    }

    public static boolean canSpectatorSelect(TileEntity te) {
        return te instanceof IInventory || te instanceof TileEntityEnderChest;
    }

    static {
        SPECTATOR_INTERACT_BLACKLIST = Sets.newHashSet();
        SPECTATING_ENTITIES = new WeakHashMap<EntityPlayer, Entity>();
        EXCEPT_SPECTATING = new IEntitySelector(){

            public boolean func_82704_a(Entity p_82704_1_) {
                return !(p_82704_1_ instanceof EntityPlayer) || !SpectatorMode.isSpectator((EntityPlayer)p_82704_1_);
            }
        };
        SPECTATOR_GAMETYPE = null;
    }
}

