/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.core.utils;

import ganymedes01.etfuturum.core.utils.Rotation;
import net.minecraft.util.EnumFacing;

public enum Mirror {
    NONE("no_mirror"),
    LEFT_RIGHT("mirror_left_right"),
    FRONT_BACK("mirror_front_back");

    private final String name;
    private static final String[] mirrorNames;

    private Mirror(String nameIn) {
        this.name = nameIn;
    }

    public int mirrorRotation(int rotationIn, int rotationCount) {
        int i = rotationCount / 2;
        int j = rotationIn > i ? rotationIn - rotationCount : rotationIn;
        switch (this) {
            case LEFT_RIGHT: {
                return (rotationCount - j) % rotationCount;
            }
            case FRONT_BACK: {
                return (i - j + rotationCount) % rotationCount;
            }
        }
        return rotationIn;
    }

    public Rotation toRotation(EnumFacing facing) {
        return !(this == LEFT_RIGHT && facing.func_82599_e() != 0 || this == FRONT_BACK && facing.func_82601_c() != 0) ? Rotation.NONE : Rotation.CLOCKWISE_180;
    }

    public EnumFacing mirror(EnumFacing facing) {
        switch (this) {
            case LEFT_RIGHT: {
                if (facing == EnumFacing.WEST) {
                    return EnumFacing.EAST;
                }
                if (facing == EnumFacing.EAST) {
                    return EnumFacing.WEST;
                }
                return facing;
            }
            case FRONT_BACK: {
                if (facing == EnumFacing.NORTH) {
                    return EnumFacing.SOUTH;
                }
                if (facing == EnumFacing.SOUTH) {
                    return EnumFacing.NORTH;
                }
                return facing;
            }
        }
        return facing;
    }

    static {
        mirrorNames = new String[Mirror.values().length];
        int i = 0;
        for (Mirror mirror : Mirror.values()) {
            Mirror.mirrorNames[i++] = mirror.name;
        }
    }
}

