/*
 * Decompiled with CFR 0.152.
 */
package com.muxiu1997.sharewhereiam.util;

import com.muxiu1997.sharewhereiam.localization.Lang;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import journeymap.client.model.Waypoint;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;

@SideOnly(value=Side.CLIENT)
public class WaypointUtil {
    public static PlayerWaypoint waypointOfLocation() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        Waypoint waypoint = Waypoint.of((EntityPlayer)player);
        waypoint.setName(player.getDisplayName());
        waypoint.setColor(Integer.valueOf(0xFFFFFF));
        return new PlayerWaypoint((EntityPlayer)player, waypoint);
    }

    public static PlayerWaypoint waypointOfRayTrace() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        MovingObjectPosition position = player.func_70614_a(128.0, 1.0f);
        Waypoint waypoint = Waypoint.at((int)position.field_72311_b, (int)position.field_72312_c, (int)position.field_72309_d, (Waypoint.Type)Waypoint.Type.Normal, (int)player.field_70170_p.field_73011_w.field_76574_g);
        waypoint.setName(player.getDisplayName());
        waypoint.setColor(Integer.valueOf(0xFFFFFF));
        return new PlayerWaypoint((EntityPlayer)player, waypoint);
    }

    public static String toBase64(Waypoint waypoint) {
        String waypointJSON = waypoint.toString();
        return Base64.getEncoder().encodeToString(waypointJSON.getBytes(StandardCharsets.UTF_8));
    }

    public static Waypoint fromBase64(String base64) {
        String waypointJSON = new String(Base64.getDecoder().decode(base64), StandardCharsets.UTF_8);
        return Waypoint.fromString((String)waypointJSON);
    }

    public static void addShareWaypointChat(String playerName, Waypoint waypoint, String additionalInformation) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        String waypointBase64 = WaypointUtil.toBase64(waypoint);
        IChatComponent chatPartA = new ChatComponentText("").func_150257_a(new ChatComponentText("[JourneyMap]").func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW))).func_150258_a(" ").func_150257_a(new ChatComponentText(playerName).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GREEN))).func_150258_a(" ").func_150258_a(Lang.SHARE_WAYPOINT_MSG.translate());
        IChatComponent chatPartB = new ChatComponentText("").func_150257_a(new ChatComponentText(waypoint.getName()).func_150255_a(new ChatStyle().func_150227_a(Boolean.valueOf(true)))).func_150258_a(" ").func_150257_a(new ChatComponentText(String.format("(%d, %d, %d)", waypoint.getX(), waypoint.getY(), waypoint.getZ())).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GRAY))).func_150258_a(" ").func_150257_a(new ChatComponentText("[Save]").func_150255_a(new ChatStyle().func_150227_a(Boolean.valueOf(true)).func_150238_a(EnumChatFormatting.BLUE).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(Lang.SHARE_WAYPOINT_SAVE_DESC.translate()))).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/savewaypoint " + waypointBase64 + " false")))).func_150258_a(" ").func_150257_a(new ChatComponentText("[Edit]").func_150255_a(new ChatStyle().func_150227_a(Boolean.valueOf(true)).func_150238_a(EnumChatFormatting.BLUE).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(Lang.SHARE_WAYPOINT_EDIT_DESC.translate()))).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/savewaypoint " + waypointBase64)))).func_150258_a(" ").func_150257_a(new ChatComponentText("[Toggle]").func_150255_a(new ChatStyle().func_150227_a(Boolean.valueOf(true)).func_150238_a(EnumChatFormatting.BLUE).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(Lang.SHARE_WAYPOINT_TOGGLE_DESC.translate()))).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/toggletempbeacon " + waypointBase64))));
        IChatComponent chatPartC = additionalInformation != null && !additionalInformation.isEmpty() ? new ChatComponentText(additionalInformation).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GRAY)) : null;
        player.func_146105_b(chatPartA);
        player.func_146105_b(chatPartB);
        if (chatPartC != null) {
            player.func_146105_b(chatPartC);
        }
    }

    public static Waypoint waypointFromString(String s) {
        return Waypoint.fromString((String)s);
    }

    public static class PlayerWaypoint {
        public final EntityPlayer player;
        public final Waypoint waypoint;

        public PlayerWaypoint(EntityPlayer player, Waypoint waypoint) {
            this.player = player;
            this.waypoint = waypoint;
        }
    }
}

