/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.biome.feature.forest;

import chylex.hee.system.logging.Log;
import chylex.hee.system.logging.Stopwatch;
import chylex.hee.world.structure.island.biome.feature.AbstractIslandStructure;
import chylex.hee.world.structure.island.biome.feature.forest.ravageddungeon.DungeonDir;
import chylex.hee.world.structure.island.biome.feature.forest.ravageddungeon.DungeonElement;
import chylex.hee.world.structure.island.biome.feature.forest.ravageddungeon.DungeonElementList;
import chylex.hee.world.structure.island.biome.feature.forest.ravageddungeon.DungeonElementType;
import chylex.hee.world.structure.island.biome.feature.forest.ravageddungeon.RavagedDungeonGenerator;
import chylex.hee.world.structure.island.biome.feature.forest.ravageddungeon.RavagedDungeonPlacer;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;

public class StructureRavagedDungeon
extends AbstractIslandStructure {
    private static final byte dungW = 26;
    private static final byte dungH = 26;
    private static final byte dungHalfW = 13;
    private static final byte dungHalfH = 13;
    private static final byte scale = 5;
    private static final byte scaleHalf = 2;
    private static final byte hallHeight = 4;
    private static final byte maxEntranceHeight = 10;
    private int islandCenterX;
    private int islandCenterZ;
    private final RavagedDungeonPlacer placer = new RavagedDungeonPlacer(4);

    @Override
    protected boolean generate(Random rand) {
        this.islandCenterX = 104;
        this.islandCenterZ = 104;
        int y = 25;
        while (++y < 80 && this.world.getBlock(this.islandCenterX, y, this.islandCenterZ) != this.surface()) {
        }
        if (y >= 80) {
            return false;
        }
        Stopwatch.time("RavagedDungeonGen");
        RavagedDungeonGenerator gen = new RavagedDungeonGenerator(26, 26, 3, rand);
        int th = 5;
        for (int xx = 0; xx < 26; ++xx) {
            for (int zz = 0; zz < 26; ++zz) {
                int worldX = this.islandCenterX - 65 + xx * 5 + 2;
                int worldZ = this.islandCenterZ - 65 + zz * 5 + 2;
                int yy = y - 10;
                for (int layer = 0; layer < 3; ++layer) {
                    int visibility = 0;
                    if (this.world.getBlock(worldX - 2 - 1, yy - 1, worldZ) != Blocks.field_150377_bs) {
                        ++visibility;
                    }
                    if (this.world.getBlock(worldX + 2 + 1, yy - 1, worldZ) != Blocks.field_150377_bs) {
                        ++visibility;
                    }
                    if (this.world.getBlock(worldX - 2 - 1, yy + th + 1, worldZ) != Blocks.field_150377_bs) {
                        ++visibility;
                    }
                    if (this.world.getBlock(worldX + 2 + 1, yy + th + 1, worldZ) != Blocks.field_150377_bs) {
                        ++visibility;
                    }
                    if (this.world.getBlock(worldX, yy - 1, worldZ - 2 - 1) != Blocks.field_150377_bs) {
                        ++visibility;
                    }
                    if (this.world.getBlock(worldX, yy - 1, worldZ + 2 + 1) != Blocks.field_150377_bs) {
                        ++visibility;
                    }
                    if (this.world.getBlock(worldX, yy + th + 1, worldZ - 2 - 1) != Blocks.field_150377_bs) {
                        ++visibility;
                    }
                    if (this.world.getBlock(worldX, yy + th + 1, worldZ + 2 + 1) != Blocks.field_150377_bs) {
                        ++visibility;
                    }
                    if (this.world.getBlock(worldX, yy + 2, worldZ) != Blocks.field_150377_bs) {
                        ++visibility;
                    }
                    if (visibility > 3 && rand.nextInt(4) != 0) {
                        gen.blockLocation(layer, xx, zz);
                    }
                    yy -= 6;
                }
            }
        }
        if (!gen.generate()) {
            Log.debug("Could not generate Ravaged Dungeon :(", new Object[0]);
            return false;
        }
        Stopwatch.finish("RavagedDungeonGen");
        Stopwatch.time("RavagedDungeonPlace");
        for (int a = 0; a < gen.layers.length; ++a) {
            DungeonElementList elements = gen.layers[a].getElements();
            if (a == 0) {
                y = this.generateEntrance(rand, elements, elements.getAll(DungeonElementType.ENTRANCE).get(0), y);
            }
            if (a == gen.layers.length - 1) {
                this.generateEnd(rand, elements, elements.getAll(DungeonElementType.END), y);
            }
            List<DungeonElement> hallways = elements.getAll(DungeonElementType.HALLWAY);
            for (DungeonElement hallway : hallways) {
                this.generateHallwayWithoutConnections(rand, elements, hallway, y);
            }
            for (DungeonElement hallway : hallways) {
                this.generateConnections(elements, hallway, y);
            }
            for (DungeonElement room : elements.getAll(DungeonElementType.ROOM)) {
                this.generateRoom(rand, elements, room, y);
            }
            if (a < gen.layers.length - 1) {
                this.generateDescendRoom(rand, elements, elements.getAll(DungeonElementType.DESCEND).get(0), y);
            }
            if (a > 0) {
                this.generateConnections(elements, elements.getAll(DungeonElementType.DESCENDBOTTOM).get(0), y);
            }
            y -= 6;
        }
        Stopwatch.finish("RavagedDungeonPlace");
        return true;
    }

    private int generateEntrance(Random rand, DungeonElementList elements, DungeonElement entrance, int y) {
        this.placer.generateEntrance(this.world, rand, this.getElementX(entrance), y, this.getElementZ(entrance), 10, entrance);
        this.generateConnections(elements, entrance, y - 10);
        return y - 10;
    }

    private void generateDescendRoom(Random rand, DungeonElementList elements, DungeonElement descend, int y) {
        this.placer.generateDescend(this.world, rand, this.getElementX(descend), y, this.getElementZ(descend), descend);
        this.generateConnections(elements, descend, y);
    }

    private void generateHallwayWithoutConnections(Random rand, DungeonElementList elements, DungeonElement hallway, int y) {
        this.placer.generateHallway(this.world, rand, this.getElementX(hallway), y, this.getElementZ(hallway), hallway);
    }

    private void generateRoom(Random rand, DungeonElementList elements, DungeonElement room, int y) {
        this.placer.generateRoom(this.world, rand, this.getElementX(room), y, this.getElementZ(room), room);
        this.generateConnections(elements, room, y);
    }

    private void generateEnd(Random rand, DungeonElementList elements, List<DungeonElement> end, int y) {
        if (end.size() != 4) {
            throw new IllegalStateException("Ravaged Dungeon End does not consist of 4 rooms!");
        }
        int[] x = new int[4];
        int[] z = new int[4];
        for (int a = 0; a < 4; ++a) {
            x[a] = this.getElementX(end.get(a));
            z[a] = this.getElementZ(end.get(a));
        }
        this.placer.generateEndLayout(this.world, rand, x, y, z, end);
        for (DungeonElement endElement : end) {
            this.generateConnections(elements, endElement, y);
        }
        this.placer.generateEndContent(this.world, rand, x, y, z, end);
    }

    private void generateConnections(DungeonElementList elements, DungeonElement element, int y) {
        for (DungeonDir dir : DungeonDir.values) {
            if (!element.checkConnection(dir)) continue;
            int px = this.getElementX(element) + dir.addX * 2;
            int pz = this.getElementZ(element) + dir.addY * 2;
            if (element.size == 3) {
                px += dir.addX * 5;
                pz += dir.addY * 5;
            }
            for (int yy = y + 1; yy <= y + 4; ++yy) {
                for (int xx = px - Math.abs(dir.addY); xx <= px + Math.abs(dir.addY); ++xx) {
                    for (int zz = pz - Math.abs(dir.addX); zz <= pz + Math.abs(dir.addX); ++zz) {
                        this.world.setBlock(xx, yy, zz, Blocks.field_150350_a);
                    }
                }
            }
        }
    }

    private int getElementX(DungeonElement element) {
        return this.islandCenterX - 65 + element.x * 5 + 2;
    }

    private int getElementZ(DungeonElement element) {
        return this.islandCenterZ - 65 + element.y * 5 + 2;
    }
}

