/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.system.util;

import chylex.hee.system.J8;
import chylex.hee.system.util.CollectionUtil;
import chylex.hee.system.util.DragonUtil;
import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public final class RecipeUnifier {
    private static final Function<Object, ItemStack> mapToItemStack = new Function<Object, ItemStack>(){

        public ItemStack apply(Object obj) {
            if (obj instanceof ItemStack) {
                return (ItemStack)obj;
            }
            if (obj instanceof ArrayList && !((ArrayList)obj).isEmpty()) {
                return (ItemStack)((ArrayList)obj).get(0);
            }
            return null;
        }
    };
    private static final Function<Object, ItemStack[]> mapToOreStack = new Function<Object, ItemStack[]>(){

        public ItemStack[] apply(Object obj) {
            if (obj instanceof ItemStack) {
                return new ItemStack[]{(ItemStack)obj};
            }
            if (obj instanceof ArrayList) {
                return ((ArrayList)obj).toArray(new ItemStack[((ArrayList)obj).size()]);
            }
            return new ItemStack[0];
        }
    };
    private static final Function<ItemStack, ItemStack[]> mapItemStackToArray = new Function<ItemStack, ItemStack[]>(){

        public ItemStack[] apply(ItemStack is) {
            ItemStack[] itemStackArray;
            if (is == null) {
                itemStackArray = new ItemStack[]{};
            } else {
                ItemStack[] itemStackArray2 = new ItemStack[1];
                itemStackArray = itemStackArray2;
                itemStackArray2[0] = is;
            }
            return itemStackArray;
        }
    };
    private boolean align;
    private boolean pad;

    public RecipeUnifier align() {
        this.align = true;
        return this;
    }

    public RecipeUnifier pad() {
        this.pad = true;
        return this;
    }

    public Recipe unify(IRecipe recipe) {
        boolean isShaped = false;
        ItemStack[] ingredients = null;
        List<ItemStack[]> oreIngredients = null;
        if (recipe instanceof ShapedRecipes) {
            ShapedRecipes shaped = (ShapedRecipes)recipe;
            isShaped = true;
            if (shaped.field_77576_b != 3) {
                ingredients = new ItemStack[9];
                int origIndex = 0;
                for (int y = 0; y < 3; ++y) {
                    for (int x = 0; x < 3; ++x) {
                        ingredients[y * 3 + x] = x >= shaped.field_77576_b || y >= shaped.field_77577_c ? null : shaped.field_77574_d[origIndex++];
                    }
                }
            } else {
                ingredients = (ItemStack[])shaped.field_77574_d.clone();
            }
        } else if (recipe instanceof ShapelessRecipes) {
            ShapelessRecipes shapeless = (ShapelessRecipes)recipe;
            ingredients = ((ShapelessRecipes)recipe).field_77579_b.toArray(new ItemStack[shapeless.field_77579_b.size()]);
        } else if (recipe instanceof ShapedOreRecipe) {
            ingredients = J8.toArray(J8.mapArray(((ShapedOreRecipe)recipe).getInput(), mapToItemStack), ItemStack.class);
            oreIngredients = J8.mapArray(((ShapedOreRecipe)recipe).getInput(), mapToOreStack);
            isShaped = true;
        } else if (recipe instanceof ShapelessOreRecipe) {
            ingredients = J8.toArray(J8.mapList(((ShapelessOreRecipe)recipe).getInput(), mapToItemStack), ItemStack.class);
            oreIngredients = J8.mapList(((ShapelessOreRecipe)recipe).getInput(), mapToOreStack);
        }
        if (this.align && ingredients != null) {
            ingredients = DragonUtil.getNonNullValues(ingredients);
            if (oreIngredients != null) {
                oreIngredients = J8.filterList(oreIngredients, J8.nonNull);
            }
        }
        if (this.pad && ingredients != null) {
            ingredients = Arrays.copyOf(ingredients, 9);
            while (oreIngredients != null && oreIngredients.size() < 9) {
                oreIngredients.add(new ItemStack[0]);
            }
        }
        return new Recipe(recipe.func_77571_b(), ingredients == null ? new ItemStack[]{} : ingredients, oreIngredients, isShaped);
    }

    public static final class Recipe {
        private final ItemStack output;
        private final ItemStack[] ingredients;
        private final List<ItemStack[]> oreIngredients;
        private final boolean isShaped;

        private Recipe(ItemStack output, ItemStack[] ingredients, List<ItemStack[]> oreIngredients, boolean isShaped) {
            this.output = output;
            this.ingredients = ingredients;
            this.oreIngredients = oreIngredients;
            this.isShaped = isShaped;
        }

        public ItemStack getOutput() {
            return this.output;
        }

        public boolean isShaped() {
            return this.isShaped;
        }

        public ItemStack[] getIngredientArray() {
            return this.ingredients;
        }

        public List<ItemStack> getIngredientList() {
            return CollectionUtil.newList(this.ingredients);
        }

        public boolean isOreRecipe() {
            return this.oreIngredients != null;
        }

        public List<ItemStack[]> getOreIngredientList() {
            return this.oreIngredients != null ? this.oreIngredients : J8.mapArray(this.ingredients, mapItemStackToArray);
        }
    }
}

