/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.render.entity;

import chylex.hee.entity.mob.util.IEndermanRenderer;
import chylex.hee.mechanics.misc.Baconizer;
import chylex.hee.proxy.ModCommonProxy;
import chylex.hee.render.model.ModelBaconmanHead;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelEnderman;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class AbstractRenderMobEnderman
extends RenderLiving {
    protected static final ResourceLocation texEndermanEyes = new ResourceLocation("textures/entity/enderman/enderman_eyes.png");
    protected static final ResourceLocation texEndermanBody = new ResourceLocation("textures/entity/enderman/enderman.png");
    protected final ModelEnderman endermanModel;
    protected final Random rand = new Random();

    public AbstractRenderMobEnderman() {
        super((ModelBase)new ModelEnderman(), 0.5f);
        this.endermanModel = (ModelEnderman)this.field_77045_g;
        this.func_77042_a((ModelBase)this.endermanModel);
        if (ModCommonProxy.hardcoreEnderbacon) {
            this.endermanModel.field_78116_c = new ModelBaconmanHead((ModelBase)this.endermanModel, 0, 0);
        }
    }

    protected final void superDoRender(IEndermanRenderer entity, double x, double y, double z, float yaw, float partialTickTime) {
        super.func_76986_a((EntityLiving)entity, x, y, z, yaw, partialTickTime);
    }

    public void renderEnderman(IEndermanRenderer entity, double x, double y, double z, float yaw, float partialTickTime) {
        this.endermanModel.field_78126_a = entity.isCarrying();
        this.endermanModel.field_78125_b = entity.isScreaming();
        if (entity.isScreaming()) {
            double spazzAmount = 0.02;
            x += this.rand.nextGaussian() * spazzAmount;
            z += this.rand.nextGaussian() * spazzAmount;
        }
        this.superDoRender(entity, x, y, z, yaw, partialTickTime);
    }

    protected int renderEyes(IEndermanRenderer enderman, int pass, float partialTickTime) {
        if (pass != 0 || ModCommonProxy.hardcoreEnderbacon) {
            return -1;
        }
        this.func_110776_a(texEndermanEyes);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)1, (int)1);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((!((Entity)enderman).func_82150_aj() ? 1 : 0) != 0);
        int c = 61680;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)(c % 65536), (float)(c / 65536));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return 1;
    }

    protected void renderEquippedItems(IEndermanRenderer enderman, float partialTickTime) {
        ItemStack carrying = enderman.getCarrying();
        if (carrying != null) {
            GL11.glEnable((int)32826);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.6875f, (float)-0.75f);
            GL11.glRotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)-0.5f, (float)-0.5f, (float)0.5f);
            int brightness = ((Entity)enderman).func_70070_b(partialTickTime);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)brightness % 65536.0f), (float)((float)brightness / 65536.0f));
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_110776_a(TextureMap.field_110575_b);
            this.field_147909_c.func_147800_a(Block.func_149634_a((Item)carrying.func_77973_b()), carrying.func_77960_j(), 1.0f);
            GL11.glPopMatrix();
            GL11.glDisable((int)32826);
        }
    }

    protected int func_77032_a(EntityLivingBase entity, int pass, float partialTickTime) {
        return this.renderEyes((IEndermanRenderer)entity, pass, partialTickTime);
    }

    protected void func_77029_c(EntityLivingBase entity, float partialTickTime) {
        this.renderEquippedItems((IEndermanRenderer)entity, partialTickTime);
        super.func_77029_c(entity, partialTickTime);
    }

    public void func_76986_a(EntityLivingBase entity, double x, double y, double z, float yaw, float partialTickTime) {
        this.renderEnderman((IEndermanRenderer)entity, x, y, z, yaw, partialTickTime);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return Baconizer.mobTexture((Render)this, texEndermanBody);
    }

    public void func_76986_a(EntityLiving entity, double x, double y, double z, float yaw, float partialTickTime) {
        this.renderEnderman((IEndermanRenderer)entity, x, y, z, yaw, partialTickTime);
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float yaw, float partialTickTime) {
        this.renderEnderman((IEndermanRenderer)entity, x, y, z, yaw, partialTickTime);
    }
}

