/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.client;

import java.io.PrintStream;
import java.util.function.Consumer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLDebugMessageCallback;
import org.lwjgl.opengl.GLDebugMessageCallbackI;
import org.lwjgl.system.APIUtil;

public class GLDebugLog {
    private static void printDetail(PrintStream stream, String type, String message) {
        stream.printf("  %s: %s\n", type, message);
    }

    private static void trace(Consumer<String> output) {
        StackTraceElement[] elems;
        for (StackTraceElement ste : elems = GLDebugLog.filterStackTrace(new Throwable(), 4).getStackTrace()) {
            output.accept(ste.toString());
        }
    }

    public static Throwable filterStackTrace(Throwable throwable, int offset) {
        StackTraceElement[] elems = throwable.getStackTrace();
        StackTraceElement[] filtered = new StackTraceElement[elems.length];
        int j = 0;
        for (int i = offset; i < elems.length; ++i) {
            String className = elems[i].getClassName();
            if (className == null) {
                className = "";
            }
            filtered[j++] = elems[i];
        }
        StackTraceElement[] newElems = new StackTraceElement[j];
        System.arraycopy(filtered, 0, newElems, 0, j);
        throwable.setStackTrace(newElems);
        return throwable;
    }

    private static void printTrace(final PrintStream stream) {
        GLDebugLog.trace(new Consumer<String>(){
            boolean first = true;

            @Override
            public void accept(String str) {
                if (this.first) {
                    GLDebugLog.printDetail(stream, "Stacktrace", str);
                    this.first = false;
                } else {
                    GLDebugLog.printDetailLine(stream, "Stacktrace", str);
                }
            }
        });
    }

    private static void printDetailLine(PrintStream stream, String type, String message) {
        stream.append("    ");
        for (int i = 0; i < type.length(); ++i) {
            stream.append(" ");
        }
        stream.append(message).append("\n");
    }

    private static String getDebugSource(int source) {
        String string;
        switch (source) {
            case 33350: {
                string = "API";
                break;
            }
            case 33351: {
                string = "WINDOW SYSTEM";
                break;
            }
            case 33352: {
                string = "SHADER COMPILER";
                break;
            }
            case 33353: {
                string = "THIRD PARTY";
                break;
            }
            case 33354: {
                string = "APPLICATION";
                break;
            }
            case 33355: {
                string = "OTHER";
                break;
            }
            default: {
                string = String.format("Unknown [0x%X]", source);
            }
        }
        return string;
    }

    private static String getDebugType(int type) {
        String string;
        switch (type) {
            case 33356: {
                string = "ERROR";
                break;
            }
            case 33357: {
                string = "DEPRECATED BEHAVIOR";
                break;
            }
            case 33358: {
                string = "UNDEFINED BEHAVIOR";
                break;
            }
            case 33359: {
                string = "PORTABILITY";
                break;
            }
            case 33360: {
                string = "PERFORMANCE";
                break;
            }
            case 33361: {
                string = "OTHER";
                break;
            }
            case 33384: {
                string = "MARKER";
                break;
            }
            default: {
                string = String.format("Unknown [0x%X]", type);
            }
        }
        return string;
    }

    private static String getDebugSeverity(int severity) {
        String string;
        switch (severity) {
            case 33387: {
                string = "NOTIFICATION";
                break;
            }
            case 37190: {
                string = "HIGH";
                break;
            }
            case 37191: {
                string = "MEDIUM";
                break;
            }
            case 37192: {
                string = "LOW";
                break;
            }
            default: {
                string = String.format("Unknown [0x%X]", severity);
            }
        }
        return string;
    }

    public static void setupDebugMessageCallback() {
        GLCapabilities caps = GL.getCapabilities();
        PrintStream stream = APIUtil.DEBUG_STREAM;
        if (caps.OpenGL43) {
            APIUtil.apiLog((CharSequence)"[GL] Using OpenGL 4.3 for error logging.");
            GLDebugMessageCallback proc = GLDebugMessageCallback.create((source, type, id, severity, length, message, userParam) -> {
                if (severity == 33387) {
                    return;
                }
                String level = severity == 37192 ? "info " : (severity == 37191 ? "warn " : "error");
                stream.println("[" + level + "] OpenGL debug message");
                GLDebugLog.printDetail(stream, "ID", String.format("0x%X", id));
                GLDebugLog.printDetail(stream, "Source", GLDebugLog.getDebugSource(source));
                GLDebugLog.printDetail(stream, "Type", GLDebugLog.getDebugType(type));
                GLDebugLog.printDetail(stream, "Severity", GLDebugLog.getDebugSeverity(severity));
                GLDebugLog.printDetail(stream, "Message", GLDebugMessageCallback.getMessage((int)length, (long)message));
                GLDebugLog.printTrace(stream);
            });
            GL43.glDebugMessageCallback((GLDebugMessageCallbackI)proc, (long)0L);
            if ((GL11.glGetInteger((int)33310) & 2) == 0) {
                APIUtil.apiLog((CharSequence)"[GL] Warning: A non-debug context may not produce any debug output.");
                GL11.glEnable((int)37600);
            }
            GL11.glEnable((int)33346);
        }
    }
}

