/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.theme.spec;

import com.github.weisj.darklaf.theme.spec.AccentColorRule;
import com.github.weisj.darklaf.theme.spec.ColorToneRule;
import com.github.weisj.darklaf.theme.spec.ContrastRule;
import com.github.weisj.darklaf.theme.spec.FontSizeRule;
import java.util.Objects;

public class PreferredThemeStyle {
    private final ContrastRule contrastRule;
    private final ColorToneRule colorToneRule;
    private final FontSizeRule fontSizeRule;
    private final AccentColorRule accentColorRule;

    public PreferredThemeStyle() {
        this(ContrastRule.STANDARD, ColorToneRule.LIGHT);
    }

    public PreferredThemeStyle(ContrastRule contrastRule, ColorToneRule colorToneRule) {
        if (contrastRule == null) {
            throw new IllegalArgumentException("null is not a valid contrast rule");
        }
        if (colorToneRule == null) {
            throw new IllegalArgumentException("null is not a valid style rule");
        }
        this.contrastRule = contrastRule;
        this.colorToneRule = colorToneRule;
        this.fontSizeRule = FontSizeRule.getDefault();
        this.accentColorRule = AccentColorRule.getDefault();
    }

    public PreferredThemeStyle(ContrastRule contrastRule, ColorToneRule colorToneRule, AccentColorRule accentColorRule) {
        if (contrastRule == null) {
            throw new IllegalArgumentException("null is not a valid contrast rule");
        }
        if (colorToneRule == null) {
            throw new IllegalArgumentException("null is not a valid style rule");
        }
        if (accentColorRule == null) {
            throw new IllegalArgumentException("null is not a valid accent color rule");
        }
        this.contrastRule = contrastRule;
        this.colorToneRule = colorToneRule;
        this.fontSizeRule = FontSizeRule.getDefault();
        this.accentColorRule = accentColorRule;
    }

    public PreferredThemeStyle(ContrastRule contrastRule, ColorToneRule colorToneRule, FontSizeRule fontSizeRule) {
        if (contrastRule == null) {
            throw new IllegalArgumentException("null is not a valid contrast rule");
        }
        if (colorToneRule == null) {
            throw new IllegalArgumentException("null is not a valid style rule");
        }
        if (fontSizeRule == null) {
            throw new IllegalArgumentException("null is not a valid font size rule");
        }
        this.contrastRule = contrastRule;
        this.colorToneRule = colorToneRule;
        this.fontSizeRule = fontSizeRule;
        this.accentColorRule = AccentColorRule.getDefault();
    }

    public PreferredThemeStyle(ContrastRule contrastRule, ColorToneRule colorToneRule, AccentColorRule accentColorRule, FontSizeRule fontSizeRule) {
        if (contrastRule == null) {
            throw new IllegalArgumentException("null is not a valid contrast rule");
        }
        if (colorToneRule == null) {
            throw new IllegalArgumentException("null is not a valid style rule");
        }
        if (fontSizeRule == null) {
            throw new IllegalArgumentException("null is not a valid font size rule");
        }
        if (accentColorRule == null) {
            throw new IllegalArgumentException("null is not a valid accent color rule");
        }
        this.contrastRule = contrastRule;
        this.colorToneRule = colorToneRule;
        this.fontSizeRule = fontSizeRule;
        this.accentColorRule = accentColorRule;
    }

    public ContrastRule getContrastRule() {
        return this.contrastRule;
    }

    public ColorToneRule getColorToneRule() {
        return this.colorToneRule;
    }

    public FontSizeRule getFontSizeRule() {
        return this.fontSizeRule;
    }

    public AccentColorRule getAccentColorRule() {
        return this.accentColorRule;
    }

    public String toString() {
        return "PreferredThemeStyle{contrastRule=" + (Object)((Object)this.contrastRule) + ", colorToneRule=" + (Object)((Object)this.colorToneRule) + ", accentColorRule=" + this.accentColorRule + ", fontSizeRule=" + this.fontSizeRule + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PreferredThemeStyle)) {
            return false;
        }
        PreferredThemeStyle that = (PreferredThemeStyle)o;
        return this.contrastRule == that.contrastRule && this.colorToneRule == that.colorToneRule && Objects.equals(this.fontSizeRule, that.fontSizeRule) && Objects.equals(this.accentColorRule, that.accentColorRule);
    }

    public int hashCode() {
        int result = this.contrastRule != null ? this.contrastRule.hashCode() : 0;
        result = 31 * result + (this.colorToneRule != null ? this.colorToneRule.hashCode() : 0);
        result = 31 * result + (this.fontSizeRule != null ? this.fontSizeRule.hashCode() : 0);
        result = 31 * result + (this.accentColorRule != null ? this.accentColorRule.hashCode() : 0);
        return result;
    }
}

