/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.theme;

import com.github.weisj.darklaf.properties.PropertyLoader;
import com.github.weisj.darklaf.properties.icons.IconResolver;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.theme.info.PresetIconRule;
import com.github.weisj.darklaf.theme.spec.ColorToneRule;
import com.github.weisj.darklaf.theme.spec.ContrastRule;
import com.google.auto.service.AutoService;
import java.util.Properties;
import javax.swing.UIDefaults;

@AutoService(value={Theme.class})
public class HighContrastDarkTheme
extends Theme {
    @Override
    protected PresetIconRule getPresetIconRule() {
        return PresetIconRule.DARK;
    }

    @Override
    public String getPrefix() {
        return "high_contrast_dark";
    }

    @Override
    protected String getResourcePath() {
        return "high_contrast_dark/";
    }

    @Override
    public String getName() {
        return "High Contrast Dark";
    }

    @Override
    protected Class<? extends Theme> getLoaderClass() {
        return HighContrastDarkTheme.class;
    }

    @Override
    public ColorToneRule getColorToneRule() {
        return ColorToneRule.DARK;
    }

    @Override
    public ContrastRule getContrastRule() {
        return ContrastRule.HIGH_CONTRAST;
    }

    @Override
    public void loadIconTheme(Properties properties, UIDefaults currentDefaults, IconResolver iconResolver) {
        super.loadIconTheme(properties, currentDefaults, iconResolver);
        PropertyLoader.putProperties(this.loadPropertyFile("icons"), properties, currentDefaults, iconResolver);
    }

    @Override
    public void customizeUIProperties(Properties properties, UIDefaults currentDefaults, IconResolver iconResolver) {
        super.customizeUIProperties(properties, currentDefaults, iconResolver);
        this.loadCustomProperties("ui", properties, currentDefaults, iconResolver);
    }

    @Override
    public void customizePlatformProperties(Properties properties, UIDefaults currentDefaults, IconResolver iconResolver) {
        super.customizePlatformProperties(properties, currentDefaults, iconResolver);
        this.loadCustomProperties("platform", properties, currentDefaults, iconResolver);
    }
}

