/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.tcneiadditions.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.recipe.GuiRecipe;
import java.awt.Rectangle;
import java.util.List;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import ru.timeconqueror.tcneiadditions.util.GuiRecipeHelper;
import ru.timeconqueror.tcneiadditions.util.TCUtil;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchCategoryList;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.client.lib.UtilsFX;

public class ResearchInfo {
    private final boolean isResearched;
    private final String category;
    private final String research;
    private final ResearchItem researchItem;
    private final ResourceLocation icon;
    private int prevX;
    private int prevY;

    public ResearchInfo(ResearchItem researchItem, boolean isResearched) {
        this.researchItem = researchItem;
        if (researchItem != null) {
            this.category = ResearchCategories.getCategoryName((String)researchItem.category);
            ResearchCategoryList list = ResearchCategories.getResearchList((String)researchItem.category);
            this.icon = list != null && list.icon != null ? list.icon : null;
            this.research = researchItem.getName();
        } else {
            this.category = null;
            this.icon = null;
            this.research = "N/A";
        }
        this.isResearched = isResearched;
    }

    public void onHover(List<String> list) {
        list.add(String.format("%s%s%s : %s", EnumChatFormatting.UNDERLINE, this.isResearched ? EnumChatFormatting.GREEN : EnumChatFormatting.RED, this.category != null ? this.category : "N/A", this.research));
        try {
            TCUtil.getResearchPrerequisites(list, this.researchItem);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (list.size() > 1) {
            list.add(1, "");
        }
    }

    public void onDraw(int x, int y) {
        this.prevX = x;
        this.prevY = y;
        GL11.glPushMatrix();
        if (this.icon != null) {
            UtilsFX.bindTexture((ResourceLocation)this.icon);
        } else {
            UtilsFX.bindTexture((String)"textures/items/thaumonomicon.png");
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslated((double)x, (double)y, (double)0.0);
        GL11.glScaled((double)0.8, (double)0.8, (double)0.0);
        UtilsFX.drawTexturedQuadFull((int)0, (int)0, (double)0.0);
        if (!this.isResearched) {
            GL11.glTranslated((double)20.0, (double)1.0, (double)0.0);
            GL11.glScaled((double)1.9, (double)1.9, (double)0.0);
            GuiDraw.drawString((String)"X", (int)0, (int)0, (int)0xAB0000, (boolean)false);
        }
        GL11.glPopMatrix();
    }

    public Rectangle getRect(GuiRecipe<?> gui, int recipeIndex) {
        return new Rectangle(GuiRecipeHelper.getGuiLeft(gui) + this.prevX + 5, GuiRecipeHelper.getGuiTop(gui) + this.prevY + 31, 24, 13);
    }
}

