/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.worlddata;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class MeteorDataNameEncoder {
    private static final char DATA_SEPARATOR = '_';
    private static final char BASE_EXTENSION_SEPARATOR = '.';
    private static final String FILE_EXTENSION = "dat";
    private final char dataSeparator;
    @Nonnull
    private final String fileExtension;
    private final char baseExtSeparator;
    private final int bitScale;

    public MeteorDataNameEncoder(int bitScale) {
        this('_', '.', FILE_EXTENSION, bitScale);
    }

    private MeteorDataNameEncoder(char dataSeparator, char baseExtSeparator, @Nonnull String fileExtension, int bitScale) {
        Preconditions.checkNotNull((Object)fileExtension);
        Preconditions.checkArgument((!fileExtension.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((bitScale >= 0 ? 1 : 0) != 0);
        this.dataSeparator = dataSeparator;
        this.baseExtSeparator = baseExtSeparator;
        this.fileExtension = fileExtension;
        this.bitScale = bitScale;
    }

    public String encode(int dimension, int chunkX, int chunkZ) {
        int shiftedX = chunkX >> this.bitScale;
        int shiftedZ = chunkZ >> this.bitScale;
        return String.format("%d%c%d%c%d%c%s", dimension, Character.valueOf(this.dataSeparator), shiftedX, Character.valueOf(this.dataSeparator), shiftedZ, Character.valueOf(this.baseExtSeparator), this.fileExtension);
    }
}

