/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.summoning.meteor;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.common.summoning.meteor.MeteorComponent;
import WayofTime.alchemicalWizardry.common.summoning.meteor.MeteorComponentAdapter;
import WayofTime.alchemicalWizardry.common.summoning.meteor.MeteorReagent;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MeteorReagentRegistry {
    public static Map<Reagent, MeteorReagent> reagents = new HashMap<Reagent, MeteorReagent>();

    public static void loadConfig() {
        Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(MeteorComponent.class, (Object)new MeteorComponentAdapter()).create();
        File file = new File("config/BloodMagic/meteors/reagents/");
        File[] files = file.listFiles();
        if (files != null) {
            for (String reagent : ReagentRegistry.reagentList.keySet()) {
                try {
                    BufferedReader br;
                    MeteorReagent r;
                    File f = new File("config/BloodMagic/meteors/reagents/" + reagent + ".json");
                    if (!f.isFile() || (r = (MeteorReagent)gson.fromJson((Reader)(br = new BufferedReader(new FileReader(f))), MeteorReagent.class)) == null) continue;
                    reagents.put(ReagentRegistry.getReagentForKey(reagent), r);
                }
                catch (JsonSyntaxException | FileNotFoundException e) {
                    AlchemicalWizardry.logger.warn("Error adding reagent {}", new Object[]{reagent});
                    e.printStackTrace();
                }
            }
        }
    }

    public static int getLargestRadiusIncrease(List<Reagent> reagentList) {
        int increase = 0;
        for (Reagent r : reagentList) {
            int change;
            if (!reagents.containsKey(r) || (change = MeteorReagentRegistry.reagents.get((Object)r).radiusChange) <= increase) continue;
            increase = change;
        }
        return increase;
    }

    public static int getLargestRadiusDecrease(List<Reagent> reagentList) {
        int decrease = 0;
        for (Reagent r : reagentList) {
            int change;
            if (!reagents.containsKey(r) || (change = MeteorReagentRegistry.reagents.get((Object)r).radiusChange) >= decrease) continue;
            decrease = change;
        }
        return decrease;
    }

    public static int getLargestFillerChanceIncrease(List<Reagent> reagentList) {
        int increase = 0;
        for (Reagent r : reagentList) {
            int change;
            if (!reagents.containsKey(r) || (change = MeteorReagentRegistry.reagents.get((Object)r).fillerChanceChange) <= increase) continue;
            increase = change;
        }
        return increase;
    }

    public static int getLargestFillerChanceDecrease(List<Reagent> reagentList) {
        int decrease = 0;
        for (Reagent r : reagentList) {
            int change;
            if (!reagents.containsKey(r) || (change = MeteorReagentRegistry.reagents.get((Object)r).fillerChanceChange) >= decrease) continue;
            decrease = change;
        }
        return decrease;
    }

    public static float getLargestRawFillerChanceIncrease(List<Reagent> reagentList) {
        float increase = 0.0f;
        for (Reagent r : reagentList) {
            float change;
            if (!reagents.containsKey(r) || !((change = MeteorReagentRegistry.reagents.get((Object)r).rawFillerChanceChange) > increase)) continue;
            increase = change;
        }
        return increase;
    }

    public static float getLargestRawFillerChanceDecrease(List<Reagent> reagentList) {
        float decrease = 0.0f;
        for (Reagent r : reagentList) {
            float change;
            if (!reagents.containsKey(r) || !((change = MeteorReagentRegistry.reagents.get((Object)r).rawFillerChanceChange) < decrease)) continue;
            decrease = change;
        }
        return decrease;
    }

    public static List<MeteorComponent> getFillerList(List<Reagent> reagentList) {
        ArrayList<MeteorComponent> fillerList = new ArrayList<MeteorComponent>();
        for (Reagent r : reagentList) {
            List<MeteorComponent> filler;
            if (!reagents.containsKey(r) || (filler = MeteorReagentRegistry.reagents.get((Object)r).filler) == null || filler.isEmpty()) continue;
            fillerList.addAll(filler);
        }
        return fillerList;
    }

    public static boolean doExplosions(List<Reagent> reagentList) {
        for (Reagent r : reagentList) {
            if (!reagents.containsKey(r) || !MeteorReagentRegistry.reagents.get((Object)r).disableExplosions) continue;
            return false;
        }
        return true;
    }

    public static boolean doMeteorsDestroyBlocks(List<Reagent> reagentList) {
        for (Reagent r : reagentList) {
            if (!reagents.containsKey(r) || !MeteorReagentRegistry.reagents.get((Object)r).invertExplosionBlockDamage) continue;
            return !AlchemicalWizardry.doMeteorsDestroyBlocks;
        }
        return AlchemicalWizardry.doMeteorsDestroyBlocks;
    }
}

