/*
 * Decompiled with CFR 0.152.
 */
package net.glease.healer;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.core.lookup.Interpolator;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.spi.LoggerContextFactory;

@IFMLLoadingPlugin.Name(value="healer")
@IFMLLoadingPlugin.TransformerExclusions(value={"net.glease.healer"})
@IFMLLoadingPlugin.SortingIndex(value=1001)
@IFMLLoadingPlugin.Name(value="healer")
@IFMLLoadingPlugin.TransformerExclusions(value={"net.glease.healer"})
@IFMLLoadingPlugin.SortingIndex(value=1001)
public class Healer
implements IFMLLoadingPlugin,
net.minecraftforge.fml.relauncher.IFMLLoadingPlugin {
    public static final String MOD_ID = "healer";
    public static final String MOD_PACKAGE = "net.glease.healer";
    static final Set<org.apache.logging.log4j.spi.LoggerContext> known;
    static final Field fieldLookup;
    private static final Map<String, PatchStage> patchStages;
    static PrintWriter log;
    private PatchStage selectedPatchStage = PatchStage.PRELOAD;
    private boolean replaced = false;

    private static RuntimeException panic(ReflectiveOperationException e) {
        throw new RuntimeException("Remove healer, either you already patched stuff yourself or you are not running a supported instance of minecraft!", e);
    }

    static Map<String, StrLookup> getLookup(Interpolator o) {
        try {
            return (Map)fieldLookup.get(o);
        }
        catch (IllegalAccessException e) {
            throw Healer.panic(e);
        }
    }

    private static List<String> getTweakClasses() {
        return (List)Launch.blackboard.get("TweakClasses");
    }

    static void log(String message) {
        log.printf("%tc %s%n", System.currentTimeMillis(), message);
    }

    static void processCoreContext(LoggerContext ctx) {
        Healer.log("Processing context: " + ctx.getName() + "@" + System.identityHashCode(ctx));
        StrLookup lookup = ctx.getConfiguration().getStrSubstitutor().getVariableResolver();
        if (lookup instanceof Interpolator) {
            Interpolator interpolator = (Interpolator)lookup;
            Healer.getLookup(interpolator).remove("jndi");
        } else {
            Healer.log("Unknown variable resolver: " + lookup.getClass().getName() + ": " + lookup + "@" + System.identityHashCode(lookup));
        }
    }

    @Override
    public String[] getASMTransformerClass() {
        return new String[0];
    }

    @Override
    public String getModContainerClass() {
        return null;
    }

    @Override
    public String getSetupClass() {
        return null;
    }

    @Override
    public void injectData(Map<String, Object> data) {
        if (Healer.getTweakClasses().contains("com.forgeessentials.core.preloader.FELaunchHandler")) {
            Healer.log("ForgeEssentials detected. Setting default PatchStage to POSTINIT");
            this.selectedPatchStage = PatchStage.POSTINIT;
        }
        try {
            this.selectedPatchStage = PatchStage.valueOf(System.getProperty("net.glease.healer.patch_stage", this.selectedPatchStage.name().toUpperCase(Locale.ROOT)));
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Unsupported PatchStage selected.", e);
        }
        Healer.log("PatchStage selected: " + (Object)((Object)this.selectedPatchStage));
        if (this.selectedPatchStage == PatchStage.PRELOAD) {
            this.patchLog4j(true);
        } else {
            this.patchLog4j(false);
            Thread injector = new Thread("Healer Callhook Injector"){

                @Override
                public void run() {
                    while (true) {
                        try {
                            Object loadController;
                            Class<?> loaderClass;
                            Object loader;
                            do {
                                Thread.sleep(10L);
                                try {
                                    loaderClass = Class.forName("cpw.mods.fml.common.Loader");
                                }
                                catch (ClassNotFoundException e) {
                                    loaderClass = Class.forName("net.minecraftforge.fml.common.Loader");
                                }
                            } while ((loader = MethodUtils.invokeExactStaticMethod(loaderClass, (String)"instance", (Object[])new Object[0])) == null || (loadController = FieldUtils.readDeclaredField((Object)loader, (String)"modController", (boolean)true)) == null);
                            ((EventBus)FieldUtils.readDeclaredField((Object)loadController, (String)"masterChannel", (boolean)true)).register((Object)Healer.this);
                        }
                        catch (ReflectiveOperationException e) {
                            throw new RuntimeException("Forge version unrecognized", e);
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                    Healer.log("Callhook injected");
                }
            };
            injector.setDaemon(true);
            injector.start();
        }
    }

    @Subscribe
    public void onEvent(Object e) {
        PatchStage stage = patchStages.get(e.getClass().getSimpleName());
        if (stage == null || this.replaced || stage.compareTo(this.selectedPatchStage) < 0) {
            Healer.log("Ignored " + e);
            return;
        }
        Healer.log("Patching at event " + e);
        this.patchLog4j(true);
    }

    void patchLog4j(boolean doReplace) {
        try {
            for (LoggerContext ctx : ((Log4jContextFactory)LogManager.getFactory()).getSelector().getLoggerContexts()) {
                if (!known.add((org.apache.logging.log4j.spi.LoggerContext)ctx)) {
                    Healer.log("Ignoring known context " + ctx.getName() + "@" + System.identityHashCode(ctx));
                    continue;
                }
                Healer.processCoreContext(ctx);
            }
            if (doReplace && !this.replaced) {
                Field factory = LogManager.class.getDeclaredField("factory");
                factory.setAccessible(true);
                factory.set(null, Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{LoggerContextFactory.class}, (InvocationHandler)new LoggerContextFactoryProxy(LogManager.getFactory())));
                Healer.log("Replaced factory");
                this.replaced = true;
            }
        }
        catch (ReflectiveOperationException e) {
            throw Healer.panic(e);
        }
    }

    @Override
    public String getAccessTransformerClass() {
        return null;
    }

    static {
        Field fieldLookup1;
        Class<?> clazz;
        known = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
        patchStages = new HashMap<String, PatchStage>();
        try {
            clazz = Class.forName("org.apache.logging.log4j.core.lookup.Interpolator");
        }
        catch (ReflectiveOperationException e) {
            throw Healer.panic(e);
        }
        try {
            fieldLookup1 = clazz.getDeclaredField("lookups");
            fieldLookup1.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            try {
                fieldLookup1 = clazz.getDeclaredField("strLookupMap");
                fieldLookup1.setAccessible(true);
            }
            catch (ReflectiveOperationException ex) {
                throw Healer.panic(ex);
            }
        }
        fieldLookup = fieldLookup1;
        try {
            log = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(".healer.log"), StandardCharsets.UTF_8), true);
        }
        catch (IOException e) {
            log = new PrintWriter((OutputStream)new NullOutputStream());
        }
    }

    private static class LoggerContextFactoryProxy
    implements InvocationHandler {
        private final LoggerContextFactory backing;

        public LoggerContextFactoryProxy(LoggerContextFactory backing) {
            this.backing = backing;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("getContext".equals(method.getName())) {
                LoggerContext casted;
                Object result = method.invoke((Object)this.backing, args);
                if (result instanceof LoggerContext && known.add((org.apache.logging.log4j.spi.LoggerContext)(casted = (LoggerContext)result))) {
                    Healer.log("Accepting new context post launch");
                    Healer.processCoreContext(casted);
                }
                return result;
            }
            if ("removeContext".equals(method.getName()) && args[0] instanceof LoggerContext) {
                known.remove(args[0]);
            }
            return method.invoke((Object)this.backing, args);
        }
    }

    private static enum PatchStage {
        PRELOAD,
        PREINIT("FMLPreInitializationEvent"),
        INIT("FMLInitializationEvent"),
        POSTINIT("FMLPostInitializationEvent");


        private PatchStage() {
        }

        private PatchStage(String fmlEventClassName) {
            patchStages.put(fmlEventClassName, this);
        }
    }
}

