/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.items.manipulator;

import com.gtnewhorizon.gtnhlib.client.renderer.TessellatorManager;
import com.gtnewhorizon.gtnhlib.client.renderer.quad.QuadView;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.DefaultVertexFormat;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexFormat;
import com.gtnewhorizon.gtnhlib.eventbus.EventBusSubscriber;
import com.recursive_pineapple.matter_manipulator.MMMod;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import lombok.Generated;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.util.glu.GLU;

@EventBusSubscriber(side={Side.CLIENT})
public class RenderHints {
    private static final int BYTES_PER_HINT = DefaultVertexFormat.POSITION_TEXTURE_COLOR.getVertexSize() * 4 * 6;
    private static final ArrayList<Hint> HINTS = new ArrayList(10000);
    private static final Vector3d LAST_PLAYER_POSITION = new Vector3d();
    private static final Vector3i LAST_RENDERED_PLAYER_POSITION = new Vector3i();
    private static boolean vboNeedsRebuild = false;
    private static VertexBuffer activeVBO;
    private static VertexBuffer pendingVBO;
    private static final ExecutorService WORKER_THREAD;
    private static Future<VBOResult> renderTask;
    private static boolean drawOnTop;

    public static void reset() {
        if (renderTask != null) {
            renderTask.cancel(true);
            renderTask = null;
        }
        HINTS.clear();
        vboNeedsRebuild = true;
    }

    public static void addHint(int x, int y, int z, Block block, int meta, short[] tint) {
        Hint hint = new Hint();
        hint.x = x;
        hint.y = y;
        hint.z = z;
        hint.icons = new IIcon[6];
        hint.tint = tint;
        for (int i = 0; i < 6; ++i) {
            hint.icons[i] = block.func_149691_a(i, meta);
        }
        HINTS.add(hint);
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load e) {
        if (e.world.field_72995_K) {
            RenderHints.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static VBOResult buildVBO(ByteBuffer buffer, ArrayList<Hint> hints, double xd, double yd, double zd, int xi, int yi, int zi) {
        try {
            Vector3d eyes = new Vector3d(xd, yd, zd);
            hints.sort(Comparator.comparingDouble(info -> -eyes.distanceSquared((double)info.x + 0.5, (double)info.y + 0.5, (double)info.z + 0.5)));
            TessellatorManager.startCapturing();
            Tessellator tes = TessellatorManager.get();
            tes.func_78371_b(7);
            int hintCount = hints.size();
            for (int i = 0; i < hintCount; ++i) {
                hints.get(i).draw(tes, xd, yd, zd, xi, yi, zi);
            }
            List quads = TessellatorManager.stopCapturingToPooledQuads();
            long expectedSize = (long)DefaultVertexFormat.POSITION_TEXTURE_COLOR.getVertexSize() * (long)quads.size() * 4L;
            buffer.rewind();
            if (expectedSize > (long)buffer.capacity()) {
                MMMod.LOG.error("Could not upload hint VBO: Could not insert hint quads into GL buffer (expectedSize={}, buffer.capacity={})", new Object[]{expectedSize, buffer.capacity()});
                VBOResult vBOResult = new VBOResult(new Vector3i(xi, yi, zi), 0);
                return vBOResult;
            }
            int quadsSize = quads.size();
            for (int i = 0; i < quadsSize; ++i) {
                DefaultVertexFormat.POSITION_TEXTURE_COLOR.writeQuad((QuadView)quads.get(i), buffer);
            }
            buffer.rewind();
            VBOResult vBOResult = new VBOResult(new Vector3i(xi, yi, zi), quads.size() * 4);
            return vBOResult;
        }
        finally {
            TessellatorManager.cleanup();
        }
    }

    @SubscribeEvent
    public static void onRenderWorldLast(RenderWorldLastEvent e) {
        if (HINTS.isEmpty()) {
            return;
        }
        Profiler p = Minecraft.func_71410_x().field_71424_I;
        p.func_76320_a("Render MM Hints");
        EntityLivingBase player = Minecraft.func_71410_x().field_71451_h;
        double xd = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)e.partialTicks;
        double yd = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)e.partialTicks;
        double zd = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)e.partialTicks;
        int xi = (int)xd;
        int yi = (int)yd;
        int zi = (int)zd;
        Vector3d currentPos = new Vector3d(xd, yd, zd);
        if (activeVBO == null) {
            activeVBO = new VertexBuffer(DefaultVertexFormat.POSITION_TEXTURE_COLOR, 7);
        }
        if (pendingVBO == null) {
            pendingVBO = new VertexBuffer(DefaultVertexFormat.POSITION_TEXTURE_COLOR, 7);
        }
        if (renderTask != null && renderTask.isDone()) {
            VBOResult result = null;
            try {
                result = renderTask.get();
            }
            catch (InterruptedException | ExecutionException ex) {
                MMMod.LOG.error("Could not cancel render hints", (Throwable)ex);
            }
            renderTask = null;
            pendingVBO.unmap();
            if (result != null) {
                LAST_RENDERED_PLAYER_POSITION.set((Vector3ic)result.playerPosition);
                pendingVBO.vertexCount = result.vertexCount;
                VertexBuffer temp = activeVBO;
                activeVBO = pendingVBO;
                pendingVBO = temp;
            }
        }
        if (renderTask == null && (vboNeedsRebuild || currentPos.distance((Vector3dc)LAST_PLAYER_POSITION) > 1.0)) {
            LAST_PLAYER_POSITION.set((Vector3dc)currentPos);
            vboNeedsRebuild = false;
            ArrayList<Hint> hints = new ArrayList<Hint>(HINTS);
            if (pendingVBO.mapped) {
                pendingVBO.unmap();
            }
            pendingVBO.ensureSize((long)hints.size() * (long)BYTES_PER_HINT, 35040);
            ByteBuffer buffer = pendingVBO.map(35001);
            if (buffer != null) {
                renderTask = WORKER_THREAD.submit(() -> RenderHints.buildVBO(buffer, hints, xd, yd, zd, xi, yi, zi));
            }
        }
        if (activeVBO.vertexCount > 0) {
            p.func_76320_a("Draw MM Hints");
            GL11.glPushMatrix();
            GL11.glPushAttrib((int)24576);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GL11.glTranslated((double)(-xd + (double)RenderHints.LAST_RENDERED_PLAYER_POSITION.x), (double)(-yd + (double)RenderHints.LAST_RENDERED_PLAYER_POSITION.y), (double)(-zd + (double)RenderHints.LAST_RENDERED_PLAYER_POSITION.z));
            GL11.glDisable((int)2884);
            GL11.glDisable((int)3008);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)771, (int)770);
            if (drawOnTop) {
                GL11.glDisable((int)2929);
            } else {
                GL11.glEnable((int)2929);
            }
            activeVBO.render();
            GL11.glPopAttrib();
            GL11.glPopMatrix();
            p.func_76319_b();
        }
        p.func_76319_b();
    }

    @Generated
    public static void setDrawOnTop(boolean drawOnTop) {
        RenderHints.drawOnTop = drawOnTop;
    }

    static {
        WORKER_THREAD = Executors.newFixedThreadPool(1);
        drawOnTop = false;
    }

    private static class Hint {
        public int x;
        public int y;
        public int z;
        public IIcon[] icons;
        public short[] tint;

        private Hint() {
        }

        public void draw(Tessellator tes, double eyeX, double eyeY, double eyeZ, int eyeXint, int eyeYint, int eyeZint) {
            double size = 0.5;
            WorldClient w = Minecraft.func_71410_x().field_71441_e;
            int brightness = w.func_72899_e(this.x, 0, this.z) ? w.func_72802_i(this.x, this.y, this.z, 0) : 0;
            tes.func_78380_c(brightness);
            tes.func_78370_a((int)this.tint[0], (int)this.tint[1], (int)this.tint[2], 150);
            double X = (double)(this.x - eyeXint) + 0.25;
            double Y = (double)(this.y - eyeYint) + 0.25;
            double Z = (double)(this.z - eyeZint) + 0.25;
            double worldX = (double)this.x + 0.25;
            double worldY = (double)this.y + 0.25;
            double worldZ = (double)this.z + 0.25;
            for (int j = 0; j < 2; ++j) {
                boolean unobstructedPass = j == 1;
                block9: for (int i = 0; i < 6; ++i) {
                    if (this.icons[i] == null) continue;
                    double u = this.icons[i].func_94209_e();
                    double U = this.icons[i].func_94212_f();
                    double v = this.icons[i].func_94206_g();
                    double V = this.icons[i].func_94210_h();
                    switch (i) {
                        case 0: {
                            if (worldY >= eyeY != unobstructedPass) continue block9;
                            tes.func_78375_b(0.0f, -1.0f, 0.0f);
                            tes.func_78374_a(X, Y, Z, u, v);
                            tes.func_78374_a(X + size, Y, Z, U, v);
                            tes.func_78374_a(X + size, Y, Z + size, U, V);
                            tes.func_78374_a(X, Y, Z + size, u, V);
                            continue block9;
                        }
                        case 1: {
                            if (worldY + size <= eyeY != unobstructedPass) continue block9;
                            tes.func_78375_b(0.0f, 1.0f, 0.0f);
                            tes.func_78374_a(X, Y + size, Z, u, v);
                            tes.func_78374_a(X, Y + size, Z + size, u, V);
                            tes.func_78374_a(X + size, Y + size, Z + size, U, V);
                            tes.func_78374_a(X + size, Y + size, Z, U, v);
                            continue block9;
                        }
                        case 2: {
                            if (worldZ >= eyeZ != unobstructedPass) continue block9;
                            tes.func_78375_b(0.0f, 0.0f, -1.0f);
                            tes.func_78374_a(X, Y, Z, U, V);
                            tes.func_78374_a(X, Y + size, Z, U, v);
                            tes.func_78374_a(X + size, Y + size, Z, u, v);
                            tes.func_78374_a(X + size, Y, Z, u, V);
                            continue block9;
                        }
                        case 3: {
                            if (worldZ + size <= eyeZ != unobstructedPass) continue block9;
                            tes.func_78375_b(0.0f, 0.0f, 1.0f);
                            tes.func_78374_a(X + size, Y, Z + size, U, V);
                            tes.func_78374_a(X + size, Y + size, Z + size, U, v);
                            tes.func_78374_a(X, Y + size, Z + size, u, v);
                            tes.func_78374_a(X, Y, Z + size, u, V);
                            continue block9;
                        }
                        case 4: {
                            if (worldX >= eyeX != unobstructedPass) continue block9;
                            tes.func_78375_b(-1.0f, 0.0f, 0.0f);
                            tes.func_78374_a(X, Y, Z + size, U, V);
                            tes.func_78374_a(X, Y + size, Z + size, U, v);
                            tes.func_78374_a(X, Y + size, Z, u, v);
                            tes.func_78374_a(X, Y, Z, u, V);
                            continue block9;
                        }
                        case 5: {
                            if (worldX + size <= eyeX != unobstructedPass) continue block9;
                            tes.func_78375_b(1.0f, 0.0f, 0.0f);
                            tes.func_78374_a(X + size, Y, Z, U, V);
                            tes.func_78374_a(X + size, Y + size, Z, U, v);
                            tes.func_78374_a(X + size, Y + size, Z + size, u, v);
                            tes.func_78374_a(X + size, Y, Z + size, u, V);
                        }
                    }
                }
            }
        }
    }

    private static class VBOResult {
        public Vector3i playerPosition;
        public int vertexCount;

        public VBOResult(Vector3i playerPosition, int vertexCount) {
            this.playerPosition = playerPosition;
            this.vertexCount = vertexCount;
        }
    }

    private static class VertexBuffer
    implements AutoCloseable {
        private int id = GL15.glGenBuffers();
        private volatile int vertexCount;
        private VertexFormat format;
        private int drawMode;
        private volatile long currentSize;
        private volatile int currentUsage;
        private volatile ByteBuffer oldMap;
        private volatile boolean mapped;

        public VertexBuffer() {
        }

        public VertexBuffer(VertexFormat format, int drawMode) {
            this();
            this.format = format;
            this.drawMode = drawMode;
        }

        public void bind() {
            GL15.glBindBuffer((int)34962, (int)this.id);
        }

        public void unbind() {
            GL15.glBindBuffer((int)34962, (int)0);
        }

        public void upload(int usage, ByteBuffer buffer, int vertexCount) {
            if (this.id != -1) {
                this.vertexCount = vertexCount;
                this.bind();
                GL15.glBufferData((int)34962, (ByteBuffer)buffer, (int)usage);
                this.unbind();
            }
        }

        public void upload(ByteBuffer buffer) {
            if (this.format == null) {
                throw new IllegalStateException("No format specified for VBO upload");
            }
            this.upload(35044, buffer, buffer.remaining() / this.format.getVertexSize());
        }

        @Override
        public void close() {
            if (this.id >= 0) {
                GL15.glDeleteBuffers((int)this.id);
                this.id = -1;
            }
        }

        public void draw(FloatBuffer floatBuffer) {
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GL11.glMultMatrix((FloatBuffer)floatBuffer);
            this.draw();
            GL11.glPopMatrix();
        }

        public void draw() {
            GL11.glDrawArrays((int)this.drawMode, (int)0, (int)this.vertexCount);
        }

        public void setupState() {
            if (this.format == null) {
                throw new IllegalStateException("No format specified for VBO setup");
            }
            this.bind();
            this.format.setupBufferState(0L);
        }

        public void cleanupState() {
            this.format.clearBufferState();
            this.unbind();
        }

        public void render() {
            this.setupState();
            this.draw();
            this.cleanupState();
        }

        public void ensureSize(long size, int usage) {
            if (size > this.currentSize || this.currentSize / 4L > size || this.currentUsage != usage) {
                this.bind();
                GL15.glBufferData((int)34962, (long)size, (int)usage);
                this.currentSize = size;
                this.currentUsage = usage;
                this.unbind();
            }
        }

        public ByteBuffer map(int access) {
            if (this.mapped) {
                throw new IllegalStateException("cannot map the same buffer twice");
            }
            if (this.currentSize == 0L) {
                throw new IllegalStateException("cannot map an empty buffer");
            }
            this.bind();
            GL11.glGetError();
            this.oldMap = GL15.glMapBuffer((int)34962, (int)access, (long)this.currentSize, (ByteBuffer)this.oldMap);
            if (this.oldMap == null) {
                MMMod.LOG.error("Error mapping buffer: {}", new Object[]{GLU.gluErrorString((int)GL11.glGetError())});
            } else {
                this.mapped = true;
            }
            this.unbind();
            return this.oldMap;
        }

        public void unmap() {
            if (!this.mapped) {
                throw new IllegalStateException("cannot unmap the same buffer twice");
            }
            this.bind();
            GL11.glGetError();
            GL15.glUnmapBuffer((int)34962);
            int error = GL11.glGetError();
            if (error != 0) {
                MMMod.LOG.error("Error unmapping buffer: {}", new Object[]{GLU.gluErrorString((int)error)});
            }
            this.mapped = false;
            this.unbind();
        }
    }
}

