/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.building;

import com.gtnewhorizon.gtnhlib.util.CoordinatePacker;
import com.recursive_pineapple.matter_manipulator.MMMod;
import com.recursive_pineapple.matter_manipulator.asm.Optional;
import com.recursive_pineapple.matter_manipulator.common.building.AbstractBuildable;
import com.recursive_pineapple.matter_manipulator.common.building.BlockAnalyzer;
import com.recursive_pineapple.matter_manipulator.common.building.BlockSpec;
import com.recursive_pineapple.matter_manipulator.common.building.ImmutableBlockSpec;
import com.recursive_pineapple.matter_manipulator.common.building.InteropConstants;
import com.recursive_pineapple.matter_manipulator.common.building.PendingBlock;
import com.recursive_pineapple.matter_manipulator.common.building.ProxiedWorld;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.ItemMatterManipulator;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.MMState;
import com.recursive_pineapple.matter_manipulator.common.networking.Messages;
import com.recursive_pineapple.matter_manipulator.common.networking.SoundResource;
import com.recursive_pineapple.matter_manipulator.common.utils.BigFluidStack;
import com.recursive_pineapple.matter_manipulator.common.utils.BigItemStack;
import com.recursive_pineapple.matter_manipulator.common.utils.MMUtils;
import com.recursive_pineapple.matter_manipulator.common.utils.Mods;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.booleans.BooleanObjectImmutablePair;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PendingBuild
extends AbstractBuildable {
    private final Deque<PendingBlock> pendingBlocks;
    private final HashSet<Long> visited = new HashSet();
    private final LongList errors = new LongArrayList();
    private final LongList warnings = new LongArrayList();

    public PendingBuild(EntityPlayer player, MMState state, ItemMatterManipulator.ManipulatorTier tier, List<PendingBlock> pendingBlocks) {
        super(player, state, tier);
        this.pendingBlocks = new ArrayDeque<PendingBlock>(pendingBlocks);
    }

    @Override
    public void tryPlaceBlocks(ItemStack stack, EntityPlayer player) {
        PendingBlock pending;
        int i;
        long coord;
        this.resetWarnings();
        this.refillPower(stack);
        ArrayList<PendingBlock> toPlace = new ArrayList<PendingBlock>(this.tier.placeSpeed);
        Integer lastChunkX = null;
        Integer lastChunkZ = null;
        int shuffleCount = 0;
        World world = player.field_70170_p;
        ProxiedWorld proxiedWorld = new ProxiedWorld(world);
        PendingBuildApplyContext applyContext = new PendingBuildApplyContext(stack);
        BlockSpec pooled = new BlockSpec();
        while (toPlace.size() < this.tier.placeSpeed && !this.pendingBlocks.isEmpty()) {
            PendingBlock next = this.pendingBlocks.getFirst();
            int x = next.x;
            int y = next.y;
            int z = next.z;
            int chunkX = x >> 4;
            int chunkZ = z >> 4;
            if (!Objects.equals(chunkX, lastChunkX) || !Objects.equals(chunkZ, lastChunkZ)) {
                if (!world.func_72863_F().func_73149_a(chunkX, chunkZ)) {
                    this.pendingBlocks.removeFirst();
                    continue;
                }
                lastChunkX = chunkX;
                lastChunkZ = chunkZ;
            }
            if (y < 0 || y > 255) {
                this.pendingBlocks.removeFirst();
                continue;
            }
            if (!this.isEditable(world, x, y, z)) {
                this.pendingBlocks.removeFirst();
                continue;
            }
            if (!toPlace.isEmpty() && !next.spec.isEquivalent(((PendingBlock)toPlace.get((int)0)).spec)) break;
            PendingBlock existing = PendingBlock.fromBlock(world, x, y, z);
            if (next.spec.isAir() && existing.getBlock().isAir((IBlockAccess)world, x, y, z)) {
                this.pendingBlocks.removeFirst();
                continue;
            }
            existing.analyze(world.func_147438_o(x, y, z), PendingBlock.ANALYZE_ARCH);
            if (PendingBlock.areEquivalent(existing, next)) {
                PendingBlock block = this.pendingBlocks.removeFirst();
                if (!this.supportsConfiguring()) continue;
                applyContext.pendingBlock = block;
                block.apply(applyContext, world);
                this.playSound(world, x, y, z, SoundResource.MOB_ENDERMEN_PORTAL);
                continue;
            }
            switch (this.state.config.removeMode) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case NONE: {
                    boolean bl = existing.getBlock().isAir((IBlockAccess)world, x, y, z);
                    break;
                }
                case REPLACEABLE: {
                    boolean bl = existing.getBlock().isReplaceable((IBlockAccess)world, x, y, z);
                    break;
                }
                case ALL: {
                    boolean canPlace;
                    boolean bl = canPlace = true;
                }
            }
            if (!(canPlace &= existing.getBlock().func_149712_f(world, x, y, z) >= 0.0f)) {
                this.pendingBlocks.addLast(this.pendingBlocks.removeFirst());
                if (++shuffleCount <= this.pendingBlocks.size()) continue;
                break;
            }
            if (!existing.getBlock().isAir((IBlockAccess)world, x, y, z)) {
                if (!this.state.hasCap(ItemMatterManipulator.ALLOW_REMOVING)) {
                    this.pendingBlocks.removeFirst();
                    continue;
                }
                if (!this.tryConsumePower(stack, world, x, y, z, existing.spec)) {
                    MMUtils.sendErrorToPlayer(player, StatCollector.func_74838_a((String)"mm.info.error.out_of_eu"));
                    break;
                }
            }
            proxiedWorld.airX = x;
            proxiedWorld.airY = y;
            proxiedWorld.airZ = z;
            if (!next.getBlock().func_149742_c((World)proxiedWorld, next.x, next.y, next.z)) {
                this.pendingBlocks.addLast(this.pendingBlocks.removeFirst());
                if (++shuffleCount <= this.pendingBlocks.size()) continue;
                break;
            }
            if (!this.tryConsumePower(stack, world, x, y, z, next.spec)) {
                MMUtils.sendErrorToPlayer(player, StatCollector.func_74838_a((String)"mm.info.error.out_of_eu"));
                break;
            }
            coord = CoordinatePacker.pack((int)x, (int)y, (int)z);
            if (!this.visited.add(coord)) {
                MMMod.LOG.warn("Tried to place block twice! " + next);
                this.pendingBlocks.removeFirst();
                continue;
            }
            toPlace.add(this.pendingBlocks.removeFirst());
        }
        if (toPlace.isEmpty()) {
            if (!this.pendingBlocks.isEmpty()) {
                MMUtils.sendErrorToPlayer(player, StatCollector.func_74837_a((String)"mm.info.error.could_not_place", (Object[])new Object[]{this.pendingBlocks.size()}));
            } else {
                MMUtils.sendInfoToPlayer(player, StatCollector.func_74838_a((String)"mm.info.finished_placing"));
            }
            this.actuallyGivePlayerStuff();
            this.playSounds();
            return;
        }
        PendingBlock first = (PendingBlock)toPlace.get(0);
        ItemStack perBlock = first.getStack();
        long total = 0L;
        BigItemStack extracted = null;
        if (!first.isFree()) {
            total = (long)toPlace.size() * (long)perBlock.field_77994_a;
            List extractedStacks = (List)this.tryConsumeItems(Arrays.asList(BigItemStack.create(perBlock).setStackSize(total)), 4).right();
            BigItemStack bigItemStack = extracted = extractedStacks.isEmpty() ? null : (BigItemStack)extractedStacks.get(0);
            if (extracted == null) {
                MMUtils.sendWarningToPlayer(player, StatCollector.func_74837_a((String)"mm.info.warning.could_not_find", (Object[])new Object[]{toPlace.size()}));
                MMUtils.sendWarningToPlayer(player, String.format("  %s x %d", first.getDisplayName(), total));
                for (PendingBlock pending2 : toPlace) {
                    this.pendingBlocks.add(pending2);
                    coord = CoordinatePacker.pack((int)pending2.x, (int)pending2.y, (int)pending2.z);
                    this.visited.remove(coord);
                }
                toPlace.clear();
            }
        }
        for (i = 0; i < toPlace.size(); ++i) {
            pending = (PendingBlock)toPlace.get(i);
            int x = pending.x;
            int y = pending.y;
            int z = pending.z;
            this.playSound(world, x, y, z, SoundResource.MOB_ENDERMEN_PORTAL);
            int metadata = pending.spec.getBlockMeta();
            BlockSpec existing = BlockSpec.fromBlock(pooled, world, x, y, z);
            if (existing.equals(pending.spec)) {
                if (this.supportsConfiguring()) {
                    applyContext.pendingBlock = pending;
                    pending.apply(applyContext, world);
                }
                world.func_147460_e(x, y, z, Blocks.field_150350_a);
                continue;
            }
            if (extracted != null && extracted.stackSize < (long)perBlock.field_77994_a) break;
            if (!existing.isAir()) {
                this.removeBlock(world, x, y, z, existing);
            }
            if (!pending.spec.isAir()) {
                Block block = pending.getBlock();
                Item item = pending.getItem();
                if (item instanceof ItemBlock) {
                    ItemBlock itemBlock = (ItemBlock)item;
                    itemBlock.placeBlockAt(perBlock, player, player.field_70170_p, x, y, z, this.getDefaultPlaceSide(pending.spec).ordinal(), 0.0f, 0.0f, 0.0f, metadata);
                } else {
                    if (!world.func_147465_d(x, y, z, block, metadata, 3)) continue;
                    if (world.func_147439_a(x, y, z) == block) {
                        block.func_149689_a(world, x, y, z, (EntityLivingBase)player, stack);
                        block.func_149714_e(world, x, y, z, metadata);
                    }
                }
            }
            if (extracted != null) {
                extracted.stackSize -= (long)perBlock.field_77994_a;
            }
            applyContext.pendingBlock = pending;
            pending.apply(applyContext, world);
        }
        if (extracted != null && i < toPlace.size()) {
            MMUtils.sendWarningToPlayer(player, StatCollector.func_74837_a((String)"mm.info.warning.could_not_find", (Object[])new Object[]{toPlace.size() - i}));
            MMUtils.sendWarningToPlayer(player, String.format("  %s x %d", first.getDisplayName(), total - (long)((toPlace.size() - i) * perBlock.field_77994_a)));
        }
        MMUtils.sendInfoToPlayer(player, StatCollector.func_74837_a((String)"mm.info.placed_remaining", (Object[])new Object[]{i, this.pendingBlocks.size()}));
        if (extracted != null && extracted.stackSize >= (long)perBlock.field_77994_a) {
            MMMod.LOG.error("Didn't consume enough items! " + perBlock.func_82833_r() + "; expected to consume " + total + ", but consumed " + (total - extracted.stackSize));
            this.givePlayerItems(extracted.toStacks().toArray(new ItemStack[0]));
        }
        while (i < toPlace.size()) {
            pending = (PendingBlock)toPlace.get(i);
            this.pendingBlocks.add(pending);
            long coord2 = CoordinatePacker.pack((int)pending.x, (int)pending.y, (int)pending.z);
            this.visited.remove(coord2);
            ++i;
        }
        this.actuallyGivePlayerStuff();
        this.playSounds();
    }

    @Override
    public void onStopped() {
        if (this.pendingItems.size() > 0 || this.pendingFluids.size() > 0) {
            MMMod.LOG.error("Build stopped without delivering all items! There's a bug somewhere!");
        }
        this.actuallyGivePlayerStuff();
        Messages.BuildStatus.sendToPlayer((EntityPlayerMP)this.player, Pair.of((Object)this.errors, (Object)this.warnings));
    }

    private boolean supportsConfiguring() {
        if (this.state.hasCap(ItemMatterManipulator.ALLOW_CONFIGURING)) {
            return true;
        }
        if (this.state.config.placeMode == MMState.PlaceMode.EXCHANGING) {
            return true;
        }
        return this.state.config.placeMode == MMState.PlaceMode.CABLES;
    }

    private ForgeDirection getDefaultPlaceSide(ImmutableBlockSpec spec) {
        if (Mods.GregTech.isModLoaded() && MMUtils.isGTCable(spec)) {
            return ForgeDirection.UNKNOWN;
        }
        return ForgeDirection.NORTH;
    }

    @Optional(value={"gregtech_nh"})
    private String getGTBlockName(PendingBlock pendingBlock) {
        IGregTechTileEntity igte;
        IMetaTileEntity imte;
        TileEntity tileEntity = this.player.field_70170_p.func_147438_o(pendingBlock.x, pendingBlock.y, pendingBlock.z);
        if (tileEntity instanceof IGregTechTileEntity && (imte = (igte = (IGregTechTileEntity)tileEntity).getMetaTileEntity()) != null) {
            return imte.getLocalName();
        }
        return null;
    }

    public class PendingBuildApplyContext
    implements BlockAnalyzer.IBlockApplyContext {
        public static final double EU_PER_ACTION = 8192.0;
        public ItemStack manipulatorItemStack;
        public PendingBlock pendingBlock;

        public PendingBuildApplyContext(ItemStack manipulatorItemStack) {
            this.manipulatorItemStack = manipulatorItemStack;
        }

        @Override
        public World getWorld() {
            return PendingBuild.this.player.field_70170_p;
        }

        @Override
        public int getX() {
            return this.pendingBlock.x;
        }

        @Override
        public int getY() {
            return this.pendingBlock.y;
        }

        @Override
        public int getZ() {
            return this.pendingBlock.z;
        }

        @Override
        public TileEntity getTileEntity() {
            if (this.pendingBlock.isInWorld(PendingBuild.this.player.field_70170_p)) {
                return PendingBuild.this.player.field_70170_p.func_147438_o(this.pendingBlock.x, this.pendingBlock.y, this.pendingBlock.z);
            }
            return null;
        }

        @Override
        public EntityPlayer getRealPlayer() {
            return PendingBuild.this.player;
        }

        @Override
        public boolean tryApplyAction(double complexity) {
            return PendingBuild.this.tryConsumePower(this.manipulatorItemStack, this.pendingBlock.x, this.pendingBlock.y, this.pendingBlock.z, 8192.0 * complexity);
        }

        @Override
        public BooleanObjectImmutablePair<List<BigItemStack>> tryConsumeItems(List<BigItemStack> items, int flags) {
            return PendingBuild.this.tryConsumeItems(items, flags);
        }

        @Override
        public void givePlayerItems(List<BigItemStack> items) {
            PendingBuild.this.givePlayerItems(items);
        }

        @Override
        public void givePlayerFluids(List<BigFluidStack> fluids) {
            PendingBuild.this.givePlayerFluids(fluids);
        }

        @Override
        public void warn(String message) {
            String blockName = null;
            if (this.pendingBlock.isInWorld(PendingBuild.this.player.field_70170_p)) {
                if (Mods.GregTech.isModLoaded()) {
                    blockName = PendingBuild.this.getGTBlockName(this.pendingBlock);
                }
                if (blockName == null) {
                    BlockSpec spec = BlockSpec.fromBlock(null, PendingBuild.this.player.field_70170_p, this.pendingBlock.x, this.pendingBlock.y, this.pendingBlock.z);
                    blockName = InteropConstants.AE_BLOCK_CABLE.matches(spec) ? InteropConstants.AE_BLOCK_CABLE.toSpec().getDisplayName() : spec.getDisplayName();
                }
            }
            MMUtils.sendWarningToPlayer(PendingBuild.this.player, StatCollector.func_74837_a((String)"mm.info.warning", (Object[])new Object[]{this.pendingBlock.x, this.pendingBlock.y, this.pendingBlock.z, blockName != null ? " (" + blockName + ")" : "", message}));
            PendingBuild.this.warnings.add(CoordinatePacker.pack((int)this.pendingBlock.x, (int)this.pendingBlock.y, (int)this.pendingBlock.z));
        }

        @Override
        public void error(String message) {
            String blockName = null;
            if (this.pendingBlock.isInWorld(PendingBuild.this.player.field_70170_p)) {
                BlockSpec spec;
                if (Mods.GregTech.isModLoaded()) {
                    blockName = PendingBuild.this.getGTBlockName(this.pendingBlock);
                }
                blockName = InteropConstants.AE_BLOCK_CABLE.matches(spec = BlockSpec.fromBlock(null, PendingBuild.this.player.field_70170_p, this.pendingBlock.x, this.pendingBlock.y, this.pendingBlock.z)) ? InteropConstants.AE_BLOCK_CABLE.toSpec().getDisplayName() : spec.getDisplayName();
            }
            MMUtils.sendErrorToPlayer(PendingBuild.this.player, StatCollector.func_74837_a((String)"mm.info.error", (Object[])new Object[]{this.pendingBlock.x, this.pendingBlock.y, this.pendingBlock.z, blockName != null ? " (" + blockName + ")" : "", message}));
            PendingBuild.this.errors.add(CoordinatePacker.pack((int)this.pendingBlock.x, (int)this.pendingBlock.y, (int)this.pendingBlock.z));
        }
    }
}

