/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.api.event;

import cpw.mods.fml.common.eventhandler.Event;
import li.cil.oc.api.network.Node;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class NetworkActivityEvent
extends Event {
    protected World world;
    protected double x;
    protected double y;
    protected double z;
    protected TileEntity tileEntity;
    protected NBTTagCompound data;

    protected NetworkActivityEvent(TileEntity tileEntity, NBTTagCompound data) {
        this.world = tileEntity.func_145831_w();
        this.x = (double)tileEntity.field_145851_c + 0.5;
        this.y = (double)tileEntity.field_145848_d + 0.5;
        this.z = (double)tileEntity.field_145849_e + 0.5;
        this.tileEntity = tileEntity;
        this.data = data;
    }

    protected NetworkActivityEvent(World world, double x, double y, double z, NBTTagCompound data) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.tileEntity = null;
        this.data = data;
    }

    public World getWorld() {
        return this.world;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public TileEntity getTileEntity() {
        return this.tileEntity;
    }

    public NBTTagCompound getData() {
        return this.data;
    }

    public static final class Client
    extends NetworkActivityEvent {
        public Client(TileEntity tileEntity, NBTTagCompound data) {
            super(tileEntity, data);
        }

        public Client(World world, double x, double y, double z, NBTTagCompound data) {
            super(world, x, y, z, data);
        }
    }

    public static final class Server
    extends NetworkActivityEvent {
        private Node node;

        public Server(TileEntity tileEntity, Node node2) {
            super(tileEntity, new NBTTagCompound());
            this.node = node2;
        }

        public Server(World world, double x, double y, double z, Node node2) {
            super(world, x, y, z, new NBTTagCompound());
            this.node = node2;
        }

        public Node getNode() {
            return this.node;
        }
    }
}

