/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.shadow.org.apache.commons.math3.distribution;

import mcp.mobius.shadow.org.apache.commons.math3.distribution.AbstractRealDistribution;
import mcp.mobius.shadow.org.apache.commons.math3.exception.OutOfRangeException;
import mcp.mobius.shadow.org.apache.commons.math3.random.RandomGenerator;
import mcp.mobius.shadow.org.apache.commons.math3.special.Erf;
import mcp.mobius.shadow.org.apache.commons.math3.util.FastMath;

public class LevyDistribution
extends AbstractRealDistribution {
    private static final long serialVersionUID = 20130314L;
    private final double mu;
    private final double c;
    private final double halfC;

    public LevyDistribution(RandomGenerator rng, double mu, double c) {
        super(rng);
        this.mu = mu;
        this.c = c;
        this.halfC = 0.5 * c;
    }

    public double density(double x) {
        if (x < this.mu) {
            return Double.NaN;
        }
        double delta = x - this.mu;
        double f = this.halfC / delta;
        return FastMath.sqrt(f / Math.PI) * FastMath.exp(-f) / delta;
    }

    public double cumulativeProbability(double x) {
        if (x < this.mu) {
            return Double.NaN;
        }
        return Erf.erfc(FastMath.sqrt(this.halfC / (x - this.mu)));
    }

    public double inverseCumulativeProbability(double p) throws OutOfRangeException {
        if (p < 0.0 || p > 1.0) {
            throw new OutOfRangeException(p, (Number)0, 1);
        }
        double t = Erf.erfcInv(p);
        return this.mu + this.halfC / (t * t);
    }

    public double getScale() {
        return this.c;
    }

    public double getLocation() {
        return this.mu;
    }

    public double getNumericalMean() {
        return Double.POSITIVE_INFINITY;
    }

    public double getNumericalVariance() {
        return Double.POSITIVE_INFINITY;
    }

    public double getSupportLowerBound() {
        return this.mu;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public boolean isSupportLowerBoundInclusive() {
        return false;
    }

    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public boolean isSupportConnected() {
        return true;
    }
}

