/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.hd;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.hd.MipmapHelper;
import com.prupe.mcpatcher.mal.resource.BlendMethod;
import com.prupe.mcpatcher.mal.resource.GLAPI;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import com.prupe.mcpatcher.mal.util.InputHandler;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import jss.notfine.config.MCPatcherForgeConfig;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureClock;
import net.minecraft.client.renderer.texture.TextureCompass;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.GLU;

public class FancyDial {
    private static final MCLogger logger = MCLogger.getLogger(MCLogger.Category.EXTENDED_HD, "Animation");
    private static final double ANGLE_UNSET = Double.MAX_VALUE;
    private static final int NUM_SCRATCH_TEXTURES = 3;
    private static final boolean fboSupported = GLContext.getCapabilities().GL_EXT_framebuffer_object;
    private static final boolean gl13Supported = GLContext.getCapabilities().OpenGL13;
    private static final boolean enableCompass = MCPatcherForgeConfig.ExtendedHD.fancyCompass;
    private static final boolean enableClock = MCPatcherForgeConfig.ExtendedHD.fancyClock;
    private static final boolean useGL13 = gl13Supported && MCPatcherForgeConfig.ExtendedHD.useGL13;
    private static final boolean useScratchTexture = MCPatcherForgeConfig.ExtendedHD.useScratchTexture;
    private static final int glAttributes;
    private static boolean initialized;
    private static boolean active;
    private static final int drawList;
    private static final Map<TextureAtlasSprite, ResourceLocation> setupInfo;
    private static final Map<TextureAtlasSprite, FancyDial> instances;
    private static int warnCount;
    private final TextureAtlasSprite icon;
    private final String name;
    private final int x0;
    private final int y0;
    private final int width;
    private final int height;
    private final ByteBuffer scratchBuffer;
    private final FBO[] scratchFBO = new FBO[3];
    private FBO itemsFBO;
    private int scratchIndex;
    private Map<Double, ByteBuffer> itemFrames = new TreeMap<Double, ByteBuffer>();
    private int outputFrames;
    private boolean ok;
    private double lastAngle = Double.MAX_VALUE;
    private boolean lastItemFrameRenderer;
    private final List<Layer> layers = new ArrayList<Layer>();
    private InputHandler keyboard;
    private static final float STEP = 0.01f;
    private float scaleXDelta;
    private float scaleYDelta;
    private float offsetXDelta;
    private float offsetYDelta;

    public static void setup(TextureAtlasSprite icon) {
        ResourceLocation resource;
        if (!fboSupported) {
            return;
        }
        String name = icon.func_94215_i().replaceFirst("^minecraft:items/", "");
        if ("compass".equals(name)) {
            if (!enableCompass) {
                return;
            }
        } else if ("clock".equals(name)) {
            if (!enableClock) {
                return;
            }
        } else {
            logger.warning("ignoring custom animation for %s not compass or clock", name);
            return;
        }
        if (TexturePackAPI.hasResource(resource = TexturePackAPI.newMCPatcherResourceLocation("dial/" + name + ".properties"))) {
            logger.fine("found custom %s (%s)", name, resource);
            setupInfo.put(icon, resource);
            active = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean update(TextureAtlasSprite icon, boolean itemFrameRenderer) {
        if (!initialized) {
            logger.finer("deferring %s update until initialization finishes", icon.func_94215_i());
            return false;
        }
        if (!active) {
            return false;
        }
        int oldFB = GL11.glGetInteger((int)36006);
        if (oldFB != 0 && warnCount < 10) {
            logger.finer("rendering %s while non-default framebuffer %d is active", icon.func_94215_i(), oldFB);
            ++warnCount;
        }
        int oldTexture = GL11.glGetInteger((int)32873);
        try {
            FancyDial instance = FancyDial.getInstance(icon);
            boolean bl = instance != null && instance.render(itemFrameRenderer);
            return bl;
        }
        finally {
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)oldFB);
            GLAPI.glBindTexture(oldTexture);
        }
    }

    static void clearAll() {
        logger.finer("FancyDial.clearAll", new Object[0]);
        if (initialized) {
            active = false;
            setupInfo.clear();
        }
        for (FancyDial instance : instances.values()) {
            if (instance == null) continue;
            instance.finish();
        }
        instances.clear();
        initialized = true;
    }

    static void registerAnimations() {
        ITextureObject texture = TexturePackAPI.getTextureObject(TexturePackAPI.ITEMS_PNG);
        if (texture instanceof TextureMap) {
            TextureMap map = (TextureMap)texture;
            List animations = map.field_94258_i;
            for (FancyDial instance : instances.values()) {
                instance.registerAnimation(animations);
            }
        }
    }

    void registerAnimation(List<TextureAtlasSprite> animations) {
        if (animations.contains(this.icon)) {
            return;
        }
        animations.add(this.icon);
        if (this.icon.field_110976_a == null) {
            this.icon.field_110976_a = new ArrayList();
        }
        if (this.icon.field_110976_a.isEmpty()) {
            int[][] dummyRGB = new int[this.width * this.height][];
            Arrays.fill(dummyRGB[0], -65281);
            this.icon.field_110976_a.add(dummyRGB);
        }
        logger.fine("registered %s animation", this.name);
    }

    private static FancyDial getInstance(TextureAtlasSprite icon) {
        if (instances.containsKey(icon)) {
            return instances.get(icon);
        }
        ResourceLocation resource = setupInfo.remove(icon);
        instances.put(icon, null);
        if (resource == null) {
            return null;
        }
        PropertiesFile properties = PropertiesFile.get(logger, resource);
        if (properties == null) {
            return null;
        }
        try {
            FancyDial instance = new FancyDial(icon, properties);
            if (instance.ok) {
                instances.put(icon, instance);
                return instance;
            }
            instance.finish();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    private FancyDial(TextureAtlasSprite icon, PropertiesFile properties) {
        this.icon = icon;
        this.name = icon.func_94215_i();
        this.x0 = icon.func_130010_a();
        this.y0 = icon.func_110967_i();
        this.width = icon.func_94211_a();
        this.height = icon.func_94216_b();
        this.scratchBuffer = ByteBuffer.allocateDirect(4 * this.width * this.height);
        int itemsTexture = TexturePackAPI.getTextureIfLoaded(TexturePackAPI.ITEMS_PNG);
        if (itemsTexture < 0) {
            logger.severe("could not get items texture", new Object[0]);
            return;
        }
        this.itemsFBO = new FBO(itemsTexture, this.x0, this.y0, this.width, this.height);
        if (useScratchTexture) {
            logger.fine("rendering %s to %dx%d scratch texture", this.name, this.width, this.height);
            for (int i = 0; i < this.scratchFBO.length; ++i) {
                this.scratchFBO[i] = new FBO(this.width, this.height);
            }
        } else {
            logger.fine("rendering %s directly to atlas", this.name);
        }
        boolean debug = false;
        int i = 0;
        while (true) {
            Layer layer;
            if ((layer = this.newLayer(properties, "." + i)) == null) {
                if (i > 0) {
                    break;
                }
            } else {
                this.layers.add(layer);
                debug |= layer.debug;
                logger.fine("  new %s", layer);
            }
            ++i;
        }
        this.keyboard = new InputHandler(this.name, debug);
        if (this.layers.size() < 2) {
            logger.error("custom %s needs at least two layers defined", this.name);
            return;
        }
        this.outputFrames = properties.getInt("outputFrames", 0);
        int glError = GL11.glGetError();
        if (glError != 0) {
            logger.severe("%s during %s setup", GLU.gluErrorString((int)glError), this.name);
            return;
        }
        this.ok = true;
    }

    private boolean render(boolean itemFrameRenderer) {
        int glError;
        if (!this.ok) {
            return false;
        }
        if (!itemFrameRenderer) {
            boolean changed = true;
            if (!this.keyboard.isEnabled()) {
                changed = false;
            } else if (this.keyboard.isKeyPressed(80)) {
                this.scaleYDelta -= 0.01f;
            } else if (this.keyboard.isKeyPressed(72)) {
                this.scaleYDelta += 0.01f;
            } else if (this.keyboard.isKeyPressed(75)) {
                this.scaleXDelta -= 0.01f;
            } else if (this.keyboard.isKeyPressed(77)) {
                this.scaleXDelta += 0.01f;
            } else if (this.keyboard.isKeyPressed(208)) {
                this.offsetYDelta += 0.01f;
            } else if (this.keyboard.isKeyPressed(200)) {
                this.offsetYDelta -= 0.01f;
            } else if (this.keyboard.isKeyPressed(203)) {
                this.offsetXDelta -= 0.01f;
            } else if (this.keyboard.isKeyPressed(205)) {
                this.offsetXDelta += 0.01f;
            } else if (this.keyboard.isKeyPressed(55)) {
                this.offsetYDelta = 0.0f;
                this.offsetXDelta = 0.0f;
                this.scaleYDelta = 0.0f;
                this.scaleXDelta = 0.0f;
            } else {
                changed = false;
            }
            if (changed) {
                logger.info("", new Object[0]);
                logger.info("scaleX  %+f", Float.valueOf(this.scaleXDelta));
                logger.info("scaleY  %+f", Float.valueOf(this.scaleYDelta));
                logger.info("offsetX %+f", Float.valueOf(this.offsetXDelta));
                logger.info("offsetY %+f", Float.valueOf(this.offsetYDelta));
                this.lastAngle = Double.MAX_VALUE;
            }
            if (this.outputFrames > 0) {
                this.writeCustomImage();
                this.outputFrames = 0;
            }
        }
        double angle = FancyDial.getAngle((IIcon)this.icon);
        if (!useScratchTexture) {
            if (angle != this.lastAngle) {
                this.renderToItems(angle);
                this.lastAngle = angle;
            }
        } else if (itemFrameRenderer) {
            ByteBuffer buffer = this.itemFrames.get(angle);
            if (buffer == null) {
                logger.fine("rendering %s at angle %f for item frame", this.name, angle);
                buffer = ByteBuffer.allocateDirect(this.width * this.height * 4);
                this.renderToItems(angle);
                this.itemsFBO.read(buffer);
                this.itemFrames.put(angle, buffer);
            } else {
                this.itemsFBO.write(buffer);
            }
            this.lastItemFrameRenderer = true;
        } else if (this.lastAngle == Double.MAX_VALUE) {
            for (FBO fbo : this.scratchFBO) {
                this.renderToFB(angle, fbo);
            }
            this.scratchFBO[0].read(this.scratchBuffer);
            this.itemsFBO.write(this.scratchBuffer);
            this.lastAngle = angle;
            this.scratchIndex = 0;
        } else if (this.lastItemFrameRenderer || angle != this.lastAngle) {
            int nextIndex = (this.scratchIndex + 1) % 3;
            if (angle != this.lastAngle) {
                this.renderToFB(angle, this.scratchFBO[nextIndex]);
                this.scratchFBO[this.scratchIndex].read(this.scratchBuffer);
            }
            this.itemsFBO.write(this.scratchBuffer);
            this.lastAngle = angle;
            this.scratchIndex = nextIndex;
            this.lastItemFrameRenderer = false;
        }
        if ((glError = GL11.glGetError()) != 0) {
            logger.severe("%s during %s update", GLU.gluErrorString((int)glError), this.name);
            this.ok = false;
        }
        return this.ok;
    }

    private void writeCustomImage() {
        try {
            BufferedImage image = new BufferedImage(this.width, this.outputFrames * this.height, 2);
            IntBuffer intBuffer = this.scratchBuffer.asIntBuffer();
            int[] argb = new int[this.width * this.height];
            File path = MCPatcherUtils.getGamePath("custom_" + this.name + ".png");
            logger.info("generating %d %s frames", this.outputFrames, this.name);
            for (int i = 0; i < this.outputFrames; ++i) {
                this.renderToItems((double)i * (360.0 / (double)this.outputFrames));
                this.itemsFBO.read(this.scratchBuffer);
                intBuffer.position(0);
                block7: for (int j = 0; j < argb.length; ++j) {
                    switch (32993) {
                        case 32993: {
                            int bgra = intBuffer.get(j);
                            argb[j] = bgra << 24 | (bgra & 0xFF00) << 8 | (bgra & 0xFF0000) >> 8 | bgra >>> 24;
                            continue block7;
                        }
                        default: {
                            if (i == 0 && j == 0) {
                                logger.warning("unhandled texture format %d, color channels may be incorrect", 32993);
                            }
                        }
                        case 6408: {
                            argb[j] = Integer.rotateRight(intBuffer.get(j), 8);
                        }
                    }
                }
                image.setRGB(0, i * this.height, this.width, this.height, argb, 0, this.width);
            }
            ImageIO.write((RenderedImage)image, "png", path);
            logger.info("wrote %dx%d %s", image.getWidth(), image.getHeight(), path.getPath());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void renderToItems(double angle) {
        this.renderToFB(angle, this.itemsFBO);
    }

    private void renderToFB(double angle, FBO fbo) {
        if (fbo != null) {
            fbo.bind();
            this.renderImpl(angle);
            fbo.unbind();
        }
    }

    private void renderImpl(double angle) {
        for (Layer layer : this.layers) {
            layer.blendMethod.applyBlending();
            GL11.glPushMatrix();
            TexturePackAPI.bindTexture(layer.textureName);
            float offsetX = layer.offsetX;
            float offsetY = layer.offsetY;
            float scaleX = layer.scaleX;
            float scaleY = layer.scaleY;
            if (layer.debug) {
                offsetX += this.offsetXDelta;
                offsetY += this.offsetYDelta;
                scaleX += this.scaleXDelta;
                scaleY += this.scaleYDelta;
            }
            GL11.glTranslatef((float)offsetX, (float)offsetY, (float)0.0f);
            GL11.glScalef((float)scaleX, (float)scaleY, (float)1.0f);
            float layerAngle = (float)(angle * (double)layer.rotationMultiplier + (double)layer.rotationOffset);
            GL11.glRotatef((float)layerAngle, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glCallList((int)drawList);
            GL11.glPopMatrix();
        }
    }

    private static void drawBox() {
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)-1.0f, (float)-1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)-1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)-1.0f, (float)1.0f, (float)0.0f);
        GL11.glEnd();
    }

    private void finish() {
        for (int i = 0; i < this.scratchFBO.length; ++i) {
            if (this.scratchFBO[i] == null) continue;
            this.scratchFBO[i].delete();
            this.scratchFBO[i] = null;
        }
        if (this.itemsFBO != null) {
            this.itemsFBO.delete();
            this.itemsFBO = null;
        }
        this.itemFrames.clear();
        this.layers.clear();
        this.ok = false;
    }

    public String toString() {
        return String.format("FancyDial{%s, %dx%d @ %d,%d}", this.name, this.width, this.height, this.x0, this.y0);
    }

    protected void finalize() throws Throwable {
        this.finish();
        super.finalize();
    }

    private static double getAngle(IIcon icon) {
        if (icon instanceof TextureCompass) {
            return ((TextureCompass)icon).field_94244_i * 180.0 / Math.PI;
        }
        if (icon instanceof TextureClock) {
            return ((TextureClock)icon).field_94239_h * 360.0;
        }
        return 0.0;
    }

    Layer newLayer(PropertiesFile properties, String suffix) {
        ResourceLocation textureResource = properties.getResourceLocation("source" + suffix, "");
        if (textureResource == null) {
            return null;
        }
        if (!TexturePackAPI.hasResource(textureResource)) {
            properties.error("could not read %s", textureResource);
            return null;
        }
        float scaleX = properties.getFloat("scaleX" + suffix, 1.0f);
        float scaleY = properties.getFloat("scaleY" + suffix, 1.0f);
        float offsetX = properties.getFloat("offsetX" + suffix, 0.0f);
        float offsetY = properties.getFloat("offsetY" + suffix, 0.0f);
        float angleMultiplier = properties.getFloat("rotationSpeed" + suffix, 0.0f);
        float angleOffset = properties.getFloat("rotationOffset" + suffix, 0.0f);
        String blend = properties.getString("blend" + suffix, "alpha");
        BlendMethod blendMethod = BlendMethod.parse(blend);
        if (blendMethod == null) {
            properties.error("unknown blend method %s", blend);
            return null;
        }
        boolean debug = properties.getBoolean("debug" + suffix, false);
        return new Layer(textureResource, scaleX, scaleY, offsetX, offsetY, angleMultiplier, angleOffset, blendMethod, debug);
    }

    static {
        drawList = GL11.glGenLists((int)1);
        setupInfo = new IdentityHashMap<TextureAtlasSprite, ResourceLocation>();
        instances = new IdentityHashMap<TextureAtlasSprite, FancyDial>();
        logger.config("fbo: supported=%s", fboSupported);
        logger.config("GL13: supported=%s, enabled=%s", gl13Supported, useGL13);
        int bits = 527702;
        if (useGL13) {
            bits |= 0x20000000;
        }
        glAttributes = bits;
        GL11.glNewList((int)drawList, (int)4864);
        FancyDial.drawBox();
        GL11.glEndList();
    }

    private static class FBO {
        private final int texture;
        private final boolean ownTexture;
        private final int x0;
        private final int y0;
        private final int width;
        private final int height;
        private final int frameBuffer;
        private boolean lightmapEnabled;
        private boolean deleted;

        FBO(int width, int height) {
            this(FBO.blankTexture(width, height), true, 0, 0, width, height);
        }

        FBO(int texture, int x0, int y0, int width, int height) {
            this(texture, false, x0, y0, width, height);
        }

        private FBO(int texture, boolean ownTexture, int x0, int y0, int width, int height) {
            this.texture = texture;
            this.ownTexture = ownTexture;
            this.x0 = x0;
            this.y0 = y0;
            this.width = width;
            this.height = height;
            this.frameBuffer = EXTFramebufferObject.glGenFramebuffersEXT();
            if (this.frameBuffer < 0) {
                throw new RuntimeException("could not get framebuffer object");
            }
            GLAPI.glBindTexture(texture);
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)this.frameBuffer);
            EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36064, (int)3553, (int)texture, (int)0);
        }

        void bind() {
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)this.frameBuffer);
            GL11.glPushAttrib((int)glAttributes);
            GL11.glViewport((int)this.x0, (int)this.y0, (int)this.width, (int)this.height);
            GL11.glEnable((int)3089);
            GL11.glScissor((int)this.x0, (int)this.y0, (int)this.width, (int)this.height);
            this.lightmapEnabled = false;
            if (gl13Supported) {
                GL13.glActiveTexture((int)33985);
                this.lightmapEnabled = GL11.glIsEnabled((int)3553);
                if (this.lightmapEnabled) {
                    GL11.glDisable((int)3553);
                }
                GL13.glActiveTexture((int)33984);
            }
            GL11.glEnable((int)3553);
            GL11.glDisable((int)2929);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3008);
            GL11.glAlphaFunc((int)516, (float)0.01f);
            if (useGL13) {
                GL11.glDisable((int)32925);
            }
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glClear((int)16384);
            GL11.glMatrixMode((int)5889);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GL11.glOrtho((double)-1.0, (double)1.0, (double)-1.0, (double)1.0, (double)-1.0, (double)1.0);
            GL11.glMatrixMode((int)5888);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
        }

        void unbind() {
            GL11.glPopAttrib();
            GL11.glMatrixMode((int)5889);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            GL11.glPopMatrix();
            if (this.lightmapEnabled) {
                GL13.glActiveTexture((int)33985);
                GL11.glEnable((int)3553);
                GL13.glActiveTexture((int)33984);
            }
            GL11.glEnable((int)3042);
            GLAPI.glBlendFuncSeparate(770, 771, 1, 0);
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
        }

        void read(ByteBuffer buffer) {
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)this.frameBuffer);
            buffer.position(0);
            GL11.glReadPixels((int)this.x0, (int)this.y0, (int)this.width, (int)this.height, (int)32993, (int)33639, (ByteBuffer)buffer);
        }

        void write(ByteBuffer buffer) {
            GLAPI.glBindTexture(this.texture);
            buffer.position(0);
            GL11.glTexSubImage2D((int)3553, (int)0, (int)this.x0, (int)this.y0, (int)this.width, (int)this.height, (int)32993, (int)33639, (ByteBuffer)buffer);
        }

        void delete() {
            if (!this.deleted) {
                this.deleted = true;
                if (this.ownTexture) {
                    GL11.glDeleteTextures((int)this.texture);
                }
                EXTFramebufferObject.glDeleteFramebuffersEXT((int)this.frameBuffer);
            }
        }

        protected void finalize() throws Throwable {
            this.delete();
            super.finalize();
        }

        private static int blankTexture(int width, int height) {
            int texture = GL11.glGenTextures();
            MipmapHelper.setupTexture(texture, width, height, "scratch");
            return texture;
        }
    }

    private class Layer {
        final ResourceLocation textureName;
        final float scaleX;
        final float scaleY;
        final float offsetX;
        final float offsetY;
        final float rotationMultiplier;
        final float rotationOffset;
        final BlendMethod blendMethod;
        final boolean debug;

        Layer(ResourceLocation textureName, float scaleX, float scaleY, float offsetX, float offsetY, float rotationMultiplier, float rotationOffset, BlendMethod blendMethod, boolean debug) {
            this.textureName = textureName;
            this.scaleX = scaleX;
            this.scaleY = scaleY;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.rotationMultiplier = rotationMultiplier;
            this.rotationOffset = rotationOffset;
            this.blendMethod = blendMethod;
            this.debug = debug;
        }

        public String toString() {
            return String.format("Layer{%s %f %f %+f %+f x%f}", this.textureName, Float.valueOf(this.scaleX), Float.valueOf(this.scaleY), Float.valueOf(this.offsetX), Float.valueOf(this.offsetY), Float.valueOf(this.rotationMultiplier));
        }
    }
}

