/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.network;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import com.glodblock.github.client.gui.container.ContainerFluidLevelEmitter;
import com.glodblock.github.common.item.ItemBaseWirelessTerminal;
import com.glodblock.github.inventory.item.WirelessCraftingTerminalInventory;
import com.glodblock.github.util.Util;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class CPacketValueConfig
implements IMessage {
    private long amount;
    private int valueIndex;

    public CPacketValueConfig() {
    }

    public CPacketValueConfig(long amount, int valueIndex) {
        this.amount = amount;
        this.valueIndex = valueIndex;
    }

    public void fromBytes(ByteBuf buf) {
        this.amount = buf.readLong();
        this.valueIndex = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.amount);
        buf.writeInt(this.valueIndex);
    }

    public static class Handler
    implements IMessageHandler<CPacketValueConfig, IMessage> {
        public IMessage onMessage(CPacketValueConfig message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Container container = player.field_71070_bA;
            if (container != null) {
                ImmutablePair<Integer, ItemStack> result;
                if (container instanceof ContainerFluidLevelEmitter) {
                    ((ContainerFluidLevelEmitter)container).setLevel(message.amount, (EntityPlayer)player);
                } else if (container instanceof ContainerPlayer && (result = Util.getUltraWirelessTerm((EntityPlayer)player)) != null) {
                    ItemStack wirelessTerm = (ItemStack)result.getRight();
                    if (message.valueIndex == 1) {
                        ItemBaseWirelessTerminal.toggleRestockItemsMode(wirelessTerm, !Util.isRestock(wirelessTerm));
                        player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)(Util.isRestock(wirelessTerm) ? "ae2fc.tooltip.ultra_terminal.restock.on" : "ae2fc.tooltip.ultra_terminal.restock.off"))));
                    } else {
                        IGridNode gridNode = Util.getWirelessGrid(wirelessTerm);
                        if (gridNode != null && Util.isRestock(wirelessTerm) && Util.rangeCheck(wirelessTerm, (EntityPlayer)player, gridNode)) {
                            this.restockItems(wirelessTerm, gridNode, (Integer)result.getLeft(), (EntityPlayer)player);
                        }
                    }
                }
            }
            return null;
        }

        private void restockItems(ItemStack terminal, IGridNode gridNode, int slot, EntityPlayer player) {
            WirelessCraftingTerminalInventory inv = new WirelessCraftingTerminalInventory(terminal, slot, gridNode, player);
            for (int i = 0; i < 9; ++i) {
                int maxSize;
                ItemStack is = player.field_71071_by.field_70462_a[i];
                if (is == null || is.field_77994_a >= (maxSize = is.func_77976_d())) continue;
                int fillSize = maxSize - is.field_77994_a;
                IAEItemStack ias = AEApi.instance().storage().createItemStack(is);
                ias.setStackSize((long)fillSize);
                IAEItemStack extractedItem = (IAEItemStack)inv.extractItems((IAEStack)ias, Actionable.MODULATE, (BaseActionSource)inv.getActionSource());
                if (extractedItem == null) continue;
                player.field_71071_by.func_70441_a(extractedItem.getItemStack());
            }
        }
    }
}

