/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.crossmod.extracells.storage;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.data.IAEFluidStack;
import appeng.items.contents.CellUpgrades;
import appeng.util.Platform;
import com.glodblock.github.api.FluidCraftAPI;
import com.glodblock.github.common.storage.IStorageFluidCell;
import com.glodblock.github.crossmod.extracells.ProxyItem;
import com.glodblock.github.inventory.FluidCellConfig;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class ProxyFluidStorageCell
extends ProxyItem
implements IStorageFluidCell {
    public ProxyFluidStorageCell(String ec2itemName) {
        super(ec2itemName);
    }

    @Override
    public long getBytes(ItemStack cellItem) {
        ProxyItem.ProxyItemEntry entry;
        int meta = cellItem.func_77960_j();
        if (this.replacements.containsKey(meta) && (entry = (ProxyItem.ProxyItemEntry)this.replacements.get(meta)) instanceof ProxyItem.ProxyStorageEntry) {
            return ((ProxyItem.ProxyStorageEntry)entry).maxBytes;
        }
        return 0L;
    }

    @Override
    public int getBytesPerType(ItemStack cellItem) {
        ProxyItem.ProxyItemEntry entry;
        int meta = cellItem.func_77960_j();
        if (this.replacements.containsKey(meta) && (entry = (ProxyItem.ProxyItemEntry)this.replacements.get(meta)) instanceof ProxyItem.ProxyStorageEntry) {
            return ((ProxyItem.ProxyStorageEntry)entry).bytesPerType;
        }
        return 0;
    }

    @Override
    public boolean isBlackListed(ItemStack cellItem, IAEFluidStack requestedAddition) {
        return requestedAddition == null || requestedAddition.getFluid() == null || FluidCraftAPI.instance().isBlacklistedInStorage(requestedAddition.getFluid().getClass());
    }

    @Override
    public boolean storableInStorageCell() {
        return false;
    }

    @Override
    public boolean isStorageCell(ItemStack i) {
        return true;
    }

    @Override
    public double getIdleDrain(ItemStack is) {
        ProxyItem.ProxyItemEntry entry;
        int meta = is.func_77960_j();
        if (this.replacements.containsKey(meta) && (entry = (ProxyItem.ProxyItemEntry)this.replacements.get(meta)) instanceof ProxyItem.ProxyStorageEntry) {
            return ((ProxyItem.ProxyStorageEntry)entry).idleDrain;
        }
        return 0.0;
    }

    @Override
    public int getTotalTypes(ItemStack cellItem) {
        return 5;
    }

    public boolean isEditable(ItemStack is) {
        return true;
    }

    public IInventory getUpgradesInventory(ItemStack is) {
        return new CellUpgrades(is, 0);
    }

    public IInventory getConfigInventory(ItemStack is) {
        return new FluidCellConfig(is);
    }

    public FuzzyMode getFuzzyMode(ItemStack is) {
        String fz = Platform.openNbtData((ItemStack)is).func_74779_i("FuzzyMode");
        try {
            return FuzzyMode.valueOf((String)fz);
        }
        catch (Throwable t) {
            return FuzzyMode.IGNORE_ALL;
        }
    }

    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
    }
}

