/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.parts.base;

import appeng.api.networking.IGrid;
import appeng.api.storage.ITerminalPins;
import appeng.api.storage.data.IAEItemStack;
import appeng.items.contents.PinsHandler;
import appeng.items.contents.PinsHolder;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import com.glodblock.github.common.item.ItemFluidPacket;
import com.glodblock.github.common.parts.base.FCPart;
import com.glodblock.github.inventory.item.IItemPatternTerminal;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class FCFluidEncodeTerminal
extends FCPart
implements IItemPatternTerminal,
ITerminalPins {
    protected AppEngInternalInventory crafting;
    protected AppEngInternalInventory output;
    protected final AppEngInternalInventory pattern = new AppEngInternalInventory((IAEAppEngInventory)this, 2);
    private final PinsHolder pinsInv = new PinsHolder((ITerminalPins)this);
    protected boolean craftingMode = true;
    protected boolean substitute = false;
    protected boolean combine = false;
    protected boolean prioritize = false;
    protected boolean inverted = false;
    protected boolean beSubstitute = false;
    protected boolean autoFillPattern = false;
    protected int activePage = 0;

    public FCFluidEncodeTerminal(ItemStack is) {
        super(is, true);
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        super.getDrops(drops, wrenched);
        for (ItemStack is : this.pattern) {
            if (is == null) continue;
            drops.add(is);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.setCraftingRecipe(data.func_74767_n("craftingMode"));
        this.setSubstitution(data.func_74767_n("substitute"));
        this.setCombineMode(data.func_74767_n("combine"));
        this.setBeSubstitute(data.func_74767_n("beSubstitute"));
        this.setPrioritization(data.func_74767_n("priorization"));
        this.setInverted(data.func_74767_n("inverted"));
        this.setActivePage(data.func_74762_e("activePage"));
        this.setAutoFillPattern(data.func_74767_n("autoFillPattern"));
        this.pattern.readFromNBT(data, "pattern");
        this.output.readFromNBT(data, "outputList");
        this.crafting.readFromNBT(data, "craftingGrid");
        this.pinsInv.readFromNBT(data, "pins");
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("craftingMode", this.craftingMode);
        data.func_74757_a("combine", this.combine);
        data.func_74757_a("beSubstitute", this.beSubstitute);
        data.func_74757_a("priorization", this.prioritize);
        data.func_74757_a("substitute", this.substitute);
        data.func_74757_a("inverted", this.inverted);
        data.func_74768_a("activePage", this.activePage);
        data.func_74757_a("autoFillPattern", this.autoFillPattern);
        this.pattern.writeToNBT(data, "pattern");
        this.output.writeToNBT(data, "outputList");
        this.crafting.writeToNBT(data, "craftingGrid");
        this.pinsInv.writeToNBT(data, "pins");
    }

    @Override
    public boolean shouldCombine() {
        return this.combine;
    }

    @Override
    public void setCombineMode(boolean shouldCombine) {
        this.combine = shouldCombine;
    }

    @Override
    public boolean isSubstitution() {
        return this.substitute;
    }

    @Override
    public boolean isPrioritize() {
        return this.prioritize;
    }

    @Override
    public void setBeSubstitute(boolean canBeSubstitute) {
        this.beSubstitute = canBeSubstitute;
    }

    @Override
    public boolean canBeSubstitute() {
        return this.beSubstitute;
    }

    @Override
    public void setSubstitution(boolean canSubstitute) {
        this.substitute = canSubstitute;
    }

    @Override
    public void setPrioritization(boolean canPrioritize) {
        this.prioritize = canPrioritize;
    }

    @Override
    public boolean isInverted() {
        return this.inverted;
    }

    @Override
    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }

    @Override
    public int getActivePage() {
        return this.activePage;
    }

    @Override
    public void setActivePage(int activePage) {
        this.activePage = activePage;
    }

    @Override
    public void setCraftingRecipe(boolean craftingMode) {
        this.craftingMode = craftingMode;
    }

    @Override
    public boolean isCraftingRecipe() {
        return this.craftingMode;
    }

    @Override
    public void onChangeCrafting(IAEItemStack[] newCrafting, IAEItemStack[] newOutput) {
        IInventory crafting = this.getInventoryByName("crafting");
        IInventory output = this.getInventoryByName("output");
        if (crafting instanceof AppEngInternalInventory && output instanceof AppEngInternalInventory) {
            IAEItemStack item;
            int x;
            for (x = 0; x < crafting.func_70302_i_() && x < newCrafting.length; ++x) {
                item = newCrafting[x];
                crafting.func_70299_a(x, item == null ? null : item.getItemStack());
            }
            for (x = 0; x < output.func_70302_i_() && x < newOutput.length; ++x) {
                item = newOutput[x];
                output.func_70299_a(x, item == null ? null : item.getItemStack());
            }
        }
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("crafting")) {
            return this.crafting;
        }
        if (name.equals("output")) {
            return this.output;
        }
        if (name.equals("pattern")) {
            return this.pattern;
        }
        return super.getInventoryByName(name);
    }

    @Override
    public void sortCraftingItems() {
        ArrayList<Object> items = new ArrayList<Object>();
        ArrayList<Object> fluids = new ArrayList<Object>();
        for (ItemStack is : this.crafting) {
            if (is == null) continue;
            if (is.func_77973_b() instanceof ItemFluidPacket) {
                fluids.add(is);
                continue;
            }
            items.add(is);
        }
        if (this.prioritize) {
            fluids.addAll(items);
            items.clear();
        } else {
            items.addAll(fluids);
            fluids.clear();
        }
        for (int i = 0; i < this.crafting.func_70302_i_() && this.crafting.func_70301_a(i) != null; ++i) {
            if (items.isEmpty()) {
                this.crafting.func_70299_a(i, (ItemStack)fluids.get(i));
                continue;
            }
            this.crafting.func_70299_a(i, (ItemStack)items.get(i));
        }
        this.saveChanges();
    }

    @Override
    public boolean isAutoFillPattern() {
        return this.autoFillPattern;
    }

    @Override
    public void setAutoFillPattern(boolean canFill) {
        this.autoFillPattern = canFill;
    }

    public PinsHandler getPinsHandler(EntityPlayer player) {
        return this.pinsInv.getHandler(player);
    }

    public IGrid getGrid() {
        return this.getGridNode().getGrid();
    }
}

