/*
 * Decompiled with CFR 0.152.
 */
package rwg.biomes.realistic.savanna;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import net.minecraft.world.gen.feature.WorldGenReed;
import net.minecraft.world.gen.feature.WorldGenShrub;
import rwg.api.RWGBiomes;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.deco.DecoBlob;
import rwg.deco.DecoCacti;
import rwg.deco.DecoFlowers;
import rwg.deco.DecoGrass;
import rwg.deco.trees.DecoJungleTall;
import rwg.deco.trees.DecoSavannah;
import rwg.surface.SurfaceBase;
import rwg.surface.SurfaceDuneValley;
import rwg.terrain.TerrainBase;
import rwg.terrain.TerrainDuneValley;
import rwg.util.CellNoise;
import rwg.util.NoiseGenerator;

public class RealisticBiomeDuneValleyForest
extends RealisticBiomeBase {
    private TerrainBase terrain = new TerrainDuneValley(220.0f);
    private SurfaceBase surface = new SurfaceDuneValley((Block)Blocks.field_150349_c, Blocks.field_150346_d, 220.0f, false, true);

    public RealisticBiomeDuneValleyForest() {
        super(0, RWGBiomes.baseHotForest, RealisticBiomeBase.coastDunes, RWGBiomes.baseRiverOasis);
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, NoiseGenerator perlin, CellNoise cell, float strength, float river) {
        Object worldgenerator;
        int k10;
        int j6;
        int b33;
        int k102;
        int j62;
        int z52;
        float t;
        int j1;
        int i1;
        int k1;
        if (rand.nextInt((int)(2.0f / strength)) == 0 && (k1 = world.func_72976_f(i1 = chunkX + rand.nextInt(16) + 8, j1 = chunkY + rand.nextInt(16) + 8)) < 85) {
            new DecoBlob(Blocks.field_150347_e, 0).func_76484_a(world, rand, i1, k1, j1);
        }
        float f = t = (t = perlin.noise2((float)chunkX / 30.0f, (float)chunkY / 30.0f) * 8.0f) > 4.0f ? 4.0f : t;
        if (t > 0.0f && rand.nextInt((int)((10.0f - t) / strength)) == 0 && (z52 = world.func_72976_f(j62 = chunkX + rand.nextInt(16) + 8, k102 = chunkY + rand.nextInt(16) + 8)) < 82) {
            DecoJungleTall worldgenerator2 = new DecoJungleTall(Blocks.field_150364_r, 2, (Block)Blocks.field_150362_t, 2, 6 + rand.nextInt(4), 3 + rand.nextInt(2), 9.0f + rand.nextFloat() * 4.0f, 3, 0.32f, 0.1f);
            worldgenerator2.func_76487_a(1.0, 1.0, 1.0);
            worldgenerator2.func_76484_a(world, rand, j62, z52, k102);
        }
        if (river > 0.8f) {
            b33 = 0;
            while ((float)b33 < 8.0f * strength) {
                j6 = chunkX + rand.nextInt(16) + 8;
                int z522 = world.func_72976_f(j6, k10 = chunkY + rand.nextInt(16) + 8);
                if (z522 < 82) {
                    worldgenerator = rand.nextInt(2) != 0 ? new WorldGenShrub(0, 0) : new DecoSavannah(1, false);
                    worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                    worldgenerator.func_76484_a(world, rand, j6, z522, k10);
                }
                ++b33;
            }
        } else {
            b33 = 0;
            while ((float)b33 < (1.0f + t) * strength) {
                j6 = chunkX + rand.nextInt(16) + 8;
                int z523 = world.func_72976_f(j6, k10 = chunkY + rand.nextInt(16) + 8);
                if (z523 < 82) {
                    worldgenerator = rand.nextInt(6) != 0 ? new WorldGenShrub(0, 0) : new DecoSavannah(1, false);
                    worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                    worldgenerator.func_76484_a(world, rand, j6, z523, k10);
                }
                ++b33;
            }
        }
        if (rand.nextInt((int)(3.0f / strength)) == 0) {
            int i18 = chunkX + rand.nextInt(16) + 8;
            int i23 = chunkY + rand.nextInt(16) + 8;
            new WorldGenReed().func_76484_a(world, rand, i18, 60 + rand.nextInt(8), i23);
        }
        if (rand.nextInt(28) == 0) {
            int j16 = chunkX + rand.nextInt(16) + 8;
            int j18 = rand.nextInt(128);
            int j21 = chunkY + rand.nextInt(16) + 8;
            new WorldGenPumpkin().func_76484_a(world, rand, j16, j18, j21);
        }
        for (int f23 = 0; f23 < 3; ++f23) {
            int j15 = chunkX + rand.nextInt(16) + 8;
            int j17 = rand.nextInt(128);
            int j20 = chunkY + rand.nextInt(16) + 8;
            new DecoFlowers(new int[]{9, 9, 9, 9, 3, 3, 3, 3, 3, 2, 2, 2, 11, 11, 11}).func_76484_a(world, rand, j15, j17, j20);
        }
        int k18 = 0;
        while ((float)k18 < 26.0f * strength) {
            int k21 = chunkX + rand.nextInt(16) + 8;
            int j23 = 66 + rand.nextInt(20);
            int k24 = chunkY + rand.nextInt(16) + 8;
            new DecoCacti(false).func_76484_a(world, rand, k21, j23, k24);
            ++k18;
        }
        int l14 = 0;
        while ((float)l14 < 8.0f * strength) {
            int l19 = chunkX + rand.nextInt(16) + 8;
            int k22 = 60 + rand.nextInt(40);
            int j24 = chunkY + rand.nextInt(16) + 8;
            if (rand.nextInt(3) == 0) {
                new DecoGrass((Block)Blocks.field_150398_cm, 2).func_76484_a(world, rand, l19, k22, j24);
            } else {
                new DecoGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
            }
            ++l14;
        }
    }

    @Override
    public float rNoise(NoiseGenerator perlin, CellNoise cell, int x, int y, float ocean, float border, float river) {
        return this.terrain.generateNoise(perlin, cell, x, y, ocean, border, river);
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, NoiseGenerator perlin, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        this.surface.paintTerrain(blocks, metadata, i, j, x, y, depth, world, rand, perlin, cell, noise, river, base);
    }
}

