/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.navigator.mixins.late.xaerosworldmap;

import com.gtnewhorizons.navigator.api.NavigatorApi;
import com.gtnewhorizons.navigator.api.model.SupportedMods;
import com.gtnewhorizons.navigator.api.model.buttons.ButtonManager;
import com.gtnewhorizons.navigator.api.model.layers.InteractableLayer;
import com.gtnewhorizons.navigator.api.model.layers.LayerManager;
import com.gtnewhorizons.navigator.api.model.layers.LayerRenderer;
import com.gtnewhorizons.navigator.api.model.layers.UniversalInteractableRenderer;
import com.gtnewhorizons.navigator.api.model.layers.UniversalLayerRenderer;
import com.gtnewhorizons.navigator.api.util.DrawUtils;
import com.gtnewhorizons.navigator.api.xaero.buttons.SizedGuiTexturedButton;
import com.gtnewhorizons.navigator.api.xaero.renderers.XaeroInteractableLayerRenderer;
import com.gtnewhorizons.navigator.api.xaero.renderers.XaeroLayerRenderer;
import com.gtnewhorizons.navigator.api.xaero.rendersteps.XaeroRenderStep;
import com.gtnewhorizons.navigator.internal.SearchBar;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiMap;
import xaero.map.gui.ScreenBase;
import xaero.map.misc.Misc;

@Mixin(value={GuiMap.class}, remap=false)
public abstract class GuiMapMixin
extends ScreenBase {
    @Unique
    private int navigator$oldMouseX = 0;
    @Unique
    private int navigator$oldMouseY = 0;
    @Unique
    private long navigator$timeLastClick = 0L;
    @Unique
    private double navigator$oldCameraX = 0.0;
    @Unique
    private double navigator$oldCameraZ = 0.0;
    @Unique
    private int navigator$oldWidth = 0;
    @Unique
    private int navigator$oldHeight = 0;
    @Unique
    private long navigator$lastRecache = 0L;
    @Shadow
    private double cameraX;
    @Shadow
    private double cameraZ;
    @Shadow
    private double scale;
    @Shadow
    private int screenScale;
    @Shadow
    private int mouseBlockPosX;
    @Shadow
    private int mouseBlockPosZ;
    @Unique
    private SearchBar navigator$searchBar;

    protected GuiMapMixin(GuiScreen parent, GuiScreen escape) {
        super(parent, escape);
    }

    @Shadow
    public abstract void addGuiButton(GuiButton var1);

    @Inject(method={"initGui"}, at={@At(value="RETURN")})
    private void navigator$injectConstruct(CallbackInfo ci) {
        NavigatorApi.getEnabledLayers(SupportedMods.XaeroWorldMap).forEach(layerManager -> {
            layerManager.onGuiOpened(SupportedMods.XaeroWorldMap);
            layerManager.forceRefresh();
        });
        this.navigator$searchBar = new SearchBar(6, this.field_146295_m - 21, Math.min(this.field_146294_l / 2 - 50, 200), 12);
        this.navigator$searchBar.setTextConsumer(text -> NavigatorApi.getEnabledLayers(SupportedMods.XaeroWorldMap).forEach(layerManager -> {
            if (layerManager.isLayerActive() && layerManager.hasSearchField()) {
                layerManager.onSearch((String)text);
            }
        }));
    }

    @Inject(method={"drawScreen"}, at={@At(value="INVOKE", target="Lorg/lwjgl/opengl/GL11;glPushMatrix()V", ordinal=1, remap=false)}, remap=true)
    private void navigator$injectPreRender(int scaledMouseX, int scaledMouseY, float partialTicks, CallbackInfo ci) {
        if (this.field_146297_k.field_71474_y.field_74350_i < 255 || this.field_146297_k.field_71474_y.field_74352_v) {
            this.cameraX = (double)Math.round(this.cameraX * this.scale) / this.scale;
            this.cameraZ = (double)Math.round(this.cameraZ * this.scale) / this.scale;
        }
        double mousePosX = (Misc.getMouseX((Minecraft)this.field_146297_k) - (double)this.field_146297_k.field_71443_c / 2.0) / this.scale;
        double mousePosZ = (Misc.getMouseY((Minecraft)this.field_146297_k) - (double)this.field_146297_k.field_71440_d / 2.0) / this.scale;
        for (LayerRenderer layer : NavigatorApi.getActiveRenderersFor(SupportedMods.XaeroWorldMap)) {
            if (layer instanceof XaeroInteractableLayerRenderer) {
                XaeroInteractableLayerRenderer interactableLayer = (XaeroInteractableLayerRenderer)layer;
                interactableLayer.updateHovered(mousePosX, mousePosZ, this.scale);
                continue;
            }
            if (!(layer instanceof InteractableLayer)) continue;
            InteractableLayer interactableLayer = (InteractableLayer)((Object)layer);
            interactableLayer.onMouseMove((int)mousePosX, (int)mousePosZ);
        }
        this.navigator$searchBar.func_146189_e(false);
    }

    @Inject(method={"drawScreen"}, at={@At(value="INVOKE", target="Lxaero/map/mods/SupportMods;minimap()Z", ordinal=1, remap=false)}, remap=true)
    private void navigator$injectDraw(int scaledMouseX, int scaledMouseY, float partialTicks, CallbackInfo ci, @Local(name={"guiBasedScale"}) float guiBasedScale) {
        Iterator<Object> iterator = NavigatorApi.getEnabledLayers(SupportedMods.XaeroWorldMap).iterator();
        while (iterator.hasNext()) {
            int width = (int)((double)this.field_146297_k.field_71443_c / this.scale) + 20;
            int height = (int)((double)this.field_146297_k.field_71440_d / this.scale) + 20;
            LayerManager layerManager = iterator.next();
            if (!this.navigator$shouldRecache(width, height, layerManager)) continue;
            layerManager.recacheFullscreenMap((int)this.cameraX, (int)this.cameraZ, width, height);
        }
        for (LayerRenderer layer : NavigatorApi.getActiveRenderersByPriority(SupportedMods.XaeroWorldMap)) {
            if (layer instanceof UniversalLayerRenderer) {
                UniversalLayerRenderer universalLayerRenderer = (UniversalLayerRenderer)layer;
                for (XaeroRenderStep xaeroRenderStep : universalLayerRenderer.getRenderSteps()) {
                    xaeroRenderStep.draw(this.cameraX, this.cameraZ, this.scale, guiBasedScale);
                }
                continue;
            }
            if (!(layer instanceof XaeroLayerRenderer)) continue;
            XaeroLayerRenderer xaeroLayerRenderer = (XaeroLayerRenderer)layer;
            for (XaeroRenderStep xaeroRenderStep : xaeroLayerRenderer.getRenderSteps()) {
                xaeroRenderStep.draw((GuiScreen)this, this.cameraX, this.cameraZ, this.scale);
            }
        }
    }

    @Inject(method={"drawScreen"}, at={@At(value="FIELD", opcode=180, target="Lnet/minecraft/client/Minecraft;currentScreen:Lnet/minecraft/client/gui/GuiScreen;", shift=At.Shift.AFTER)}, remap=true)
    private void navigator$injectDrawTooltip(int scaledMouseX, int scaledMouseY, float partialTicks, CallbackInfo ci) {
        for (LayerRenderer layer : NavigatorApi.getActiveRenderersFor(SupportedMods.XaeroWorldMap)) {
            List<String> tooltip;
            InteractableLayer interactableLayer;
            if (layer instanceof XaeroInteractableLayerRenderer) {
                interactableLayer = (XaeroInteractableLayerRenderer)layer;
                tooltip = ((XaeroInteractableLayerRenderer)interactableLayer).getTooltip();
                if (!tooltip.isEmpty()) {
                    DrawUtils.drawSimpleTooltip((GuiScreen)this, tooltip, scaledMouseX + 16, scaledMouseY - 12, -1, -2046820352);
                } else {
                    ((XaeroInteractableLayerRenderer)interactableLayer).drawCustomTooltip((GuiScreen)this, (double)scaledMouseX, (double)scaledMouseY, this.scale, this.screenScale);
                }
                return;
            }
            if (!(layer instanceof InteractableLayer)) continue;
            interactableLayer = (InteractableLayer)((Object)layer);
            tooltip = interactableLayer.getTooltip();
            if (!tooltip.isEmpty()) {
                DrawUtils.drawSimpleTooltip((GuiScreen)this, tooltip, scaledMouseX + 16, scaledMouseY - 12, -1, -2046820352);
                continue;
            }
            interactableLayer.drawCustomTooltip(this.field_146297_k.field_71466_p, scaledMouseX, scaledMouseY, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
        }
        for (LayerManager layerManager : NavigatorApi.getEnabledLayers(SupportedMods.XaeroWorldMap)) {
            if (!layerManager.isLayerActive() || !layerManager.hasSearchField()) continue;
            this.navigator$searchBar.func_146189_e(true);
            this.navigator$searchBar.func_146194_f();
        }
    }

    @Inject(method={"initGui"}, at={@At(value="TAIL")}, remap=true)
    private void navigator$injectInitButtons(CallbackInfo ci) {
        List<ButtonManager> buttons = NavigatorApi.getEnabledButtons(SupportedMods.XaeroWorldMap);
        int numBtns = buttons.size();
        int totalHeight = numBtns * 20;
        for (int i = 0; i < numBtns; ++i) {
            ButtonManager btnManager = buttons.get(i);
            SizedGuiTexturedButton button = new SizedGuiTexturedButton(0, this.field_146295_m / 2 + totalHeight / 2 - 20 - 20 * i, btnManager.getIcon(SupportedMods.XaeroWorldMap, ""), btn -> btnManager.toggle(), new CursorBox(btnManager.getButtonText()));
            btnManager.setOnToggle(button::setActive);
            button.setActive(btnManager.isActive());
            this.addGuiButton((GuiButton)button);
        }
    }

    @Inject(method={"onInputPress"}, at={@At(value="INVOKE", target="Lxaero/map/misc/Misc;inputMatchesKeyBinding(ZILnet/minecraft/client/settings/KeyBinding;)Z", ordinal=1)}, cancellable=true)
    private void navigator$injectListenKeypress(boolean mouse, int code, CallbackInfoReturnable<Boolean> cir) {
        for (LayerRenderer layer : NavigatorApi.getActiveRenderersFor(SupportedMods.XaeroWorldMap)) {
            InteractableLayer interactableLayer;
            if (!(layer instanceof InteractableLayer) || !(interactableLayer = (InteractableLayer)((Object)layer)).onKeyPressed(code)) continue;
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    private void navigator$mouseClicked(int x, int y, int button, CallbackInfo ci) {
        if (this.navigator$searchBar.func_146176_q()) {
            this.navigator$searchBar.func_146192_a(x, y, button);
            if (this.navigator$searchBar.isHovered(x, y)) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"keyTyped"}, at={@At(value="HEAD")}, cancellable=true)
    private void navigator$keyTyped(char par1, int par2, CallbackInfo ci) {
        for (LayerManager layerManager : NavigatorApi.getEnabledLayers(SupportedMods.XaeroWorldMap)) {
            if (!layerManager.isLayerActive() || !layerManager.hasSearchField() || !this.navigator$searchBar.func_146201_a(par1, par2)) continue;
            ci.cancel();
        }
    }

    @Inject(method={"updateScreen"}, at={@At(value="TAIL")}, remap=true)
    private void navigator$updateScreen(CallbackInfo ci) {
        if (this.navigator$searchBar.func_146176_q()) {
            this.navigator$searchBar.func_146178_a();
        }
    }

    @Inject(method={"mapClicked"}, at={@At(value="TAIL")})
    private void navigator$injectListenClick(int button, int x, int y, CallbackInfo ci) {
        if (button != 0) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        boolean isDoubleClick = x == this.navigator$oldMouseX && y == this.navigator$oldMouseY && timestamp - this.navigator$timeLastClick < 250L;
        this.navigator$oldMouseX = x;
        this.navigator$oldMouseY = y;
        this.navigator$timeLastClick = timestamp;
        for (LayerRenderer layer : NavigatorApi.getActiveRenderersFor(SupportedMods.XaeroWorldMap)) {
            UniversalInteractableRenderer universal;
            if (layer instanceof UniversalInteractableRenderer && (universal = (UniversalInteractableRenderer)layer).onMapClick(isDoubleClick, x, y, this.mouseBlockPosX, this.mouseBlockPosZ) || !(layer instanceof XaeroInteractableLayerRenderer)) continue;
            XaeroInteractableLayerRenderer interactableLayer = (XaeroInteractableLayerRenderer)layer;
            interactableLayer.onMapClick(isDoubleClick, x, y, this.mouseBlockPosX, this.mouseBlockPosZ);
        }
    }

    @Inject(method={"onGuiClosed"}, at={@At(value="RETURN")}, remap=true)
    private void navigator$onGuiClosed(CallbackInfo ci) {
        NavigatorApi.getEnabledLayers(SupportedMods.XaeroWorldMap).forEach(layerManager -> layerManager.onGuiClosed(SupportedMods.XaeroWorldMap));
    }

    @Unique
    private boolean navigator$shouldRecache(int width, int height, LayerManager manager) {
        if (!manager.isLayerActive()) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (this.navigator$oldCameraX != this.cameraX || this.navigator$oldCameraZ != this.cameraZ || this.navigator$oldWidth != width || this.navigator$oldHeight != height || manager.forceRefresh || now - this.navigator$lastRecache >= 1000L) {
            this.navigator$oldCameraX = this.cameraX;
            this.navigator$oldCameraZ = this.cameraZ;
            this.navigator$oldWidth = width;
            this.navigator$oldHeight = height;
            this.navigator$lastRecache = now;
            return true;
        }
        return false;
    }

    public boolean func_73868_f() {
        return false;
    }
}

