/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.network.message;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import shedar.mods.ic2.nuclearcontrol.containers.ContainerAdvancedInfoPanel;
import shedar.mods.ic2.nuclearcontrol.containers.ContainerInfoPanel;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityAdvancedInfoPanel;
import shedar.mods.ic2.nuclearcontrol.utils.DataSorter;

public class PacketDataSorter
implements IMessage,
IMessageHandler<PacketDataSorter, IMessage> {
    private int x;
    private int y;
    private int z;
    private byte slot;
    private DataSorter sorter;

    public PacketDataSorter() {
    }

    public PacketDataSorter(TileEntityAdvancedInfoPanel panel, byte slot, DataSorter sorter) {
        this.x = panel.field_145851_c;
        this.y = panel.field_145848_d;
        this.z = panel.field_145849_e;
        this.slot = slot;
        this.sorter = sorter;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.slot = buf.readByte();
        int length = buf.readableBytes() / 4;
        int[] intArray = new int[length];
        int i = 0;
        while (buf.readableBytes() > 0) {
            intArray[i] = buf.readInt();
            ++i;
        }
        this.sorter = new DataSorter(intArray);
    }

    public void toBytes(ByteBuf buf) {
        int[] intArray;
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeByte((int)this.slot);
        for (int j : intArray = this.sorter.getArray()) {
            buf.writeInt(j);
        }
    }

    public IMessage onMessage(PacketDataSorter message, MessageContext ctx) {
        if (ctx.side == Side.SERVER) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Container openContainer = player.field_71070_bA;
            if (openContainer instanceof ContainerInfoPanel) {
                int x = message.x;
                int y = message.y;
                int z = message.z;
                TileEntityAdvancedInfoPanel panel = (TileEntityAdvancedInfoPanel)((ContainerAdvancedInfoPanel)openContainer).panel;
                if (panel != null && panel.field_145851_c == x && panel.field_145848_d == y && panel.field_145849_e == z && panel == player.field_70170_p.func_147438_o(x, y, z)) {
                    panel.setDataSorter(message.slot, message.sorter, false);
                }
            }
        } else if (ctx.side == Side.CLIENT) {
            TileEntity tileEntity = FMLClientHandler.instance().getClient().field_71441_e.func_147438_o(message.x, message.y, message.z);
            if (tileEntity == null || !(tileEntity instanceof TileEntityAdvancedInfoPanel)) {
                return null;
            }
            TileEntityAdvancedInfoPanel panel = (TileEntityAdvancedInfoPanel)tileEntity;
            panel.setDataSorter(message.slot, message.sorter, false);
        }
        return null;
    }
}

