/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import com.enderio.core.api.client.render.IRenderFace;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.CubeRenderer;
import com.enderio.core.client.render.CustomCubeRenderer;
import com.enderio.core.client.render.CustomRenderBlocks;
import com.enderio.core.client.render.IconUtil;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.vecmath.Vertex;
import com.gtnewhorizons.angelica.api.ThreadSafeISBRH;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.OverlayRenderer;
import crazypants.enderio.machine.painter.IPaintableTileEntity;
import crazypants.enderio.machine.painter.PaintedBlockRenderer;
import crazypants.enderio.machine.painter.PainterUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;

@ThreadSafeISBRH(perThread=true)
public class AbstractMachineRenderer
implements ISimpleBlockRenderingHandler,
IItemRenderer {
    private OverlayRenderer overlayRenderer = new OverlayRenderer(){

        @Override
        public void renderFace(CustomRenderBlocks rb, ForgeDirection face, Block par1Block, double x, double y, double z, IIcon texture, List<Vertex> refVertices, boolean translateToXyz) {
            AbstractMachineRenderer.this.ccr.getCustomRenderBlocks().doDefaultRenderFace(face, par1Block, x, y, z, texture);
            super.renderFace(rb, face, par1Block, x, y, z, texture, refVertices, translateToXyz);
        }
    };
    private CustomCubeRenderer ccr = new CustomCubeRenderer();
    private final PaintedBlockRenderer paintedRenderer = new PaintedBlockRenderer(this.getRenderId(), null);

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        Block block = PainterUtil.getSourceBlock(item);
        if (block != null) {
            this.paintedRenderer.renderInventoryBlock(block, PainterUtil.getSourceBlockMetadata(item), 0, (RenderBlocks)data[0]);
        } else {
            this.renderInventoryBlock(Block.func_149634_a((Item)item.func_77973_b()), item.func_77960_j(), 0, (RenderBlocks)data[0]);
        }
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        BoundingBox bb = BoundingBox.UNIT_CUBE;
        bb = bb.translate(0.0f, -0.1f, 0.0f);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        IIcon[] textures = RenderUtil.getBlockTextures((Block)block, (int)metadata);
        float[] brightnessPerSide = new float[6];
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            brightnessPerSide[dir.ordinal()] = Math.max(RenderUtil.getColorMultiplierForFace((ForgeDirection)dir) + 0.1f, 1.0f);
        }
        CubeRenderer.get().render(bb, textures, null, brightnessPerSide);
        tessellator.func_78381_a();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntity te = world.func_147438_o(x, y, z);
        AbstractMachineEntity machine = null;
        if (te instanceof AbstractMachineEntity) {
            machine = (AbstractMachineEntity)te;
        }
        this.overlayRenderer.setTile(machine);
        if (te instanceof IPaintableTileEntity && ((IPaintableTileEntity)te).getSourceBlock() != null) {
            this.ccr.setOverrideTexture(IconUtil.blankTexture);
            this.ccr.renderBlock(world, block, x, y, z, (IRenderFace)this.overlayRenderer);
            this.ccr.setOverrideTexture(renderer.field_147840_d);
            this.paintedRenderer.renderWorldBlock(world, x, y, z, block, modelId, renderer);
        } else {
            this.ccr.setOverrideTexture(renderer.field_147840_d);
            this.ccr.renderBlock(world, block, x, y, z, (IRenderFace)this.overlayRenderer);
        }
        this.ccr.setOverrideTexture(null);
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return AbstractMachineBlock.renderId;
    }
}

