/*
 * Decompiled with CFR 0.152.
 */
package emt.item.focus;

import emt.item.focus.ItemBaseFocus;
import emt.util.EMTConfigHandler;
import ic2.api.item.ElectricItem;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.common.items.wands.ItemWandCasting;

public class ItemWandChargingFocus
extends ItemBaseFocus {
    AspectList visCost = new AspectList().add(Aspect.FIRE, 10).add(Aspect.WATER, 10).add(Aspect.AIR, 10).add(Aspect.EARTH, 10).add(Aspect.ORDER, 10).add(Aspect.ENTROPY, 10);

    public ItemWandChargingFocus() {
        super("chargeWand");
    }

    public int getFocusColor(ItemStack stack) {
        return 268432464;
    }

    public String getSortingHelper(ItemStack itemstack) {
        return "ELECTRICCHARGING" + super.getSortingHelper(itemstack);
    }

    public boolean isVisCostPerTick(ItemStack focusstack) {
        return true;
    }

    @Override
    public AspectList getVisCost(ItemStack stack) {
        AspectList actualCost = new AspectList();
        for (Map.Entry e : this.visCost.aspects.entrySet()) {
            actualCost.add((Aspect)e.getKey(), (int)((double)((Integer)e.getValue()).intValue() * Math.pow(1.1, this.getUpgradeLevel(stack, FocusUpgradeType.potency))));
        }
        return actualCost;
    }

    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack focusstack, int rank) {
        return new FocusUpgradeType[]{FocusUpgradeType.potency, FocusUpgradeType.frugal};
    }

    @Override
    public void onUsingFocusTick(ItemStack itemstack, EntityPlayer player, int integer) {
        if (!player.field_70170_p.field_72995_K) {
            ItemWandCasting wandItem = (ItemWandCasting)itemstack.func_77973_b();
            if (this.wandIsFull(itemstack, wandItem)) {
                return;
            }
            int cost = this.getCost(itemstack) / 4;
            for (ItemStack stack : player.field_71071_by.field_70460_b) {
                if (stack != null && !(ElectricItem.manager.getCharge(stack) < (double)cost)) continue;
                return;
            }
            for (ItemStack stack : player.field_71071_by.field_70460_b) {
                ElectricItem.manager.use(stack, (double)cost, (EntityLivingBase)player);
            }
            int amount = (int)(100.0 * Math.pow(1.1, this.getUpgradeLevel(itemstack, FocusUpgradeType.potency)));
            wandItem.addRealVis(itemstack, Aspect.ORDER, amount, true);
            wandItem.addRealVis(itemstack, Aspect.FIRE, amount, true);
            wandItem.addRealVis(itemstack, Aspect.ENTROPY, amount, true);
            wandItem.addRealVis(itemstack, Aspect.WATER, amount, true);
            wandItem.addRealVis(itemstack, Aspect.EARTH, amount, true);
            wandItem.addRealVis(itemstack, Aspect.AIR, amount, true);
        }
    }

    private boolean wandIsFull(ItemStack itemstack, ItemWandCasting wandItem) {
        int size = wandItem.getMaxVis(itemstack);
        for (Aspect a : Aspect.getPrimalAspects()) {
            if (wandItem.getVis(itemstack, a) >= size) continue;
            return false;
        }
        return true;
    }

    private int getCost(ItemStack stack) {
        return (int)((double)EMTConfigHandler.wandChargeFocusCost * (1.0 - 0.1 * (double)this.getUpgradeLevel(stack, FocusUpgradeType.frugal)));
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(StatCollector.func_74838_a((String)"item.EMT.focus.EU.cost.info"));
        list.add(StatCollector.func_74837_a((String)"item.EMT.focus.EU.cost.tick", (Object[])new Object[]{this.getCost(stack)}));
        super.func_77624_a(stack, player, list, par4);
    }
}

