/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.components;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import vswe.stevesfactory.Localization;
import vswe.stevesfactory.components.ComponentMenuStuff;
import vswe.stevesfactory.components.FlowComponent;
import vswe.stevesfactory.components.LiquidSetting;
import vswe.stevesfactory.components.Setting;
import vswe.stevesfactory.components.TextBoxNumber;
import vswe.stevesfactory.interfaces.GuiManager;
import vswe.stevesfactory.network.DataBitHelper;
import vswe.stevesfactory.network.DataReader;
import vswe.stevesfactory.network.DataWriter;

public class ComponentMenuLiquid
extends ComponentMenuStuff {
    private TextBoxNumber amountTextBoxBuckets = new TextBoxNumber(10, 50, 3, true){

        @Override
        public boolean isVisible() {
            return ComponentMenuLiquid.this.selectedSetting.isLimitedByAmount();
        }

        @Override
        public void onNumberChanged() {
            ComponentMenuLiquid.this.sendAmountData();
        }
    };
    private TextBoxNumber amountTextBoxMilli;

    public ComponentMenuLiquid(FlowComponent parent) {
        super(parent, LiquidSetting.class);
        this.numberTextBoxes.addTextBox(this.amountTextBoxBuckets);
        this.amountTextBoxMilli = new TextBoxNumber(60, 50, 3, true){

            @Override
            public boolean isVisible() {
                return ComponentMenuLiquid.this.selectedSetting.isLimitedByAmount();
            }

            @Override
            public void onNumberChanged() {
                ComponentMenuLiquid.this.sendAmountData();
            }
        };
        this.numberTextBoxes.addTextBox(this.amountTextBoxMilli);
    }

    private void sendAmountData() {
        this.selectedSetting.setAmount(this.amountTextBoxBuckets.getNumber() * 1000 + this.amountTextBoxMilli.getNumber());
        this.writeServerData(ComponentMenuStuff.DataTypeHeader.AMOUNT);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void drawInfoMenuContent(GuiManager gui, int mX, int mY) {
        if (this.selectedSetting.isLimitedByAmount()) {
            gui.drawCenteredString(Localization.BUCKETS.toString(), this.amountTextBoxBuckets.getX(), this.amountTextBoxBuckets.getY() - 7, 0.7f, this.amountTextBoxBuckets.getWidth(), 0x404040);
            gui.drawCenteredString(Localization.MILLI_BUCKETS.toString(), this.amountTextBoxMilli.getX(), this.amountTextBoxMilli.getY() - 7, 0.55f, this.amountTextBoxMilli.getWidth(), 0x404040);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void drawResultObject(GuiManager gui, Object obj, int x, int y) {
        gui.drawFluid((Fluid)obj, x, y);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void drawSettingObject(GuiManager gui, Setting setting, int x, int y) {
        this.drawResultObject(gui, ((LiquidSetting)setting).getFluid(), x, y);
    }

    @Override
    protected List<String> getResultObjectMouseOver(Object obj) {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(ComponentMenuLiquid.getDisplayName((Fluid)obj));
        return ret;
    }

    @Override
    protected List<String> getSettingObjectMouseOver(Setting setting) {
        return this.getResultObjectMouseOver(((LiquidSetting)setting).getFluid());
    }

    @Override
    protected void updateTextBoxes() {
        int amount = this.selectedSetting.getAmount();
        this.amountTextBoxBuckets.setNumber(amount / 1000);
        this.amountTextBoxMilli.setNumber(amount % 1000);
    }

    @Override
    protected DataBitHelper getAmountBitLength() {
        return DataBitHelper.MENU_LIQUID_AMOUNT;
    }

    @Override
    protected void readSpecificHeaderData(DataReader dr, ComponentMenuStuff.DataTypeHeader header, Setting setting) {
        LiquidSetting liquidSetting = (LiquidSetting)setting;
        switch (header) {
            case SET_ITEM: {
                liquidSetting.setLiquidFromId(dr.readData(DataBitHelper.MENU_FLUID_ID));
                if (!this.isEditing()) break;
                this.updateTextBoxes();
            }
        }
    }

    @Override
    protected void writeSpecificHeaderData(DataWriter dw, ComponentMenuStuff.DataTypeHeader header, Setting setting) {
        LiquidSetting liquidSetting = (LiquidSetting)setting;
        switch (header) {
            case SET_ITEM: {
                dw.writeData(liquidSetting.getLiquidId(), DataBitHelper.MENU_FLUID_ID);
            }
        }
    }

    @Override
    public String getName() {
        return Localization.LIQUIDS_MENU.toString();
    }

    protected LiquidSetting getSelectedSetting() {
        return (LiquidSetting)this.selectedSetting;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected List updateSearch(String search, boolean showAll) {
        ArrayList ret = new ArrayList(FluidRegistry.getRegisteredFluids().values());
        Iterator itemIterator = ret.iterator();
        if (!showAll) {
            while (itemIterator.hasNext()) {
                Fluid fluid = (Fluid)itemIterator.next();
                if (ComponentMenuLiquid.getDisplayName(fluid).toLowerCase().contains(search)) continue;
                itemIterator.remove();
            }
        }
        return ret;
    }

    public static String getDisplayName(Fluid fluid) {
        String name = fluid.getLocalizedName();
        if (name.contains(".")) {
            name = FluidRegistry.getFluidName((Fluid)fluid);
        }
        return name;
    }
}

