/*
 * Decompiled with CFR 0.152.
 */
package com.projecturanus.betterp2p.network.data;

import appeng.api.networking.IGridNode;
import appeng.me.GridNode;
import appeng.parts.p2p.PartP2PTunnel;
import com.projecturanus.betterp2p.network.data.P2PInfo;
import com.projecturanus.betterp2p.util.p2p.P2PUtilKt;
import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u000e\u0010\u0007\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\b\u00a8\u0006\t"}, d2={"readP2PInfo", "Lcom/projecturanus/betterp2p/network/data/P2PInfo;", "buf", "Lio/netty/buffer/ByteBuf;", "writeP2PInfo", "", "info", "toInfo", "Lappeng/parts/p2p/PartP2PTunnel;", "betterp2p"})
public final class P2PInfoKt {
    @Nullable
    public static final P2PInfo readP2PInfo(@NotNull ByteBuf buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        try {
            long freq = buf.readLong();
            int posX = buf.readInt();
            int posY = buf.readInt();
            int posZ = buf.readInt();
            int world = buf.readInt();
            ForgeDirection facing = ForgeDirection.values()[buf.readInt()];
            int nameLength = buf.readShort() - 1;
            StringBuilder name = new StringBuilder();
            int i = 0;
            if (i <= nameLength) {
                while (true) {
                    name.append(buf.readChar());
                    if (i == nameLength) break;
                    ++i;
                }
            }
            boolean output = buf.readBoolean();
            boolean hasChannel = buf.readBoolean();
            byte channels = buf.readByte();
            byte type = buf.readByte();
            String string = name.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return new P2PInfo(freq, posX, posY, posZ, world, facing, string, output, hasChannel, channels, type);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static final void writeP2PInfo(@NotNull ByteBuf buf, @NotNull P2PInfo info2) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        buf.writeLong(info2.getFrequency());
        buf.writeInt(info2.getPosX());
        buf.writeInt(info2.getPosY());
        buf.writeInt(info2.getPosZ());
        buf.writeInt(info2.getDim());
        buf.writeInt(info2.getFacing().ordinal());
        buf.writeShort(info2.getName().length());
        String string = info2.getName();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            buf.writeChar((int)c);
        }
        buf.writeBoolean(info2.getOutput());
        buf.writeBoolean(info2.getHasChannel());
        buf.writeByte(info2.getChannels());
        buf.writeByte(info2.getType());
    }

    @NotNull
    public static final P2PInfo toInfo(@NotNull PartP2PTunnel<?> $this$toInfo) {
        Intrinsics.checkNotNullParameter($this$toInfo, (String)"<this>");
        long l = $this$toInfo.getFrequency();
        int n = $this$toInfo.getLocation().x;
        int n2 = $this$toInfo.getLocation().y;
        int n3 = $this$toInfo.getLocation().z;
        int n4 = $this$toInfo.getLocation().getDimension();
        ForgeDirection forgeDirection = $this$toInfo.getSide();
        Intrinsics.checkNotNullExpressionValue((Object)forgeDirection, (String)"getSide(...)");
        String string = $this$toInfo.getCustomName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCustomName(...)");
        IGridNode iGridNode = $this$toInfo.getExternalFacingNode();
        GridNode gridNode = iGridNode instanceof GridNode ? (GridNode)iGridNode : null;
        return new P2PInfo(l, n, n2, n3, n4, forgeDirection, string, $this$toInfo.isOutput(), P2PUtilKt.getHasChannel($this$toInfo), gridNode != null ? gridNode.usedChannels() : -1, P2PUtilKt.getTypeIndex($this$toInfo));
    }
}

