/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.tiles;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tuhljin.automagy.items.InventoryWithFilterOptions;
import tuhljin.automagy.items.ItemEnchantedPaper;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.lib.inventory.HashableItemWithoutSize;
import tuhljin.automagy.tiles.InventoryObjectFilter;
import tuhljin.automagy.tiles.ModTileEntityWithInventory;

public class ModTileEntityWithFilterMainInventory
extends ModTileEntityWithInventory {
    protected InventoryWithFilterOptions filter = null;
    protected boolean filterIsBlacklist;
    protected Pattern filterNamePattern;

    public ModTileEntityWithFilterMainInventory(String inventoryName, boolean createDefaultAccessibleSlots) {
        super(inventoryName, 1, createDefaultAccessibleSlots);
        this.notifyOnInventoryChanged = true;
    }

    public ModTileEntityWithFilterMainInventory(String inventoryName) {
        this(inventoryName, true);
    }

    public boolean nameFilterMatches(ItemStack stack) {
        if (this.filterNamePattern != null) {
            String name = stack.func_82833_r().toLowerCase();
            Matcher m = this.filterNamePattern.matcher(name);
            return m.matches();
        }
        return false;
    }

    public boolean nameFilterMatches(HashableItemWithoutSize item) {
        if (this.filterNamePattern == null) {
            return false;
        }
        return this.nameFilterMatches(item.getItemStack(1));
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        return InventoryObjectFilter.isItemPopulatedFilter(stack);
    }

    @Override
    public void onInventoryChanged(int slot, ItemStack prevStack) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack == null) {
            this.filter = null;
        } else {
            this.filter = this.getFilterFromStack(stack);
            if (this.filter != null) {
                this.filterIsBlacklist = ItemEnchantedPaper.stackIsBlacklist(stack);
                this.filterNamePattern = this.filter.nameFilter.isEmpty() ? null : TjUtil.getSafePatternUsingAsteriskForWildcard(this.filter.nameFilter.toLowerCase());
            }
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        super.readCustomNBT(nbttagcompound);
        ItemStack filterStack = this.func_70301_a(0);
        if (filterStack == null) {
            this.filter = null;
        } else {
            this.filter = this.getFilterFromStack(filterStack);
            if (this.filter != null) {
                this.filterIsBlacklist = ItemEnchantedPaper.stackIsBlacklist(filterStack);
                this.filterNamePattern = this.filter.nameFilter.isEmpty() ? null : TjUtil.getSafePatternUsingAsteriskForWildcard(this.filter.nameFilter.toLowerCase());
            }
        }
    }

    public InventoryWithFilterOptions getFilterFromStack(ItemStack stack) {
        return ItemEnchantedPaper.getFilterInventory(stack);
    }
}

