/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.net;

import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import net.minecraft.entity.player.EntityPlayerMP;
import serverutils.lib.net.MessageBase;
import serverutils.lib.util.ServerUtils;

public abstract class MessageToClient
extends MessageBase {
    public final void sendTo(EntityPlayerMP player) {
        if (ServerUtils.isFake(player)) {
            return;
        }
        FMLEmbeddedChannel channel = this.getWrapper().getChannel(Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        channel.writeAndFlush((Object)this).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public final void sendTo(Iterable<EntityPlayerMP> players) {
        for (EntityPlayerMP playerMP : players) {
            this.sendTo(playerMP);
        }
    }

    public final void sendToAll() {
        FMLEmbeddedChannel channel = this.getWrapper().getChannel(Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        channel.writeAndFlush((Object)this).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public final void sendToDimension(int dim) {
        FMLEmbeddedChannel channel = this.getWrapper().getChannel(Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dim);
        channel.writeAndFlush((Object)this).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public final void sendToAllAround(int dim, int posx, int posy, int posz, double range) {
        FMLEmbeddedChannel channel = this.getWrapper().getChannel(Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)new NetworkRegistry.TargetPoint(dim, (double)posx + 0.5, (double)posy + 0.5, (double)posz + 0.5, range));
        channel.writeAndFlush((Object)this).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public final void sendToAllTracking(NetworkRegistry.TargetPoint pos) {
        FMLEmbeddedChannel channel = this.getWrapper().getChannel(Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)pos);
        channel.writeAndFlush((Object)this).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public final void sendToAllTracking(int dim, double x, double y, double z) {
        this.sendToAllTracking(new NetworkRegistry.TargetPoint(dim, x, y, z, 0.0));
    }

    @SideOnly(value=Side.CLIENT)
    public void onMessage() {
    }
}

