/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.command;

import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesConfig;
import serverutils.ServerUtilitiesNotifications;
import serverutils.lib.command.CmdBase;
import serverutils.lib.config.ConfigGroup;
import serverutils.lib.config.ConfigValue;
import serverutils.lib.config.ConfigValueInstance;
import serverutils.lib.config.IConfigCallback;
import serverutils.lib.data.ServerUtilitiesAPI;
import serverutils.lib.util.StringUtils;

public abstract class CmdEditConfigBase
extends CmdBase {
    public CmdEditConfigBase(String n, CmdBase.Level l) {
        super(n, l);
    }

    public abstract ConfigGroup getGroup(ICommandSender var1) throws CommandException;

    public IConfigCallback getCallback(ICommandSender sender) throws CommandException {
        return IConfigCallback.DEFAULT;
    }

    @Override
    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        try {
            ConfigGroup group = this.getGroup(sender);
            if (args.length == 1) {
                List keys = CmdEditConfigBase.func_71531_a((String[])args, group.getValueKeyTree());
                if (keys.size() > 1) {
                    keys.sort(StringUtils.ID_COMPARATOR);
                }
                return keys;
            }
            if (args.length == 2) {
                List<String> variants;
                ConfigValue value = group.getValue(args[0]);
                if (!value.isNull() && !(variants = value.getVariants()).isEmpty()) {
                    return CmdEditConfigBase.func_71531_a((String[])args, variants);
                }
                return Collections.emptyList();
            }
        }
        catch (CommandException commandException) {
            // empty catch block
        }
        return super.func_71516_a(sender, args);
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0 && sender instanceof EntityPlayerMP) {
            ServerUtilitiesAPI.editServerConfig(CmdEditConfigBase.func_71521_c((ICommandSender)sender), this.getGroup(sender), this.getCallback(sender));
            return;
        }
        this.checkArgs(sender, args, 1);
        ConfigGroup group = this.getGroup(sender);
        ConfigValueInstance instance = group.getValueInstance(args[0]);
        if (instance == null) {
            throw ServerUtilities.error(sender, "serverutilities.lang.config_command.invalid_key", args[0]);
        }
        if (args.length >= 2) {
            String valueString = StringUtils.joinSpaceUntilEnd(1, args);
            if (!instance.getValue().setValueFromString(sender, valueString, true)) {
                return;
            }
            if (ServerUtilitiesConfig.debugging.log_config_editing) {
                ServerUtilities.LOGGER.info("Setting {} to {}", new Object[]{instance.getPath(), valueString});
            }
            instance.getValue().setValueFromString(sender, valueString, false);
            this.getCallback(sender).onConfigSaved(group, sender);
            ServerUtilitiesNotifications.CONFIG_CHANGED.send((EntityPlayer)CmdEditConfigBase.func_71521_c((ICommandSender)sender), "serverutilities.lang.config_command.set", instance.getDisplayName(), group.getValue(args[0]).toString());
        }
        sender.func_145747_a(instance.getValue().getStringForGUI());
    }
}

