/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.client.rendering;

import com.creativemd.creativecore.client.rendering.ExtendedRenderBlocks;
import com.creativemd.creativecore.common.utils.CubeObject;
import com.creativemd.creativecore.common.utils.RotationUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemCloth;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderHelper3D {
    public static Minecraft mc = Minecraft.func_71410_x();
    public static RenderBlocks renderer = RenderBlocks.getInstance();
    public static ExtendedRenderBlocks renderBlocks = new ExtendedRenderBlocks(renderer);
    public static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");

    public static void renderBlock(double x, double y, double z, double width, double height, double length, double rotateX, double rotateY, double rotateZ, double red, double green, double blue, double alpha) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glEnable((int)32826);
        GL11.glRotated((double)rotateX, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)rotateY, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)rotateZ, (double)0.0, (double)0.0, (double)1.0);
        GL11.glScaled((double)width, (double)height, (double)length);
        GL11.glColor4d((double)red, (double)green, (double)blue, (double)alpha);
        GL11.glBegin((int)9);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)-0.5f, (float)0.5f, (float)0.5f);
        GL11.glVertex3f((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glVertex3f((float)0.5f, (float)0.5f, (float)-0.5f);
        GL11.glVertex3f((float)-0.5f, (float)0.5f, (float)-0.5f);
        GL11.glEnd();
        GL11.glBegin((int)9);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)0.5f, (float)-0.5f, (float)0.5f);
        GL11.glVertex3f((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glVertex3f((float)-0.5f, (float)0.5f, (float)0.5f);
        GL11.glVertex3f((float)-0.5f, (float)-0.5f, (float)0.5f);
        GL11.glEnd();
        GL11.glBegin((int)9);
        GL11.glNormal3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.5f, (float)0.5f, (float)-0.5f);
        GL11.glVertex3f((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glVertex3f((float)0.5f, (float)-0.5f, (float)0.5f);
        GL11.glVertex3f((float)0.5f, (float)-0.5f, (float)-0.5f);
        GL11.glEnd();
        GL11.glBegin((int)9);
        GL11.glNormal3f((float)-1.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)-0.5f, (float)-0.5f, (float)0.5f);
        GL11.glVertex3f((float)-0.5f, (float)0.5f, (float)0.5f);
        GL11.glVertex3f((float)-0.5f, (float)0.5f, (float)-0.5f);
        GL11.glVertex3f((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GL11.glEnd();
        GL11.glBegin((int)9);
        GL11.glNormal3f((float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glVertex3f((float)0.5f, (float)-0.5f, (float)0.5f);
        GL11.glVertex3f((float)-0.5f, (float)-0.5f, (float)0.5f);
        GL11.glVertex3f((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GL11.glVertex3f((float)0.5f, (float)-0.5f, (float)-0.5f);
        GL11.glEnd();
        GL11.glBegin((int)9);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
        GL11.glVertex3f((float)0.5f, (float)0.5f, (float)-0.5f);
        GL11.glVertex3f((float)0.5f, (float)-0.5f, (float)-0.5f);
        GL11.glVertex3f((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GL11.glVertex3f((float)-0.5f, (float)0.5f, (float)-0.5f);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public static void renderBlock(Block block, double x, double y, double z, double width, double height, double length, double rotateX, double rotateY, double rotateZ) {
        RenderHelper3D.renderBlock(block, x, y, z, width, height, length, rotateX, rotateY, rotateZ, ForgeDirection.EAST);
    }

    public static void renderBlock(Block block, double x, double y, double z, double width, double height, double length, double rotateX, double rotateY, double rotateZ, ForgeDirection direction) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        RenderHelper3D.applyDirection(direction);
        GL11.glEnable((int)32826);
        GL11.glRotated((double)rotateX, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)rotateY, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)rotateZ, (double)0.0, (double)0.0, (double)1.0);
        GL11.glScaled((double)width, (double)height, (double)length);
        RenderHelper3D.renderBlock(block);
        GL11.glPopMatrix();
    }

    public static void renderBlock(Block block, double sizeX, double sizeY, double sizeZ) {
        RenderHelper3D.renderBlock(block, sizeX, sizeY, sizeZ, 0);
    }

    public static void renderBlock(Block block, double sizeX, double sizeY, double sizeZ, int meta) {
        int blocksX = (int)Math.ceil(sizeX / 1.0);
        int blocksY = (int)Math.ceil(sizeY / 1.0);
        int blocksZ = (int)Math.ceil(sizeZ / 1.0);
        GL11.glTranslated((double)(-sizeX / 2.0 + 0.5), (double)(-sizeY / 2.0 + 0.5), (double)(-sizeZ / 2.0 + 0.5));
        boolean shouldX = false;
        boolean shouldY = false;
        boolean shouldZ = false;
        for (int blockX = 0; blockX < blocksX; ++blockX) {
            for (int blockY = 0; blockY < blocksY; ++blockY) {
                for (int blockZ = 0; blockZ < blocksZ && (blockX <= 0 || blockX >= blocksX - 1 || blockY <= 0 || blockY >= blocksY - 1 || blockZ <= 0 || blockZ >= blocksZ - 1); ++blockZ) {
                    double boundX = 1.0;
                    if (blockX == blocksX - 1) {
                        boundX = sizeX - (double)blockX;
                    }
                    double boundY = 1.0;
                    if (blockY == blocksY - 1) {
                        boundY = sizeY - (double)blockY;
                    }
                    double boundZ = 1.0;
                    if (blockZ == blocksZ - 1) {
                        boundZ = sizeZ - (double)blockZ;
                    }
                    boolean moveX = true;
                    if (!shouldX) {
                        moveX = false;
                    }
                    boolean moveY = true;
                    if (!shouldY) {
                        moveY = false;
                    }
                    boolean moveZ = true;
                    if (!shouldZ) {
                        moveZ = false;
                    }
                    GL11.glTranslated((double)((double)moveX), (double)((double)moveY), (double)((double)moveZ));
                    GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
                    renderer.func_147782_a(0.0, 0.0, 0.0, boundX, boundY, boundZ);
                    RenderHelper3D.renderer.field_147847_n = true;
                    RenderHelper3D.renderBlock(block, meta);
                    RenderHelper3D.renderer.field_147847_n = false;
                    shouldX = false;
                    shouldY = false;
                    shouldZ = true;
                }
                GL11.glTranslated((double)0.0, (double)0.0, (double)(-(blocksZ - 1)));
                shouldZ = false;
                shouldY = true;
            }
            GL11.glTranslated((double)0.0, (double)(-(blocksY - 1)), (double)0.0);
            shouldY = false;
            shouldX = true;
        }
    }

    public static void renderBlock(Block block) {
        RenderHelper3D.renderBlock(block, 0);
    }

    public static void renderBlock(Block block, int meta) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        RenderHelper3D.renderer.field_147844_c = false;
        float f5 = 1.0f;
        renderer.func_147800_a(block, meta, f5);
    }

    public static void applyBlockRotation(RenderBlocks renderer, ForgeDirection direction) {
        double minX = renderer.field_147859_h - 0.5;
        double minY = renderer.field_147855_j - 0.5;
        double minZ = renderer.field_147851_l - 0.5;
        double maxX = renderer.field_147861_i - 0.5;
        double maxY = renderer.field_147857_k - 0.5;
        double maxZ = renderer.field_147853_m - 0.5;
        Vec3 min = RotationUtils.applyVectorRotation(Vec3.func_72443_a((double)minX, (double)minY, (double)minZ), direction);
        Vec3 max = RotationUtils.applyVectorRotation(Vec3.func_72443_a((double)maxX, (double)maxY, (double)maxZ), direction);
        min = min.func_72441_c(0.5, 0.5, 0.5);
        max = max.func_72441_c(0.5, 0.5, 0.5);
        if (min.field_72450_a < max.field_72450_a) {
            renderer.field_147859_h = min.field_72450_a;
            renderer.field_147861_i = max.field_72450_a;
        } else {
            renderer.field_147859_h = max.field_72450_a;
            renderer.field_147861_i = min.field_72450_a;
        }
        if (min.field_72448_b < max.field_72448_b) {
            renderer.field_147855_j = min.field_72448_b;
            renderer.field_147857_k = max.field_72448_b;
        } else {
            renderer.field_147855_j = max.field_72448_b;
            renderer.field_147857_k = min.field_72448_b;
        }
        if (min.field_72449_c < max.field_72449_c) {
            renderer.field_147851_l = min.field_72449_c;
            renderer.field_147853_m = max.field_72449_c;
        } else {
            renderer.field_147851_l = max.field_72449_c;
            renderer.field_147853_m = min.field_72449_c;
        }
    }

    public static void applyDirection(ForgeDirection direction) {
        int rotation = 0;
        switch (direction) {
            case EAST: {
                rotation = 0;
                break;
            }
            case NORTH: {
                rotation = 90;
                break;
            }
            case SOUTH: {
                rotation = 270;
                break;
            }
            case WEST: {
                rotation = 180;
                break;
            }
            case UP: {
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)-90.0, (double)0.0, (double)0.0, (double)1.0);
                break;
            }
            case DOWN: {
                GL11.glRotated((double)-90.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)-90.0, (double)0.0, (double)0.0, (double)1.0);
                break;
            }
        }
        GL11.glRotated((double)rotation, (double)0.0, (double)1.0, (double)0.0);
    }

    public static void renderItem(ItemStack stack, double x, double y, double z, double rotationX, double rotationY, double rotationZ, double size, ForgeDirection direction, double moveX, double moveY, double moveZ) {
        RenderHelper3D.renderItem(stack, x, y, z, rotationX, rotationY, rotationZ, size, direction, moveX, moveY, moveZ, null);
    }

    public static void renderItem(ItemStack stack, double x, double y, double z, double rotationX, double rotationY, double rotationZ, double size, ForgeDirection direction, double moveX, double moveY, double moveZ, IIcon icon) {
        if (stack.func_77973_b() != null) {
            ResourceLocation resourcelocation = RenderHelper3D.mc.field_71446_o.func_130087_a(stack.func_94608_d());
            RenderHelper3D.mc.field_71446_o.func_110577_a(resourcelocation);
            TextureUtil.func_152777_a((boolean)false, (boolean)false, (float)1.0f);
            GL11.glPushMatrix();
            int b0 = 1;
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
            RenderHelper3D.applyDirection(direction);
            GL11.glTranslated((double)moveX, (double)moveY, (double)moveZ);
            GL11.glRotated((double)rotationX, (double)1.0, (double)0.0, (double)0.0);
            GL11.glRotated((double)rotationY, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)rotationZ, (double)0.0, (double)0.0, (double)1.0);
            GL11.glScaled((double)size, (double)size, (double)size);
            GL11.glEnable((int)32826);
            if (stack.func_94608_d() == 0 && stack.func_77973_b() instanceof ItemBlock && RenderBlocks.func_147739_a((int)Block.func_149634_a((Item)stack.func_77973_b()).func_149645_b())) {
                Block block = Block.func_149634_a((Item)stack.func_77973_b());
                float f9 = 0.25f;
                int k = block.func_149645_b();
                if (k == 1 || k == 19 || k == 12 || k == 2) {
                    f9 = 0.5f;
                }
                if (block.func_149701_w() > 0) {
                    GL11.glAlphaFunc((int)516, (float)0.1f);
                    GL11.glEnable((int)3042);
                    OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                }
                GL11.glScalef((float)f9, (float)f9, (float)f9);
                for (int l = 0; l < b0; ++l) {
                    GL11.glPushMatrix();
                    renderer.func_147800_a(block, stack.func_77960_j(), 1.0f);
                    GL11.glPopMatrix();
                }
                if (block.func_149701_w() > 0) {
                    GL11.glDisable((int)3042);
                }
            } else if (stack.func_77973_b().func_77623_v()) {
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                for (int j = 0; j < stack.func_77973_b().getRenderPasses(stack.func_77960_j()); ++j) {
                    IIcon iicon1 = stack.func_77973_b().getIcon(stack, j);
                    int k = stack.func_77973_b().func_82790_a(stack, j);
                    float f5 = (float)(k >> 16 & 0xFF) / 255.0f;
                    float f6 = (float)(k >> 8 & 0xFF) / 255.0f;
                    float f7 = (float)(k & 0xFF) / 255.0f;
                    GL11.glColor4f((float)f5, (float)f6, (float)f7, (float)1.0f);
                    if (icon != null) {
                        iicon1 = icon;
                    }
                    RenderHelper3D.renderDroppedItem(stack, iicon1, b0, f5, f6, f7, j);
                }
            } else {
                if (stack != null && stack.func_77973_b() instanceof ItemCloth) {
                    GL11.glAlphaFunc((int)516, (float)0.1f);
                    GL11.glEnable((int)3042);
                    OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                }
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                IIcon iicon = stack.func_77954_c();
                int i = stack.func_77973_b().func_82790_a(stack, 0);
                float f4 = (float)(i >> 16 & 0xFF) / 255.0f;
                float f5 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f6 = (float)(i & 0xFF) / 255.0f;
                if (icon != null) {
                    iicon = icon;
                }
                RenderHelper3D.renderDroppedItem(stack, iicon, b0, f4, f5, f6, 0);
                if (stack != null && stack.func_77973_b() instanceof ItemCloth) {
                    GL11.glDisable((int)3042);
                }
            }
            GL11.glDisable((int)32826);
            GL11.glPopMatrix();
            RenderHelper3D.mc.field_71446_o.func_110577_a(resourcelocation);
            TextureUtil.func_147945_b();
        }
    }

    public static void renderIcon(IIcon p_77020_2_, int p_77020_3_, float p_77020_5_, float p_77020_6_, float p_77020_7_, int pass, boolean hasEffect, int stackSize, boolean isBlock) {
        Tessellator tessellator = Tessellator.field_78398_a;
        int spritenumber = 0;
        if (!isBlock) {
            spritenumber = 1;
        }
        if (p_77020_2_ == null) {
            TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
            ResourceLocation resourcelocation = texturemanager.func_130087_a(spritenumber);
            p_77020_2_ = ((TextureMap)texturemanager.func_110581_b(resourcelocation)).func_110572_b("missingno");
        }
        float f14 = p_77020_2_.func_94209_e();
        float f15 = p_77020_2_.func_94212_f();
        float f4 = p_77020_2_.func_94206_g();
        float f5 = p_77020_2_.func_94210_h();
        float f6 = 1.0f;
        float f7 = 0.5f;
        float f8 = 0.5f;
        GL11.glPushMatrix();
        float f9 = 0.0625f;
        float f10 = 0.021875f;
        int j = stackSize;
        int b0 = 1;
        GL11.glTranslatef((float)(-f7), (float)(-f8), (float)-0.05f);
        for (int k = 0; k < b0; ++k) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(f9 + f10));
            if (spritenumber == 0) {
                RenderHelper3D.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            } else {
                RenderHelper3D.mc.field_71446_o.func_110577_a(TextureMap.field_110576_c);
            }
            GL11.glColor4f((float)p_77020_5_, (float)p_77020_6_, (float)p_77020_7_, (float)1.0f);
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)f15, (float)f4, (float)f14, (float)f5, (int)p_77020_2_.func_94211_a(), (int)p_77020_2_.func_94216_b(), (float)f9);
            if (!hasEffect) continue;
            GL11.glDepthFunc((int)514);
            GL11.glDisable((int)2896);
            RenderHelper3D.mc.field_71446_o.func_110577_a(RES_ITEM_GLINT);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)768, (int)1);
            float f11 = 0.76f;
            GL11.glColor4f((float)(0.5f * f11), (float)(0.25f * f11), (float)(0.8f * f11), (float)1.0f);
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            float f12 = 0.125f;
            GL11.glScalef((float)f12, (float)f12, (float)f12);
            float f13 = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f * 8.0f;
            GL11.glTranslatef((float)f13, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)255, (int)255, (float)f9);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glScalef((float)f12, (float)f12, (float)f12);
            f13 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f * 8.0f;
            GL11.glTranslatef((float)(-f13), (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            ItemRenderer.func_78439_a((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)255, (int)255, (float)f9);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2896);
            GL11.glDepthFunc((int)515);
        }
        GL11.glPopMatrix();
    }

    public static void renderDroppedItem(ItemStack stack, IIcon p_77020_2_, int p_77020_3_, float p_77020_5_, float p_77020_6_, float p_77020_7_, int pass) {
        RenderHelper3D.renderIcon(p_77020_2_, p_77020_3_, p_77020_5_, p_77020_6_, p_77020_7_, pass, stack.hasEffect(pass), stack.field_77994_a, stack.func_94608_d() == 0);
    }

    public static void renderLightning(double x, double y, double z, Vec3 start, Vec3 end, double thickness, int amountOfHalf, int maxDifference) {
        int i;
        int editablePoints = (int)(Math.pow(2.0, amountOfHalf) - 1.0);
        Vec3[] points = new Vec3[editablePoints + 2];
        Vec3 way = start.func_72444_a(end);
        way.field_72450_a /= (double)points.length;
        way.field_72448_b /= (double)points.length;
        way.field_72449_c /= (double)points.length;
        points[0] = start;
        points[points.length - 1] = start.func_72444_a(end);
        for (i = 1; i <= amountOfHalf; ++i) {
            int numberOfTiles = (int)Math.pow(2.0, i);
            int numberOfPoints = numberOfTiles - 1;
            for (int j = 1; j <= numberOfPoints; ++j) {
                if ((double)(j / 2) == (double)j / 2.0) continue;
                int index = (int)((double)points.length / (double)numberOfTiles * (double)j);
                int preIndex = (int)((double)(points.length - 1) / (double)numberOfTiles * (double)(j - 1));
                int postIndex = (int)((double)(points.length - 1) / (double)numberOfTiles * (double)(j + 1));
                points[index] = points[preIndex].func_72441_c(points[postIndex].field_72450_a, points[postIndex].field_72448_b, points[postIndex].field_72449_c);
                points[index].field_72450_a /= 2.0;
                points[index].field_72448_b /= 2.0;
                points[index].field_72449_c /= 2.0;
                double rotation = Math.random() * 360.0;
                double length = (double)maxDifference / Math.pow(i, 2.0);
                Vec3 sideVec = Vec3.func_72443_a((double)(Math.random() * length - length / 2.0), (double)(Math.random() * length - length / 2.0), (double)(Math.random() * length - length / 2.0));
                points[index] = points[index].func_72441_c(sideVec.field_72450_a, sideVec.field_72448_b, sideVec.field_72449_c);
            }
        }
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glEnable((int)32826);
        GL11.glColor4d((double)0.6, (double)0.6, (double)1.0, (double)0.8);
        for (i = 1; i < points.length; ++i) {
            Vec3 vec = points[i];
            Vec3 vec2 = points[i - 1];
            Vec3 player = Minecraft.func_71410_x().field_71439_g.func_70040_Z();
            Vec3 nvec = vec.func_72444_a(vec2).func_72431_c(player);
            nvec.func_72432_b();
            nvec.field_72450_a *= thickness;
            nvec.field_72448_b *= thickness;
            nvec.field_72449_c *= thickness;
            GL11.glBegin((int)9);
            GL11.glVertex3d((double)(vec.field_72450_a + nvec.field_72450_a), (double)(vec.field_72448_b + nvec.field_72448_b), (double)(vec.field_72449_c + nvec.field_72449_c));
            GL11.glVertex3d((double)(vec.field_72450_a - nvec.field_72450_a), (double)(vec.field_72448_b - nvec.field_72448_b), (double)(vec.field_72449_c - nvec.field_72449_c));
            GL11.glVertex3d((double)(vec2.field_72450_a - nvec.field_72450_a), (double)(vec2.field_72448_b - nvec.field_72448_b), (double)(vec2.field_72449_c - nvec.field_72449_c));
            GL11.glVertex3d((double)(vec2.field_72450_a + nvec.field_72450_a), (double)(vec2.field_72448_b + nvec.field_72448_b), (double)(vec2.field_72449_c + nvec.field_72449_c));
            GL11.glEnd();
        }
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2896);
    }

    public static void renderTag(String text, double x, double y, double z, int distance) {
        double d3 = Math.sqrt(RenderManager.field_78727_a.func_78714_a(x, y, z));
        FontRenderer fontrenderer = RenderHelper3D.mc.field_71466_p;
        float f = 1.6f;
        float f1 = 0.016666668f * f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.0f), (float)((float)y), (float)((float)z));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-RenderManager.field_78727_a.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)RenderManager.field_78727_a.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)(-f1), (float)(-f1), (float)f1);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        Tessellator tessellator = Tessellator.field_78398_a;
        int b0 = 0;
        if (text.equals("deadmau5")) {
            b0 = -10;
        }
        GL11.glDisable((int)3553);
        tessellator.func_78382_b();
        int j = fontrenderer.func_78256_a(text) / 2;
        tessellator.func_78369_a(0.0f, 0.0f, 0.0f, 0.25f);
        tessellator.func_78377_a((double)(-j - 1), (double)(-1 + b0), 0.0);
        tessellator.func_78377_a((double)(-j - 1), (double)(8 + b0), 0.0);
        tessellator.func_78377_a((double)(j + 1), (double)(8 + b0), 0.0);
        tessellator.func_78377_a((double)(j + 1), (double)(-1 + b0), 0.0);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        fontrenderer.func_78276_b(text, -fontrenderer.func_78256_a(text) / 2, b0, 0x20FFFFFF);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        fontrenderer.func_78276_b(text, -fontrenderer.func_78256_a(text) / 2, b0, -1);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public static void renderWorldCubes(RenderBlocks renderer, Block block, int meta, ArrayList<CubeObject> cubes, int x, int y, int z) {
        for (int i = 0; i < cubes.size(); ++i) {
            renderer.func_147782_a(cubes.get((int)i).minX, cubes.get((int)i).minY, cubes.get((int)i).minZ, cubes.get((int)i).maxX, cubes.get((int)i).maxY, cubes.get((int)i).maxZ);
            if (cubes.get((int)i).icon != null) {
                renderer.func_147757_a(cubes.get((int)i).icon);
            }
            if (cubes.get((int)i).block != null) {
                if (cubes.get((int)i).meta != -1) {
                    renderBlocks.func_147771_a();
                    renderBlocks.func_147782_a(cubes.get((int)i).minX, cubes.get((int)i).minY, cubes.get((int)i).minZ, cubes.get((int)i).maxX, cubes.get((int)i).maxY, cubes.get((int)i).maxZ);
                    RenderHelper3D.renderBlocks.meta = cubes.get((int)i).meta;
                    renderBlocks.func_147769_a(cubes.get((int)i).block, x, y, z);
                    return;
                }
                renderer.func_147757_a(cubes.get((int)i).block.func_149733_h(0));
            }
            renderer.func_147784_q(block, x, y, z);
            if (cubes.get((int)i).icon == null && cubes.get((int)i).block == null) continue;
            renderer.func_147771_a();
        }
    }
}

