/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.railcraft.handlers;

import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.mods.railcraft.RailcraftHelper;
import modtweaker2.utils.BaseCraftingAddition;
import modtweaker2.utils.BaseCraftingRemoval;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.railcraft.Rolling")
public class RollingMachine {
    public static final String name = "Railcraft Rolling Machine";

    @ZenMethod
    public static void addShaped(IItemStack output, IIngredient[][] ingredients) {
        MineTweakerAPI.apply((IUndoableAction)new Add((IRecipe)new ShapedOreRecipe(InputHelper.toStack(output), InputHelper.toShapedObjects(ingredients))));
    }

    @ZenMethod
    public static void addShapeless(IItemStack output, IIngredient[] ingredients) {
        MineTweakerAPI.apply((IUndoableAction)new Add((IRecipe)new ShapelessOreRecipe(InputHelper.toStack(output), InputHelper.toObjects(ingredients))));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient ingredient) {
        List<IRecipe> recipes = BaseCraftingRemoval.getRecipes(RailcraftHelper.rolling, ingredient);
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipes found for %s. Command ignored!", name, ingredient.toString()));
        }
    }

    private static class Remove
    extends BaseCraftingRemoval {
        public Remove(List<IRecipe> recipes) {
            super(RollingMachine.name, RailcraftHelper.rolling, recipes);
        }
    }

    private static class Add
    extends BaseCraftingAddition {
        public Add(IRecipe recipe) {
            super(RollingMachine.name, RailcraftHelper.rolling);
            this.recipes.add(recipe);
        }
    }
}

